/* 
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/libdl/RCS/dlist.c,v $
 * $Revision: 1.1 $
 * $Date: 1992/04/08 05:52:45 $
 * $Author: moore $
 */

#include <stdio.h>    /* Basic includes and definitions */
#include "dlist.h"

#define boolean int
#define TRUE 1
#define FALSE 0


/*---------------------------------------------------------------------*
 * PROCEDURES FOR MANIPULATING DOUBLY LINKED LISTS 
 * Each list contains a sentinal node, so that     
 * the first item in list l is l->flink.  If l is  
 * empty, then l->flink = l->blink = l.            
 *---------------------------------------------------------------------*/

Dlist make_dl()
{
  Dlist d;

  d = (Dlist) malloc (sizeof(struct dlist));
  d->flink = d;
  d->blink = d;
  d->val = (char *) 0;
  return d;
}
 
dl_insert_b(node, val)	/* Inserts to the end of a list */
Dlist node;
char *val;
{
  Dlist last_node, new;

  new = (Dlist) malloc (sizeof(struct dlist));
  new->val = val;

  last_node = node->blink;

  node->blink = new;
  last_node->flink = new;
  new->blink = last_node;
  new->flink = node;
}

dl_delete_node(item)		/* Deletes an arbitrary iterm */
Dlist item;
{
  item->flink->blink = item->blink;
  item->blink->flink = item->flink;
  free(item);
}

dl_delete_list(l)
Dlist l;
{
  Dlist d, next_node;

  d = l->flink;
  while(d != l) {
    next_node = d->flink;
    free(d);
    d = next_node;
  }
  free(d);
}
