/*
 * $Source: /a/thud/chalk/homes/moore/src/hence/master/include/RCS/hence.h,v $
 * $Revision: 1.1 $
 * $Date: 1992/04/08 05:52:24 $
 * $Author: moore $
 */

/* rb.h and dlist.h should be included before here */

#define EXPRESSION 0
#define PARAM 1
#define NODE 2

typedef struct array {	/* The representation of array constants */
  union {
    char *c;		/* Pointer to raw hunk of bytes */
    int *i;
    double *d;
    float *f;
  } v;
  void *ptr;		/* Indirection pointer */
  int type;		/* Type of v */
  int ndims;		/* Number of indirections */
  int tsize;		/* # of elements in v */
  int *size;		/* Size of each dimension */
  int *indsize;		/* Increment of number of elements per counter in
			   each dimension */
  struct {
    unsigned ptr  : 1;
    unsigned v    : 1;
    unsigned init : 1;
    unsigned junk : 5;
  } refd;
} *Array;

extern Array brand_new_array(/* type, ndims */);
extern Array copy_array(/* old array */);

#define h_l_bnd(e) ((e)->args[0]->val.i)
#define h_h_bnd(e) ((e)->args[(e)->nargs-1]->val.i)

typedef struct expression {  /* The representation of expressions */
  char elt_type;	/* The kind of expression: e.g. '*', '-', 'c' */
  int type;		/* The type of the expression */
  union {		/* The expression's value */
    char *s;
    int i;
    char c;
    Array a;
    struct parameter *p;
    double d;
    float f;
  } val;
  int nargs;		/* Number of arguments: e.g. for '+' = 2 */
  struct expression *args[3];  /* The arguments */
} exp_list;
typedef struct expression *Exp;

extern Exp last_exp();
extern Exp last_exp_peek();
extern int exp_comp(/* exp1, exp2 */);
extern Exp get_exp(/* Parameter array */);
extern Dlist get_aa( /* */ );
extern Array get_array( /* */ );
extern Exp copy_exp(/* exp */);
extern Exp make_null_exp(/* type */);
extern Exp make_null_array(/* type */);
extern void segv_catch();
extern char *sl_id();

extern char getbyte();
extern float getfloat();
extern double getdouble();

extern char *getlstring();

typedef struct param_array {	/* Information for array parameters */
  int type;		/* The type of the array elements */
  int nadims;		/* The number of dimensions of the array */
  int ndims;		/* The number of dimensions of the array parameter */
  Exp *dims;		/* The dimension expressions */
  Rb_node p;		/* The level-2 array parameters */
  int n_level2;		/* The # of level-2 array parameters */
  struct parameter *main;	/* (For level-2 params): The level-1 param */
} *Parray;
extern Parray new_parray();

typedef struct {
    unsigned in   : 1;
    unsigned out  : 1;
    unsigned inj  : 1;
    unsigned new  : 1;
    unsigned main : 1;
    unsigned used : 1;
    unsigned junk : 2;
} param_flags;

typedef struct parameter {	/* Representation of parameters */
  char *name;		/* The name */
  int num;		/* The parameter number (set in execute.c) */
  param_flags io;	/* All the flags */
  int type;		/* The type */
  Parray a;		/* Array info if type = ARRAY */
  int inj;		/* The injected value, if it's injected */
  Exp val;		/* The initialization value */
  int state;		/* State field for various manipulation */
  struct parameter *mirror;	/* Field to help copying parameters */
} param;
typedef param *Param;

extern int param_comp();
extern Param copy_param();
extern Param new_param();

typedef struct {	/* Information about ancestors holding arrays */
  void *anc;
  char *sub_name;
  int pvminum;
  int apnum;
  int mypnum;
} array_anc;
typedef array_anc *Array_anc;
  
typedef struct xyloc {
  int set;
  int x;
  int y;
} xyloc;

#define NORMAL 0
#define COND 1
#define END_COND 2
#define LOOP 3
#define END_LOOP 4
#define FANOUT 5
#define FANIN 6
#define PIPE 7
#define END_PIPE 8

#define NOT_BEGUN 0
#define READY 1
#define RUNNING 2
#define DONE 3
#define DEAD 4

typedef struct anc_list {	/* Ordered list of ancestors */
  Rb_node elts;		/* key: ancestor node, val = pointer in "order" */
  Rb_node order;	/* key: distance, val = ancestor node */
} *Anc;

extern Anc new_anc_list();
extern free_anc_list();
extern update_anc_list();

typedef struct a_node {  /* Representation of a node */
  int node_type;	/* Node's type: e.g. NORMAL */
  xyloc xy;
  int id;		/* Node's id */
  int inst;             /* Instance number for the node */
  int *instgen;		/* Instance number generator */
  int nparams;		/* Number of parameters */
  Rb_node params;       /* Parameters: RB_Tree: 
                           key: Param name p->name
                           val: Param pointer p */
  char *sub_name;	/* Subroutine name */
  Param ret_param;	/* The return parameter (or ind var in FAN's, PIPES) */
  char arrays;		/* Boolean: Are there any array params */
  int nargs;		/* Number of args to the subroutine */
  Exp *args;		/* Array of args to the subroutine */
  Rb_node parents;      /* Parent nodes:  Rb_tree:
                           key, val: node pointer (sorted as an int) */
  int nparents;		/* The number of parents */
  Rb_node children;     /* Child nodes:  Rb_tree:
                           key, val: node pointer (sorted as an int) */
  int nchildren;	/* The number of children */
  struct a_node *pair;  /* Pair nodes: LOOP-ENDLOOP, etc. */
  struct a_node *scope; /* For static error checking */
  int flags;		/* Random manipulative variable */
  int pvminum;    	/* Pvm instance number */
  int state;            /* State (e.g. READY, RUNNING, DONE).  If the 
                           state is negative, it is the number of parents
                           that this node is waiting for. */
  char *machine;        /* Machine name */
  Anc anc;              /* Ancestor information */
  Dlist aa;		/* Ancestor/Array information */
  struct a_node *mirror;/* For help in copying */
  long ttime;		/* Total time, from initiateM to rcv */
  long stime;		/* Total slave time */
  long sbtime;		/* Total subroutine time */
} node;
typedef node *Node;

extern Node copy_node();

#define CNULL (char *)0
#define PNULL (Param)0
#define PANULL (Parray)0
#define ENULL (Exp)0
#define NNULL (Node)0

typedef struct graph {
  int numnodes;
  int numdone;
  int numexecuting;
  Dlist readyq; 	/* Nodes ready to be executed */
  Rb_node alive;	/* Nodes done but not dead:
                           Key & val: Node pointer sorted as an int */

  Rb_node nlist;  /* Tree of nodes indexed by id number.  This is 
                     not updated when execution begins (i.e. always points
                     to instance 0 */
  Rb_node heads;  /* The head nodes of the graph (no parents) */

                        /* For both of these, see cost.c */
  Rb_node machines;	/* Machine list: key=machine name, val=machine ptr */
  Rb_node subroutines;  /* Subroutine list: key=sub name, val=sub ptr */

  char *pvmproc;	/* Pvm process name */
  int pvminum;		/* Pvm instance number */

  char *cost_mat;	/* Cost matrix file name */
  char *graph_file;	/* Graph file name ("-" for stdin) */
  char *trace_file;	/* Trace file name ("-" for stdout) */
  char trace_msgs;	/* Trace pvm messages */

} *Graph;

extern char *get_machine();

extern char *node_types[];
extern char *node_states[];

