#
#	dag.l
#
#	Scanner for graph descriptions.
#
#	3 Dec 1990  Manchek  manchek@CS.UTK.EDU.
#

D		[0-9]
L		[a-zA-Z_]
ID		{L}({L}|{D})*
INT		({D}+)
F		({D}+[.]{D}*)|({D}*[.]{D}+)
QUO             ["]
TYPE		"int"|"float"|"double"|"char"|"INT"|"FLOAT"|"DOUBLE"|"CHAR"

%%

"/*"			{
                          char c;
                          loop:
			  for (c = input(); c != '*'; c = input()) {
    			    if (c == EOF || c == '\0') {
     			      fprintf(stderr, "EOF in comment\n");
                              yyerror();
            		    }
			  }
			  c = input();
                          if (c != '/') {
                            unput(c);
                            goto loop;
                          }
                        }
{QUO}			{
                          int i, sz;
			  char *str, bksl, c;
 
       			  i = 0;
                          sz = 21;
                          bksl = 0;
                          str = (char *) n_malloc(20*sizeof(char));
                          for (c = input(); c != '"' || bksl ; c = input()) {
                            if (i == sz - 1) {
			      sz += 20;
                              str = (char *) n_realloc(str, sz);
                            }
                            if (c == EOF) {
			      fprintf(stderr, 
			        "ERROR: EOF in string constant\n");
			      yyerror();
			    } else if (c == '\n') {
			      fprintf(stderr, 
			        "ERROR: Newline in string constant\n");
			      yyerror();
			    } else if (c == '\0') {
			      fprintf(stderr, 
			        "ERROR: Null in string constant\n");
			      yyerror();
                            } else if (bksl) {
                              if (c == 'n') str[i] = '\n';
			      else if (c == 't') str[i] = '\t'; 
			      else if (c == 'b') str[i] = '\b'; 
			      else str[i] = c;
                              bksl = 0;
                              i++;
 			    } else if (c == '\\') {
			      bksl = 1;
			    } else {
			      str[i] = c;
			      i++;
			    }
			  }
			  str[i] = '\0';
			  yy_last_str = copy_string(str);
                          n_free(str);
			  return TK_string;
			}
"PROGRAM"		{ return TK_PROGRAM; }
"NODE"			{ return TK_NODE; }
"ARC"			{ return TK_ARC; }
"NEW" 			{ return TK_NEW; }
"ENDSWITCH"		{ return TK_END_COND; }
"BEGINSWITCH"		{ return TK_COND; }
"ENDLOOP"		{ return TK_END_LOOP; }
"BEGINLOOP"		{ return TK_LOOP; }
"ENDPIPE"		{ return TK_END_PIPE; }
"BEGINPIPE"		{ return TK_PIPE; }
"FANOUT"		{ return TK_FANOUT; }
"FANIN"			{ return TK_FANIN; }
"TO"			{ return TK_TO; }
{TYPE}			{ return TK_type; }
{ID}			{ (void) strcpy(yy_last_id, yytext); return TK_id; }
{F}			{ yy_last_float = (float) atof(yytext); 
                          return TK_float; }
{INT}			{ yy_prev_int = yy_last_int;
                          yy_last_int = atoi(yytext); return TK_int; }
"<>"			{ return TK_IO; }
"<<"			{ return TK_LS; }
">>"			{ return TK_RS; }
"!="			{ return TK_NE; }
"=="			{ return TK_EQ; }
"<="			{ return TK_LE; }
">="			{ return TK_GE; }
"&&"			{ return TK_AND; }
"||"			{ return TK_OR; }
".."			{ return TK_DDOTS; }
"\n"			;
[ \t]+			;
.				{ return (int)(*yytext); }

%%


