/*
 *	HeNCE Tool
 *
 *	xsetup.c - X resources, etc for starting up.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log: xsetup.c,v $
 * Revision 1.4  1992/09/18  01:56:28  moore
 * add #include <sys/stat.h> to satisfy somebody
 *
 * Revision 1.3  1992/06/25  23:55:24  moore
 * set "input" resource to True for all widgets (in fallbacks) in an
 * attempt to improve compatibility with brain-dead window managers.
 *
 * Revision 1.2  1992/05/29  19:18:45  moore
 * get rid of subdefs stuff unless there is a subDefs resource
 *
 * Revision 1.1  1992/04/08  05:51:00  moore
 * initial RCS version
 *
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "xincl.h"
#include "xcomn.h"
#include "comn.h"
#include "msg.h"
#include "patchlevel.h"
#include "tilde.h"

/* Compose Canvas default translations */

static char nodeCanTran[] =
"*composeNodeCan.translations:\
!Ctrl<Btn1Down>:del-node()\\n\
!Shift<Btn1Down>:move-node(b)\\n\
<Btn1Down>:add-node()\\n\
<Btn1Motion>:move-node(d)\\n\
<Btn1Up>:move-node(f)\\n\
!<Btn2Down>:add-arc(b)\\n\
!Ctrl<Btn2Down>:del-arc()\\n\
!Shift<Btn2Down>:move-arc(b)\\n\
<Btn2Motion>:add-arc(d)move-arc(d)\\n\
<Btn2Up>:add-arc(f)move-arc(f)\\n\
<Leave>:move-arc(c)add-arc(c)move-node(c)\\n\
!<Btn3Down>:edit-node(p)\\n\
!Shift<Btn3Down>:edit-node(s)\\n\
";

/* Add'l cost matrix buttons */

static char configMatTran[] =
"*costMatrix.translations:#override\\n\
<Key>h:highlight(l)\\n\
<Key>j:highlight(d)\\n\
<Key>k:highlight(u)\\n\
<Key>l:highlight(r)\\n\
<Key>space:highlight(r)\\n\
";

static char subMatTran[] =
"*subMatrix.translations:#override\\n\
<Key>space:highlight(r)\\n\
";

static char hostMatTran[] =
"*hostMatrix.translations:#override\\n\
<Key>space:highlight(r)\\n\
";

/* Application default values */

static char *fallbacks[] = {
	"*input:True",				/* for compatibility with brain-dead window mgrs. */
	"*allowShellResize:true",
	"*composeNodeVp.width:800",
	"*composeNodeVp.height:600",
	"*composeNodeCan.width:1000",
	"*composeNodeCan.height:1000",
	"*infoBox.width:800",
	nodeCanTran,
	configMatTran,
	subMatTran,
	hostMatTran,
	"*traceNodeVp.width:800",
	"*traceNodeVp.height:600",
	"*traceNodeCan.width:1000",
	"*traceNodeCan.height:1000",
	/*
	 * custom resources go here
	 * 
	 * XXX some of these need to be initialized at compile time
	 * based on configuration-specific data.
	 */
	"*binDir: $(HOME)/pvm/$(ARCH)",
	"*editorCommand: xterm -title %s -e vi %s",
	"*henceLibDir: $(HOME)/hence/$(ARCH)",
	"*iconList: ~/htool_icons",
	"*includeDir: $(HOME)/hence/include",
	"*language: C",
	"*pvmd: /tmp/pvm/pvmd",
	"*pvmHostFile: /dev/null",
	"*pvmLib: $(HOME)/pvm/$(ARCH)/libpvm.a",
	/* "*reverseVideo:off", */
	/* "*subDefsFile: sub.defs", */
	"*traceFile: hence.trace",
	"*xtermCommand: xterm",
	0
};

/* For custom resources */

typedef struct {
	char *binDir;		/* where node programs should be installed  */
	char *editor;		/* for text editing */
    char *henceLibDir;	/* where hence node library lives */
	char *iconList;		/* file mapping machine names to bitmap files */
	char *includeDir;  	/* where hence include files live */
	char *language;		/* default language for node programs */
	Bool mono;			/* force monochrome display */
	char *pvmdExecPath;	/* where pvmd program lives */
	char *pvmHostFile;	/* master "pvm" hosts file */
	char *pvmLib;		/* where pvm library files live */
	Bool rvideo;		/* for monochrome */
	char *subDefsFile;  /* where sub.defs file lives */
	char *traceFileName;/* default HeNCE executioner trace file */
	char *xtermCommand;	/* where xterm lives */

	char *exitColor;	/* node exited color */
	char *notReadyColor;/* node not ready color */
	char *startedColor;	/* node started color */
	char *executingColor;/* node executing color */
	char *completedColor;/* node completed color */
	char *warningColor;	/* warning in graph color */
	char *errorColor;	/* error in graph color */

#if 1
	/* XXX rip this out if you find it, it's a hack to set the bg col */
	Pixel dbgc;
#endif
} app_res_t, *app_resp_t;

static app_res_t app_res;

static XtResource res_list[] = {
    { "binDir", "BinDir", XtRString, sizeof (String),
		  XtOffset(app_resp_t, binDir), XtRString, "" },
	{ "editorCommand", "EditorCommand", XtRString, sizeof(String),
		  XtOffset(app_resp_t, editor), XtRString, "" },
	{ "henceLibDir", "HenceLibDir", XtRString, sizeof (String),
		  XtOffset(app_resp_t, henceLibDir), XtRString, "" },
	{ "iconList", "IconList", XtRString, sizeof (String),
		  XtOffset(app_resp_t, iconList), XtRString, "" },
	{ "includeDir", "IncludeDir", XtRString, sizeof(String),
		  XtOffset(app_resp_t, includeDir), XtRString, "" },
	{ "language", "Language", XtRString, sizeof (String),
		  XtOffset(app_resp_t, language), XtRString, "" },
	{ "monochrome", "Monochrome", XtRBool, sizeof(Bool),
		  XtOffset(app_resp_t, mono), XtRString, "off" },
	{ "pvmd", "Pvmd", XtRString, sizeof (String),
		  XtOffset(app_resp_t, pvmdExecPath), XtRString, "" },
	{ "pvmHostFile", "PvmHostFile", XtRString, sizeof (String),
		  XtOffset(app_resp_t, pvmHostFile), XtRString, "" },
	{ "pvmLib", "PvmLib", XtRString, sizeof (String),
		  XtOffset(app_resp_t, pvmLib), XtRString, "" },
	{ "reverseVideo", "ReverseVideo", XtRBool, sizeof(Bool),
		  XtOffset(app_resp_t, rvideo), XtRString, "off" },
	{ "subDefsFile", "SubDefsFile", XtRString, sizeof (String),
		  XtOffset(app_resp_t, subDefsFile), XtRString, "" },
	{ "traceFile", "TraceFile", XtRString, sizeof (String),
		  XtOffset(app_resp_t, traceFileName), XtRString, "" },
	{ "xtermCommand", "XtermCommand", XtRString, sizeof (String),
		  XtOffset(app_resp_t, xtermCommand), XtRString, "" },

	{ "exitColor", "ExitColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, exitColor), XtRString, "maroon" },
	{ "notReadyColor", "NotReadyColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, notReadyColor), XtRString, "grey" },
	{ "startedColor", "StartedColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, startedColor), XtRString, "tan" },
	{ "executingColor", "ExecutingColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, executingColor), XtRString, "green" },
	{ "completedColor", "CompletedColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, completedColor), XtRString, "magenta" },
	{ "warningColor", "WarningColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, warningColor), XtRString, "orange" },
	{ "errorColor", "ErrorColor", XtRString, sizeof (String),
		  XtOffset(app_resp_t, errorColor), XtRString, "red" },

#if 1
	{ "mainForm.composeNodeCan.background", "Background", XtRPixel,
		  sizeof(Pixel), XtOffset(app_resp_t, dbgc), XtRString,
		  XtDefaultBackground },
#endif
};

static XrmOptionDescRec knownargs[] = {
	{ "-mono", ".monochrome", XrmoptionNoArg, "on" },
	{ "+mono", ".monochrome", XrmoptionNoArg, "off" },
};

static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];

main(argc, argv)
	int argc;
	char **argv;
{
	setup(&argc, argv);
	XtAppMainLoop(context);
}

#if 0
static int
fatal_x_error (display, errorEvent)
Display *display;
XErrorEvent *errorEvent;
{
	char buf[100];
	XGetErrorText (display, errorEvent->error_code, buf, sizeof (buf));
	fprintf (stderr, "Fatal X Error (%d.%d): %s\n",
			 errorEvent->request_code, errorEvent->minor_code,
			 buf);
	fflush (stderr);
	abort ();
}
#endif

/*	setup()
 *
 *	Get resources and setup main widget.
 */

setup(argc, argv)
	int *argc;
	char **argv;
{
	int n;
	int message();
	char crud[1024];

	n = 0;

	topLevel = XtAppInitialize(&context, "htool",
		knownargs, XtNumber(knownargs),
		argc, argv,
		fallbacks,
		args, n);

	if (*argc > 1) {
		int i;

		for (i = 1; i < *argc; i++) {
			if (strcmp (argv[i], "-help") == 0) {
				fprintf (stderr, "htool version %s\n", HTOOL_VERSION);
				fprintf (stderr, "usage: htool [options]\n");
				fprintf (stderr, "options are:\n");
				fprintf (stderr, "\
-help                   print this message\n\
-mono                   force monochrome mode even on a color display\n\
-xrm 'name:resource'    set a resource from the command line\n");
				fprintf (stderr, "\
Other options can be set via the X resource database, xrdb\n");
			}
#if 0
			else if (strcmp (argv[i], "-debug") == 0) {
				XSetErrorHandler (fatal_x_error);
			}
#endif
			else {
				fprintf (stderr, "htool: unknown option <%s>\n", argv[i]);
			}
		}
		exit(1);
	}
	xDisp = XtDisplay(topLevel);
	xScrn = DefaultScreen(xDisp);
	xRootW = RootWindow(xDisp, xScrn);
	xDispWd = DisplayWidth(xDisp, xScrn);
	xDispHt = DisplayHeight(xDisp, xScrn);

#if 0
	init_hostmap_stuff(topLevel);
#endif

	XtGetApplicationResources(topLevel, (caddr_t)&app_res,
		res_list, XtNumber(res_list), 0, 0);

	/*
	 * initialize some variables from X resources.
	 *
	 * XXX some of these can be changed from htool and thus need
	 * to be initialized here.  Others cannot be changed, and so
	 * there is no reason to copy them yet again and have two
	 * variables to name a particular quantity.
	 */
	binDir = app_res.binDir;				/* XXX */
	editorCommand = app_res.editor;			/* XXX */
	henceLibDir = strsave (texpand (app_res.henceLibDir));		/* XXX */
	iconList = app_res.iconList;			/* XXX */
	includeDir = strsave (texpand (app_res.includeDir));		/* XXX */
	languageString = app_res.language; 
	pvmdExecPath = app_res.pvmdExecPath;	/* XXX */
	pvmHostFile = strsave (texpand (app_res.pvmHostFile));		/* XXX */
	pvmLib = strsave (texpand (app_res.pvmLib));				/* XXX */
	if (app_res.subDefsFile && *app_res.subDefsFile)
		subDefsFile = strsave (texpand (app_res.subDefsFile));
	else
		subDefsFile = NULL;
	if (app_res.traceFileName)
		traceFileName = strsave (texpand (app_res.traceFileName));
	else
		traceFileName = NULL;
	xtermCommand = app_res.xtermCommand;	/* XXX */
	/*
	 * end of initialization from X resources
	 */

	setup_color(topLevel, app_res.mono, app_res.rvideo);

	cre_mainwid();

	XtRealizeWidget(topLevel);

	xgr_Init();

	/*
	 * can't do this until after we've initialized the X stuff.
	 */
	msg_SetWriteFunction (message);
    msg_Format ("HeNCE tool v%s\n", HTOOL_VERSION);

	SetTraceFileLabel ();		/* in widmain.c */

#if 0
	getcwd (crud, sizeof crud);
	currentDirectory = strsave (crud);
#else
	currentDirectory = NULL;
#endif
	set_directory();
	set_language(0);			/* 0 == set from defaults */
}

/*	setup_color()
*
*	Get color resources we need or bail to b&w.
*/

/* ConvertColor is from the MIT Xaw examples    */
static int
ConvertColor(w, color_name)
Widget w;
char * color_name;
{
  XrmValue from, to;

  from.size = strlen(color_name) + 1;
  from.addr = color_name;

/*
 * This conversion accepts a colorname from rgb.txt, or a #rrrgggbbb
 * rgb color definition, or the special toolkit strings "XtDefaultForeground"
 * and "XtDefaultBackground".
 */

  XtConvert(w, XtRString, (XrmValuePtr) &from, XtRPixel, (XrmValuePtr) &to);
  if (to.addr == NULL) {
      return(-1);
  }

  return( (int) *((Pixel *) to.addr) );
}

setup_color(w, forcemono, rvideo)
	Widget w;
    int forcemono;
    int rvideo;
{
    int ccells = DisplayCells(xDisp, xScrn);

    if (rvideo) {
        bp = WhitePixel(xDisp, xScrn);
        wp = BlackPixel(xDisp, xScrn);
   
    } else {
        bp = BlackPixel(xDisp, xScrn);
        wp = WhitePixel(xDisp, xScrn);
    }

	mycolor[COLFGND] = bp;
	mycolor[COLBGND] = wp;

    if ((!forcemono) && (ccells > 2)) {
		inColor = 1;

        if (-1 == (mycolor[COLCOMPLETED] = ConvertColor(w, app_res.completedColor))) {
			inColor = 0;
			mycolor[COLCOMPLETED] = bp;
		}

        if (-1 == (mycolor[COLERROR] = ConvertColor(w, app_res.errorColor))) {
			inColor = 0;
			mycolor[COLERROR] = bp;
		}

        if (-1 == (mycolor[COLSTARTED] = ConvertColor(w, app_res.startedColor))) {
			inColor = 0;
			mycolor[COLSTARTED] = bp;
		}

        if (-1 == (mycolor[COLEXECUTING] = ConvertColor(w, app_res.executingColor))) {
			inColor = 0;
			mycolor[COLEXECUTING] = bp;
		}

        if (-1 == (mycolor[COLEXIT] = ConvertColor(w, app_res.exitColor))) {
			inColor = 0;
			mycolor[COLEXIT] = bp;
		}

        if (-1 == (mycolor[COLNOTREADY] = ConvertColor(w, app_res.notReadyColor))) {
			inColor = 0;
			mycolor[COLNOTREADY] = bp;
		}

        if (-1 == (mycolor[COLWARNING] = ConvertColor(w, app_res.warningColor))) {
			inColor = 0;
			mycolor[COLWARNING] = bp;
		}

    } else {
		inColor = 0;
		mycolor[COLCOMPLETED] = mycolor[COLERROR] =
		mycolor[COLSTARTED] = mycolor[COLEXECUTING] =
		mycolor[COLEXIT] = mycolor[COLNOTREADY] =
		mycolor[COLWARNING] = bp;
	}
    return;
}



/*
 * Local variables:
 * tab-width:4
 * End:
 */
