#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#endif

#define FRACTIME 1
#define HAIRLINE 1

#ifdef FRACTIME
struct EventTime {
    long secs;
    int millisecs;
};
#endif

struct Event {
#ifdef FRACTIME
    struct EventTime time;
#else
    long time;
    long fractime;
#endif
    int state;
    int hostno;
};

int getNextEvent __((struct Event *nextEvent));
void getState __((struct Event *savedState, int numHosts,
				 struct EventTime *mintime));
void hist_Create __((Widget parent, char **hosts, int numHosts));
void hist_SetEpoch __((struct EventTime *t));
void hist_SetEndOfTime __((struct EventTime *t));
#ifdef HAIRLINE
void hist_ClearHairLine __(());
void hist_SetHairLine __((struct EventTime *t, int moveok));
#endif
int hist_MsecPerPixel __((long *));

#define HISTO_OFF		0
#define HISTO_RUNNING	1
#define HISTO_IDLE		2
#define HISTO_ERROR		3

#undef __


/*
 * Local variables:
 * tab-width:4
 * End:
 */
