
#ifndef _HgwMatrix_h
#define _HgwMatrix_h

/*
*	Matrix.h - Public Include for Matrix Widget
*
*	Jul 1991 Robert Manchek  manchek@CS.UTK.EDU.
*/

#include <X11/Xaw/Simple.h>
#include <X11/Xmu/Converters.h>

/**************
*  Resources  *
*             *
**************/

/*
Name               Class              RepType          Default Value
----               -----              -------          -------------
background         Background         Pixel            XtDefaultBackground
base               Base               Pointer          NULL
callback           Callback           Pointer          NULL
columns            Columns            Integer          0
columnSpacing      ColumnSpacing      Integer          100
columnOffset       ColumnOffset       Integer          0
cursor             Cursor             Cursor           None
destroyCallback    Callback           Pointer          NULL
editable           Editable           Boolean          True
font               Font               XFontStruct*     XtDefaultFont
foreground         Foreground         Pixel            XtDefaultForeground
height             Height             Dimension        rows * rowSpacing
insensitiveBorder  Insensitive        Pixmap           Gray
mappedWhenManaged  MappedWhenManaged  Boolean          True
numeric            Numeric            Boolean          False
resize             Resize             Boolean          True
rows               Rows               Integer          0
rowSpacing         RowSpacing         Integer          text height + 4
rowOffset          RowOffset          Integer          0
sensitive          Sensitive          Boolean          True
translations       Translations       TranslationTable Default
width              Width              Dimension        columns * columnSpacing
x                  Position           Position         0
y                  Position           Position         0
*/

#define	HgwNrows		"rows"
#define	HgwNcols		"columns"
#define	HgwNrowSpacing	"rowSpacing"
#define	HgwNcolSpacing	"columnSpacing"
#define	HgwNrowOffset	"rowOffset"
#define	HgwNcolOffset	"columnOffset"
#define	HgwNbase		"base"
#define	HgwNeditable	"editable"
#define	HgwNnumeric		"numeric"

#define	HgwCrows		"Rows"
#define	HgwCcols		"Columns"
#define	HgwCrowSpacing	"RowSpacing"
#define	HgwCcolSpacing	"ColumnSpacing"
#define	HgwCrowOffset	"RowOffset"
#define	HgwCcolOffset	"ColumnOffset"
#define	HgwCbase		"Base"
#define	HgwCeditable	"Editable"
#define	HgwCnumeric		"Numeric"

extern WidgetClass matrixWidgetClass;

typedef struct _MatrixClassRec *MatrixWidgetClass;
typedef struct _MatrixRec *MatrixWidget;

#endif /* _HgwMatrix_h */

/*
 * Local variables:
 * tab-width:4
 * End:
 */
