#include <math.h>
#define INITENG     2.0    /* gamma */
#define J           1.0     /* current density:  kA/(cm*cm) */
#define CAVILEN     1.0E06  /* cavity length in unit of radiation wavelength */
#define L           20.0    /* cavity length in cm */
#define STEP        0.005   /* z step (normalized to je^(1/3)) */
#define ZMAX        20.0    /* limits the number of peaks */
#define RESOL       0.07    /* spacing of data points on z axis */
#define INITFIELD   0.02    /* noise level */
#define NUMPART     2000    /* the number of test particles */
#define OFFSET      1.303   /* the detuning factor */
#define I0          17.0    /* kA */
#define TWOPI       6.28318530717959
#define gam(beta)   (1.0/sqrt(1.0 - beta*beta))

init(beta0, gamma_p, g0, je, gs, Es, dz, Er, Ei, dphi)
double  *beta0, *gamma_p, *g0, *je, *gs, *Es, *dz, *Er, *Ei, *dphi;
{
    double        jc, KL, betap;
    register int  i;

    printf("init\n");
    /* constants */
    *beta0 = sqrt(1.0 - 1.0/(INITENG*INITENG));
    KL = TWOPI*CAVILEN;
    betap = *beta0*(1.0 - 2.0*OFFSET/KL);
    *gamma_p = gam(betap);
    *g0 = KL/(INITENG*INITENG*INITENG*(*beta0)*(*beta0));
    *je = *g0*J*L*L/I0;
    jc = cbrt(*je);      /* scaling factor for z */
    *gs = jc/(*g0);         /* for gamma */
    *Es = sqrt(J*(*gs));    /* for E */
    *dz = STEP/jc;       /* un-normalize it */

    /* initialization */
    *Er = INITFIELD*(*Es);  *Ei = 0.0;
    *dphi = TWOPI/(double)NUMPART;
    printf("%0.4g     %0.4g     %0.4g\n", *Er, *Ei, *dphi);
}
