/* The following macro depends on the variables a and nca */

#define A(i,j) (*(a + (i)*nca + (j)))

/* The following macro depends on the variables b and ncb */

#define B(i,j) (*(b + (i)*ncb + (j)))

/*
 * trisolve(int m, int n, double *a, int nca, double *b, int ncb)
 *
 * Solve the matrix equation
 *
 *     a*x=b
 * 
 * where x and b are m by n matrices, and a is an m by m unit lower triangular
 * matrix.  b is overwritten by x on output.
 */
void
trisolve(m, n, a, nca, b, ncb)
double *a, *b;
{
    int i, j, k;

    for(j = 0; j < n; j++) {
	for(k = 0; k < m; k++) {
	    for(i = k+1; i < m; i++) {
                B(i,j) -= B(k,j)*A(i,k);
	    }
	}
    }
}
