
/* The following macro depends on the variables a and nca */

#define A(i,j) (*(a + (i)*nca + (j)))

#define min(a,b) (((a)<(b))?(a):(b))
#define max(a,b) (((a)>(b))?(a):(b))

static void
scale(n, d, a, inc)
double d, *a;
{
    int i, ix;

    ix = 0;
    for(i = 0; i < n; i++) {
	a[ix] *= d;
	ix += inc;
    }
}

#define dabs(x) (((x)>=0.0)?(x):-(x))

static int
findmax(n, a, inc)
double *a;
{
    int i, ix, maxi;
    double dmax;

    dmax = a[0];
    maxi = 0;
    ix = 0;
    for(i = 0; i < n; i++) {
	if(dabs(a[ix]) > dmax) {
	    dmax = dabs(a[ix]);
	    maxi = i;
	}
	ix += inc;
    }
    return maxi;
}

/* swap two vectors */

static void
swapvects(n, a, b)
double *a, *b;
{
    int i;
    double tmp;

    for(i = 0; i < n; i++) {
	tmp = a[i];
	a[i] = b[i];
	b[i] = tmp;
    }
}

/*
 * Perform a series of row interchanges on matrix a.
 */

static void
swaprows(nc, a, nca, k1, k2, piv)
double *a;
int *piv;
{
    int i;

    for(i = k1; i < k2; i++) {
	swapvects(nc, &A(i,0), &A(piv[i],0));
    }
}

/*
 * special case of update2 for 2 *vectors*
 */

static void
update(m, n, b, incb, c, incc, a, nca)
double *b, *c, *a;
{
    int ib, jc;
    int i, j;

    jc = 0;
    for(j = 0; j < n; j++) {
	ib = 0;
	for(i = 0; i < m; i++) {
	    A(i,j) -= b[ib] * c[jc];
	    ib += incb;
	}
	jc += incc;
    }
}

static void 
lu2(m, n, a, nca, piv)
double *a;
int *piv;
{
    int j, jp;

    for(j = 0; j < min(m, n); j++) {
	jp = j + findmax(m-j, &A(j,j), nca);
	piv[j] = jp;
	swapvects(n, &A(j,0), &A(jp,0));
	if(j+1 < m) {
	    scale(m-j-1, 1.0/A(j,j), &A(j+1, j), nca);
	}
	if(j+1 < n) {
	    update(m-j-1,n-j-1,&A(j+1,j),nca,&A(j,j+1),1,&A(j+1,j+1), nca);
	}
    }
}

void
pivot(j, n, nb, a, nca, piv)
double *a;
int *piv;
{
    int i;

    lu2(n-j, nb, &A(j,j), nca, &piv[j]);
    for(i = j; i < j+nb; i++) {
	piv[i] += j;
    }
    swaprows(j, a, nca, j, j+nb, piv);
    swaprows(n-j-nb, &A(0,j+nb), nca, j, j+nb, piv);
}

