/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

/* These are revolting macros which make my life easier.  They are used
 * in eval.h */

#define yucky_compunop_macro(e, unop, flags, orig) {\
  switch((e)->args[0]->type) {\
    case CHAR: \
      (e)->type = CHAR;\
      (e)->val.c = unop (e)->args[0]->val.c; \
      break;\
    case INT: \
      (e)->type = INT;\
      (e)->val.i = unop (e)->args[0]->val.i; \
      break;\
    case FLOAT: \
      (e)->type = INT;\
      (e)->val.i = unop (e)->args[0]->val.f; \
      break;\
    case DOUBLE: \
      (e)->type = INT;\
      (e)->val.i = unop (e)->args[0]->val.d; \
      break;\
    default: eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    break;\
  }\
}

#define yucky_unop_macro(e, unop, flags, orig) {\
  switch((e)->args[0]->type) {\
    case CHAR: \
      (e)->type = CHAR;\
      (e)->val.c = unop (e)->args[0]->val.c; \
      break;\
    case INT: \
      (e)->type = INT;\
      (e)->val.i = unop (e)->args[0]->val.i; \
      break;\
    case FLOAT: \
      (e)->type = FLOAT;\
      (e)->val.f = unop (e)->args[0]->val.f; \
      break;\
    case DOUBLE: \
      (e)->type = DOUBLE;\
      (e)->val.d = unop (e)->args[0]->val.d; \
      break;\
    default: eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    break;\
  }\
}

#define yucky_bitunop_macro(e, unop, flags, orig) {\
  switch((e)->args[0]->type) {\
    case CHAR: \
      (e)->type = CHAR;\
      (e)->val.c = unop (e)->args[0]->val.c; \
      break;\
    case INT: \
    case FLOAT: \
    case DOUBLE: \
      (e)->type = INT;\
      convert_exp_type((e)->args[0], (e)->type);\
      (e)->val.i = unop (e)->args[0]->val.i; \
      break;\
    default: eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    break;\
  }\
}

#define yucky_binop_macro(e, binop, flags, orig) {\
    if ((e)->args[0]->type == DOUBLE || (e)->args[1]->type == DOUBLE) {\
      (e)->type = DOUBLE;\
    } else if ((e)->args[0]->type == FLOAT || (e)->args[1]->type == FLOAT) {\
      (e)->type = FLOAT;\
    } else if ((e)->args[0]->type == INT || (e)->args[1]->type == INT) {\
      (e)->type = INT;\
    } else if ((e)->args[0]->type == CHAR || (e)->args[1]->type == CHAR) {\
      (e)->type = CHAR;\
    } else eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    convert_exp_type((e)->args[0], (e)->type);\
    convert_exp_type((e)->args[1], (e)->type);\
    switch((e)->type) {\
      case INT: (e)->val.i = (e)->args[0]->val.i binop (e)->args[1]->val.i; break;\
      case CHAR: (e)->val.c = (e)->args[0]->val.c binop (e)->args[1]->val.c; break;\
      case FLOAT: (e)->val.f = (e)->args[0]->val.f binop (e)->args[1]->val.f; break;\
      case DOUBLE: (e)->val.d = (e)->args[0]->val.d binop (e)->args[1]->val.d; break;\
      default: eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    }\
  }

#define yucky_compbinop_macro(e, binop, flags, orig) {\
    int tp;\
    if ((e)->args[0]->type == DOUBLE || (e)->args[1]->type == DOUBLE) {\
      tp = DOUBLE;\
    } else if ((e)->args[0]->type == FLOAT || (e)->args[1]->type == FLOAT) {\
      tp = FLOAT;\
    } else if ((e)->args[0]->type == INT || (e)->args[1]->type == INT) {\
      tp = INT;\
    } else if ((e)->args[0]->type == CHAR || (e)->args[1]->type == CHAR) {\
      tp = CHAR;\
    } else eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    convert_exp_type((e)->args[0], tp);\
    convert_exp_type((e)->args[1], tp);\
    (e)->type = INT;\
    switch(tp) {\
      case INT: (e)->val.i=((e)->args[0]->val.i binop (e)->args[1]->val.i); break;\
      case CHAR: (e)->val.i=((e)->args[0]->val.c binop (e)->args[1]->val.c); break;\
      case FLOAT: (e)->val.i=((e)->args[0]->val.f binop (e)->args[1]->val.f); break;\
      case DOUBLE: (e)->val.i=((e)->args[0]->val.d binop (e)->args[1]->val.d); break;\
      default: eval_exp_error(FOUND_ARRAY, (e), (flags), (orig));\
    }\
  }

#define yucky_bitbinop_macro(e, binop, flags, orig) { \
    if ((e)->args[0]->type == CHAR && (e)->args[1]->type == CHAR) {\
      (e)->type = CHAR;\
    } else (e)->type = INT;\
    convert_exp_type((e)->args[0], (e)->type);\
    convert_exp_type((e)->args[1], (e)->type);\
    switch((e)->type) {\
      case INT: (e)->val.i = (e)->args[0]->val.i binop (e)->args[1]->val.i; break;\
      case CHAR: (e)->val.c = (e)->args[0]->val.c binop (e)->args[1]->val.c; break;\
      default: eval_exp_error(FOUND_NOT_BIT, (e), (flags), (orig));\
    }\
  }
