/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

#include <stdio.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

/* ---------------------------------------------------------------------- */
/* Type_coerce sets *v1 to be *v2.  It will perform coercion if t1 and
 * t2 are scalar types.  If t1 & t2 are arrays it merely sets *v1 to be
 * *v2 -- no other checking besides that. */
 
type_coerce(v1, v2, t1, t2)
void *v1;
void *v2;
int t1, t2;
{
  int *i1, i2;
  char *c1, c2;
  float *f1, f2;
  double *d1, d2;
  void **vd1;

  switch(t2) {
    case INT: i2 =  * ((int *) v2); break;
    case CHAR: c2 = * ((char *) v2); break;
    case FLOAT: f2 = * ((float *) v2); break;
    case DOUBLE: d2 = * ((double *) v2); break;
    case ARRAY: /* do nothing */ break;
    default: bail("INTE: Type_coerce, t2\n");
  }
  switch(t1) {
    case INT: 
      i1 = (int *) v1;
      switch(t2) {
        case INT: *i1 = (int) i2; break;
        case CHAR: *i1 = (int) c2; break;
        case FLOAT: *i1 = (int) f2; break;
        case DOUBLE: *i1 = (int) d2; break;
        case ARRAY:
          fprintf(stderr, "ERROR: Trying to coerce an array to an int\n");
          bail(CNULL);
          break;
        default: bail("INTE: Type_coerce, t2\n");
      }
      break;
    case CHAR: 
      c1 = (char *) v1; 
      switch(t2) {
        case INT: *c1 = (char) i2; break;
        case CHAR: *c1 = (char) c2; break;
        case FLOAT: *c1 = (char) f2; break;
        case DOUBLE: *i1 = (char) d2; break;
        case ARRAY:
          fprintf(stderr, "ERROR: Trying to coerce an array to a char\n");
          bail(CNULL);
          break;
        default: bail("INTE: Type_coerce, t2\n");
      }
      break;
    case FLOAT: 
      f1 = (float *) v1; 
      switch(t2) {
        case INT: *f1 = (float) i2; break;
        case CHAR: *f1 = (float) c2; break;
        case FLOAT: *f1 = (float) f2; break;
        case DOUBLE: *f1 = (float) d2; break;
        case ARRAY:
          fprintf(stderr, "ERROR: Trying to coerce an array to a float\n");
          bail(CNULL);
          break;
        default: bail("INTE: Type_coerce, t2\n");
      }
      break;
    case DOUBLE: 
      d1 = (double *) v1; 
      switch(t2) {
        case INT: *d1 = (double) i2; break;
        case CHAR: *d1 = (double) c2; break;
        case FLOAT: *d1 = (double) f2; break;
        case DOUBLE: *d1 = (double) d2; break;
        case ARRAY:
          fprintf(stderr, "ERROR: Trying to coerce an array to a double\n");
          bail(CNULL);
          break;
        default: bail("INTE: Type_coerce, t2\n");
      }
      break;
    case ARRAY: 
      vd1 = (void **) v1;
      if (t2 != ARRAY) {
        fprintf(stderr, "ERROR: Trying to coerce a (%s) to an array\n",
                types[t2]);
      }
      *vd1 = v2;
      break;
    default: bail("INTE: Type_coerce, t1\n");
  }
}

/* Convert_exp_type converts the expression e to the type "type".
 * It assumes that e is a constant expression */

convert_exp_type(e, type)
Exp e;
int type;
{
  int i;
  char c;
  float f;
  double d;
  void *rv, *rv2;
  
  if (e == ENULL) {
    bail("INTE: convert_exp_type: Trying to convert ENULL\n");
  }
  if (e->elt_type != 'c') {
    bail("INTE: convert_exp_type: Trying to convert a non-constant\n");
  }
  if (type == ARRAY && e->type == ARRAY) return;

  switch(e->type) {
    case INT:    i = e->val.i; rv = (void *) (& i); break;
    case CHAR:   c = e->val.c; rv = (void *) (& c); break;
    case FLOAT:  f = e->val.f; rv = (void *) (& f); break;
    case DOUBLE: d = e->val.d; rv = (void *) (& d); break;
    case ARRAY:
      bail("INTE: convert_exp_type, e->type == ARRAY\n"); break;
    default:
      bail("INTE: convert_exp_type: Unknown e->type.\n"); break;
  }
  switch(type) {
    case INT:    rv2 = (void *) (&(e->val.i)); break;
    case CHAR:   rv2 = (void *) (&(e->val.c)); break;
    case FLOAT:  rv2 = (void *) (&(e->val.f)); break;
    case DOUBLE: rv2 = (void *) (&(e->val.d)); break;
    case ARRAY:
      bail("INTE: convert_exp_type, type == ARRAY\n"); break;
    default:
      bail("INTE: convert_exp_type: Unknown type.\n"); break;
  }

  type_coerce(rv2, rv, type, e->type);
  e->type = type;
}
