/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

#include <stdio.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"

/*
 * things to add:
 * - add pvm instance #?
 * - add start job/job done events
 * - messages for pvm console?
 * - debugging levels?
 */


#include <ctype.h>

static int trace_on = 1;
static int trace_params = 0;
static int trace_msgs = 0;
static long serial = 0L;	/* trace event serial number */
static FILE *TF = stdout;

set_trace_msgs()
{
  trace_msgs = 1;
}

trace_flush()
{
  if (TF != NULL) {
    (void) fflush(TF);
  }
}

set_trace_on(i)
int i;
{
  trace_on = i;
}

set_trace_params(i)
int i;
{
  trace_params = i;
}

set_trace_file(filename)
char *filename;
{
  if (filename == CNULL || strcmp(filename, "-") == 0) TF = stdout;
  else if (strcmp(filename, "-2") == 0) TF = stderr;
  else if (strcmp(filename, "-1") == 0) TF = stdout;
  else if (*filename == '-' && isdigit (filename[1]) && filename[2] == '\0') {
      int fd = filename[1] - '0';
      if ((TF = fdopen (fd, "w")) == 0) {
	  fprintf (stderr, "ERROR: can't open fd %d as trace file\n", fd);
	  exit (1);
      }
  }
  else {
    TF = fopen(filename, "w");
    if (TF == NULL) {
      fprintf(stderr, "ERROR: Can't open trace file: %s\n", filename);
      exit(1);
    }
  }
}

trace_enroll(proc, inst)
char *proc;
int inst;
{
  if (!trace_on) return;
  trace_event ((Node) NULL, "START", 0, 0, 0);
#if 0
  fprintf(TF, "HeNCE master enrolled as pvm proc \"%s\" instance %d.\n",
          proc, inst);
#endif
}


trace_node(n)
Node n;
{
  if (!trace_on) return;


  if (n->state < 0)
      trace_event (n, "WAITING", 0, 0, 0);
  else
      trace_event (n, node_states[n->state], 0, 0, 0);

#if 0

  fprint_node_id(TF, n);

  if (n->state < 0) {
    fprintf(TF, "Waiting for %d parents to complete\n", -n->state);
  } else if (n->state == RUNNING) {
    fprintf(TF, "Running %s on %s (PVM inst %d)\n",
            n->sub_name, n->machine, n->pvminum);
  } else if (n->state == DONE) {
    fprintf(TF, "%s DONE: (mas) %d, (slv) %d, (sub) %d\n",
            n->machine, n->ttime, n->stime, n->sbtime);
  } else {
    fprintf(TF, "%s\n", node_states[n->state]);
  }
#endif
}

trace_fan_or_pipe(n, low, high)
Node n;
int low, high;
{
  if (!trace_on) return;

  trace_event (n, "VNODE", low <= high, low, high);

#if 0
  fprint_node_id(TF, n);
  fprintf(TF, "Low=%d High=%d,", low, high-1);
  if (low > high) {
    fprintf(TF, " Removing subgraph\n");
  } else {
    fprintf(TF, " Copying subgraph %d times\n", high - low - 1);
  }
#endif
}

trace_cond(n, cond)
Node n;
int cond;
{
  if (!trace_on) return;

  trace_event (n, "VNODE", cond, 0, 0);

#if 0
  fprint_node_id(TF, n);
  fprintf(TF, "Cond=%d", cond);
  if (cond) {
    fprintf(TF, "\n");
  } else {
    fprintf(TF, ": Removing subgraph\n");
  }
#endif
}

trace_loop(n, cond)
Node n;
int cond;
{
  if (!trace_on) return;
  trace_event (n, "VNODE", cond, 0, 0);

#if 0
  fprint_node_id(TF, n);
  fprintf(TF, "Cond=%d", cond);
  if (cond) {
    fprintf(TF, ": Appending a new copy to the end\n");
  } else {
    fprintf(TF, ": Removing subgraph\n");
  }
#endif
}

    
trace_param_begin (n)
Node n;
{
  if (!trace_params) return;
  fprintf(TF, "---");
  fprint_node_id(TF, n);
  fprintf(TF, "Parameters:\n");
}

trace_param(p)
Param p;
{
  if (!trace_params) return;
  fprintf(TF, "  ");
  fprint_param(TF, p);
  fprintf(TF, "\n");
}

trace_arrp(arrp)
Dlist arrp;
{
  int i, size;
  Dlist d;
  Node a;

  i = 0;
  size = 10;
  if (!trace_params) return;
  if (dl_empty(arrp)) fprintf(TF, "No array ancestor list\n");
  else {
    fprintf(TF, "Array ancestors:");
    dl_traverse(d, arrp) {
      a = (Node) d->val;
      if (i != 0) fprintf(TF, ",");
      if (i == size) {
        fprintf(TF, "\n    ");
        size += 10;
      }
      fprintf(TF, " %d/%d", a->id, a->inst);
    }
  }
  fprintf(TF, "\n");
}
      


trace_done(t)
int t;
{
  if (!trace_on) return;
  trace_event ((Node) NULL, "FINISH", 0, 0, 0);

#if 0
  fprintf(TF, "HeNCE execution finished: %d seconds\n", t);
#endif
}

static int tac = 0;
static Node tn, tnc;


trace_anc_list(n, nc)
Node n, nc;
{
  tac = 1;
  fprint_node_id(stdout, n);
  fprintf(stdout, "Updating anc list of");
  fprint_node_id(stdout, nc);
  fprintf(stdout, "\n");
  (void) fflush(stdout);
  tn = n;
  tnc = nc;
}

trace_anc(a, l)
Node a;
int l;
{
  if (!tac) return;
  fprintf(stdout, "  Anc:%d/%d, Level%d, AncList: ", a->id, a->inst, l);
  print_anc_list(tnc->anc);
}
 
trace_anc_off()
{
  tac = 0;
}

trace_msg_req(topr, toinum, top, myp)
char *topr;
int toinum, top, myp;
{
  if (!trace_msgs) return;

  fprintf(stderr, "%sReq. P%d from %s/%d -> my P%d\n",
          sl_id(), top, topr, toinum, myp);
}

trace_msg_send(myp, top, topr, toinum)
char *topr;
int toinum, top, myp;
{
  if (!trace_msgs) return;

  fprintf(stderr, "%sSend. my P%d to %s/%d -> their P%d\n",
          sl_id(), myp, topr, toinum, top);
}


trace_machine (name)
char *name;
{
    long time();

    fprintf (TF, "# %ld %ld %d/%d %s %s %s %c %d %d\n",
	     time((long *) 0),
	     serial++,
	     -1,
	     -1,
	     "x",
	     name,
	     "MACHINE",
	     'F',
	     0,
	     0);
    fflush (TF);		/* XXX need to do this more intelligently
				   and less often */
}

trace_event (n, state, tf, lo, hi)
Node n;
char *state;
int tf;
int lo;
int hi;
{
    long time();

    fprintf (TF, "# %ld %ld %d/%d %s %s %s %c %d %d\n",
	     time((long *) 0),
	     serial++,
	     n ? n->id : -1,
	     n ? n->inst : -1,
	     n ? node_types[n->node_type] : "x",
	     (n && n->machine) ? n->machine : "x",
	     state,
	     tf ? 'T' : 'F',
	     lo,
	     hi);
    fflush (TF);		/* XXX need to do this more intelligently
				   and less often */
}
