/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"
#include "eval.h"

char ID_INST[17];
char *sl_id()
{
  return ID_INST;
}

slave()
{
  int inum, i, j;
  char master[64];
  int masinum;
  char proc[64];
  Param parray;
  Exp *pvalarray;
  int nparam, nargs;
  int ret_param;
  Param rp, p;
  Exp *args;
  int node_ptr; /* Address of node in master -- useful as a unique node id */
  int node_id;
  int node_inst;
  int die;
  char *sub_name;
  Dlist aa;
  int stime, sbtime;

  stime = time(0);
  inum = enroll("null");
  whoami(proc, &inum);
  exp_initialize();

  (void) signal(SIGSEGV, segv_catch);
  rcv(HENCE_INIT);
  rcvinfo(&i, &j, master, &masinum);
  set_slave(master, masinum);
  node_ptr = getint();
  node_id = getint();
  node_inst = getint();
  sub_name = getlstring();
  sprintf(ID_INST, "%d/%d: ", node_id, node_inst);
  if (getint()) set_trace_msgs();

/*   printf("%s: Started: (%s:%d) (0x%x)\n", ID_INST, sub_name, inum, node_ptr); */
/*   fflush(stdout); */
  
  /* Get parameters */

  nparam = getint();
  if (nparam > 0) {
    parray = talloc(param, nparam);
    for (i = 0; i < nparam; i++) {
      clear_param(&(parray[i]));
    }
    for (i = 0; i < nparam; i++) {
      get_param(parray);
      parray[i].state = 0;
/*       printf("%sP#%d: ", sl_id(), i); */
/*       fprint_param(stdout, &(parray[i])); */
/*       printf("\n"); */
/*       fflush(stdout); */
    }
  }
  ret_param = getint();
  if (ret_param == -1) rp = PNULL; else rp = &(parray[ret_param]);

  /* Get argument expressions */

  nargs = getint();
  if (nargs > 0) {
    args = talloc(Exp, nargs);
    for (i = 0; i < nargs; i++) {
      args[i] = get_exp(parray);
    }
  }
  
  aa = (Dlist) get_aa();

  /* Initialize array paramters */

  pvalarray = talloc(Exp, nparam + 1);
  for (i = 0; i < nparam; i++) {
    p = &(parray[i]);
    if (p->type == ARRAY) {
      if (p->io.used) {  
        pvalarray[i] = make_null_array(p);  /* In array.c */
      } else {
        pvalarray[i] = ENULL;
      } 
    }
  }

  /* Next, traverse aa and get the array values */

  get_arrays(aa, parray, pvalarray);
  
  /* Finally, evaluate array parameters' expressions and do the final 
     initialization */

  for (i = 0; i < nparam; i++) {
    p = &(parray[i]);
    if (p->type == ARRAY) {
      if (p->io.used) {
        init_array_param(p, pvalarray);
/*         fprintf(stdout, "%sFinal: ", sl_id()); */
/*         fprint_param(stdout, p); */
/*         fprintf(stdout, "\n"); */
/*         fflush(stdout); */
      }
    }
  }

  /* Set up output scalars with null values: */

  for (i = 0; i < nparam; i++) {
    p = &(parray[i]);
    if (p->type != ARRAY && p->io.out && !p->io.in) {
      p->val = make_null_exp(p->type);
    }
  }

  /* Evaluate arguments */
  
  for (i = 0; i < nargs;  i++) {
    hence_eval_exp(args[i], EVAL_ARRAY_OK | EVAL_ADDRESS_OK);
  }
     
  sbtime = time(0);
/*   printf("%sMaking Wrapper call\n", sl_id()); */
  hence_wrapper_call(nargs, args, rp);
/*   printf("%sWrapper call over\n", sl_id()); */
  sbtime = time(0) - sbtime;
  stime = time(0) - stime;

  /* Send back parameters. */
  /* For all output array parameters, complete their initialization */

  die = 1;
  initsend();
  putint(node_ptr);
  putint(node_id);
  putint(node_inst);
  putint(stime);
  putint(sbtime);
  putint(nparam);
  for (i = 0; i < nparam; i++) {
    p = &(parray[i]);
    if (p->type != ARRAY) {
      put_exp(p->val);
    } else {
      die = 0;
      if (p->io.out && !p->io.in) {
        complete_array_initialization(p);
        for(j = 0; j < p->a->ndims; j++) {
          put_exp(p->a->dims[j]);
        }
      }
    }
  }

  snd(master, masinum, HENCE_DONE);

  if (!die) service_array_requests(parray);
  leave();
}

