/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

#include <stdio.h>
#include <signal.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

void segv_catch()
{
  bail("Caught a segv\n");
}

static int is_slave = 0;
static char *Mas_name;
static int Mas_num;
static Rb_node Alive = (Rb_node) 0;
static int ispvmon = 0;

pvmon()
{
  ispvmon = 1;
}

pvmoff()
{
  ispvmon = 0;
}

set_master(a)
Rb_node a;
{
  is_slave = 0;
  Alive = a;
}

set_slave(mas_name, mas_num)
char *mas_name;
int mas_num;
{
  Mas_name = copy_string(mas_name);
  Mas_num = mas_num;
  is_slave = 1;
  ispvmon = 1;
}

nice_bail(s)
char *s;
{
  (void) fflush(stdout);
  trace_flush();
  if (s != CNULL) fprintf(stderr, s);
  (void) fflush(stderr);
  if (is_slave) {
    initsend();
    snd(Mas_name, Mas_num, HENCE_DIE);
  } else {
    master_death(Alive);
  }
  if (ispvmon) leave();
  (void) exit((int)1);
}

bail(s)
char *s;
{
  (void) signal(SIGSEGV, SIG_DFL);
  (void) fflush(stdout);
  trace_flush();
  if (s != CNULL) fprintf(stderr, s);
  if (is_slave) {
    fprintf(stderr, "\n\n%sBailing\n\n", sl_id());
    (void) fflush(stderr);
    initsend();
    snd(Mas_name, Mas_num, HENCE_DIE);
    leave();
    { char *a = (char *)0; a[0] = 0; }
/*     exit(1); */
  } else {
    fprintf(stderr, "\n\nBailing\n\n");
    (void) fflush(stderr);
    if (ispvmon) {
      leave();
      master_death(Alive);
    }
    { char *a = (char *)0; a[0] = 0; }
  }
}

master_death(alive)
Rb_node alive;
{
  Rb_node r;
  Node n;

  if (alive == (Rb_node) 0) return;
  rb_traverse(r, alive) {
    n = (Node) r->v.val;
/*     printf("Sending Die message to %d/%d (%s/%d)\n", n->id, n->inst, */
/*       n->sub_name, n->pvminum); */
/*     fflush(stdout); */
    initsend();
    snd(n->sub_name, n->pvminum, HENCE_DIE);
  }
}

putint(n)
int n;
{
  putnint(&n, 1);
}

int getint()
{
  int n;
  getnint(&n, 1);
  return n;
}

putfloat(n)
float n;
{
  float f = n;
  putnfloat(&f, 1);
}

float getfloat()
{
  float n[1];
  getnfloat(n, 1);
  return n[0];
}

putdouble(n)
double n;
{
  putndfloat(&n, 1);
}

double getdouble()
{
  double n[1];
  getndfloat(n, 1);
  return n[0];
}

putbyte(n)
char n;
{
  putbytes(&n, 1);
}

char getbyte()
{
  char n;
  getbytes(&n, 1);
  return n;
}

putlstring(s)
char *s;
{
  putint(strlen(s));
  putstring(s);
}

char *getlstring()
{
  char *s;
  int len;
  getnint(&len, 1);
  s = talloc(char, len);
  getstring(s);
  return s;
}

put_array(a)
Array a;
{
  int i;

  putint(a->type);
  putint(a->ndims);
  for (i = 0; i < a->ndims; i++) {
    putint(a->size[i]);
    putint(a->indsize[i]);
  }
  putint(a->tsize);
  switch(a->type) {
    case INT: putnint(a->v.i, a->tsize); break;
    case FLOAT: putnfloat(a->v.f, a->tsize); break;
    case CHAR: putbytes(a->v.c, a->tsize); break;
    case DOUBLE: putndfloat(a->v.d, a->tsize); break;
    default: bail("INT ERROR: put_array: bad type\n"); break;
  }
}
  
Array get_array()
{
  Array a;
  int i;
  int tp, ndims;

  tp = getint();
  ndims = getint();
  a = brand_new_array(tp, ndims);
  a->refd.init = 1;
  for (i = 0; i < a->ndims; i++) {
    a->size[i] = getint();
    a->indsize[i] = getint();
  }
  a->tsize = getint();
  switch(a->type) {
    case INT: 
      a->v.i = talloc(int, a->tsize); 
      getnint(a->v.i, a->tsize); 
      break;
    case FLOAT: 
      a->v.f = talloc(float, a->tsize); 
      getnfloat(a->v.f, a->tsize); 
      break;
    case CHAR: 
      a->v.c = talloc(char, a->tsize); 
      getbytes(a->v.c, a->tsize); 
      break;
    case DOUBLE: 
      a->v.d = talloc(double, a->tsize); 
      getndfloat(a->v.d, a->tsize); 
      break;
    default:
      bail("INT ERROR: get_array: bad type\n"); break;
      break;
  }
  build_ptr_tree(a);
  return a;
}
  
  
put_exp(e)
Exp e;
{
  int i;

  if (e == ENULL) {
    putint(0);
    return;
  }
  putint(e->elt_type);
  putint(e->type);
  switch (e->elt_type) {
  case 'P': putint(e->val.p->num); break;
  case 'c': 
    switch(e->type) {
      case INT: putint(e->val.i); break;
      case FLOAT: putnfloat(&(e->val.f), 1); break;
      case CHAR: putbyte(e->val.c); break;
      case DOUBLE: putdouble(e->val.d); break;
      case ARRAY: put_array(e->val.a); break;
      default: fprintf(stderr, "PUT_EXP: Unknown 'c' type %d\n", e->type);
               bail(CNULL);
               break;
      }
      break;
  case 'p':
  case 't':
    fprintf(stderr, "ERROR: Can't put expression with type '%c':\n", 
            e->elt_type);
    fprint_exp(stderr, e);
    bail(CNULL);
    break;
  case '[':
  case 'M':
  case 'I':
  case 'N':
  case 'C':
  case 'A':
  case ']':
  case '*':
  case '/':
  case '%':
  case '+':
  case '-':
  case 'L':
  case 'R':
  case '<':
  case '>':
  case 'l':
  case 'g':
  case '!':
  case '=':
  case '&':
  case '^':
  case '|':
  case 'a':
  case 'o':
  case '.':
  case '?':
    break;
  default:
    fprintf(stderr, "Putting EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }
  for (i = 0; i < e->nargs; i++) put_exp(e->args[i]);
}

Exp get_exp(parray)
Param parray;
{
  Exp e;
  int elt_type, i;

  elt_type = getint();
  if (elt_type == 0) return ENULL;
  e = talloc(struct expression, 1);
  e->elt_type = elt_type;
  e->type = getint();
  
  switch (e->elt_type) {
  case 'P': e->nargs = 0; i = getint(); e->val.p = &(parray[i]); break;
  case 'c': 
    e->nargs = 0;
    switch(e->type) {
      case INT: e->val.i = getint(); break;
      case FLOAT: e->val.f = getfloat(); break; 
      case CHAR: e->val.c = getbyte(); break;
      case DOUBLE: e->val.d = getdouble(); break;
      case ARRAY: e->val.a = get_array(); break;
      default: fprintf(stderr, "GET_EXP: Unknown 'c' type %d\n", e->type);
               bail(CNULL);
               break;
      }
    break;
  case 'p':
  case 't':
    fprintf(stderr, "ERROR: Can't get expression with type '%c':\n", 
            e->elt_type);
    fprint_exp(stderr, e);
    bail(CNULL);
    break;
  case '[':
    e->nargs = 0;
    break;
  case 'M':
  case 'I':
  case 'N':
  case 'C':
  case 'A':
  case ']':
    e->nargs = 1;
    break;
  case '*':
  case '/':
  case '%':
  case '+':
  case '-':
  case 'L':
  case 'R':
  case '<':
  case '>':
  case 'l':
  case 'g':
  case '!':
  case '=':
  case '&':
  case '^':
  case '|':
  case 'a':
  case 'o':
  case '.':
    e->nargs = 2;
    break;
  case '?':
    e->nargs = 3;
    break;
  default:
    fprintf(stderr, "Getting EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }

  for (i = 0; i < e->nargs; i++) e->args[i] = get_exp(parray);
  return e;
}



put_param(p)
Param p;
{
  int i;

  putint(p->num);
  putlstring(p->name);
  putbyte((char) p->io.in);
  putbyte((char) p->io.out);
  putbyte((char) p->io.used);
  putbyte((char) p->io.main);
  putint(p->type);
  if (p->type == ARRAY) {
    putint(p->a->type);
    putint(p->a->ndims); 
    putint(p->a->nadims); 
    putint(p->a->n_level2);
    if (p->a->main == PNULL) bail("INTE: put_param: p->a->main == PNULL\n");
    putint(p->a->main->num);
    for (i = 0; i < p->a->ndims; i++) put_exp(p->a->dims[i]); 
  }
  put_exp(p->val);
}

get_param(parray)  /* For get_param, the parameter is put into its slot in
                      the array parray */
Param parray;
{
  Param p;
  int pnum, i, t, nd;

  pnum = getint();
  p = &(parray[pnum]);
  p->num = pnum;
  p->name = getlstring();
  p->io.in = getbyte();
  p->io.out = getbyte();
  p->io.used = getbyte();
  p->io.main = getbyte();
  p->type = getint();
  if (p->type == ARRAY) {
    t = getint();
    nd = getint();
    p->a = new_parray(t, nd);
    p->a->nadims = getint();
    p->a->n_level2 = getint();
    p->a->main = &(parray[getint()]);
    for (i = 0; i < p->a->ndims; i++) p->a->dims[i] = get_exp(parray);
  }
  p->val = get_exp(parray);
}

put_aa(n)
Node n;
{
  Dlist d;
  Array_anc aa;

  dl_traverse(d, n->aa) {
    aa = (Array_anc) d->val;
    putint((int)aa->anc);
    putlstring(aa->sub_name);
    putint(aa->pvminum);
    putint(aa->apnum);
    putint(aa->mypnum);
  }
  putint(0);
}

Dlist get_aa()
{
  Dlist d;
  Array_anc aa;
  int i;

  d = make_dl();
  for (i = getint(); i != 0; i = getint()) {
    aa = talloc(array_anc, 1);
    aa->anc = (void *) i;
    aa->sub_name = getlstring();
    aa->pvminum = getint();
    aa->apnum = getint();
    aa->mypnum = getint();
    dl_insert_b_aa(d, aa);
  }
  return d;
}

