/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

/*
 */

#include <stdio.h>
#include "std.h"
#include "list.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

Node Nd;
Graph G;

parse_begin(g)
Graph g;
{
  G = g;
}

new_node(type)
int type;
{
  Nd = talloc(node, 1);
  Nd->node_type = type;
  Nd->id = -1;
  Nd->xy.set = 0;
  Nd->nparams = 0;
  Nd->arrays = 0;
  Nd->params = make_rb();
  Nd->ret_param = PNULL;
  Nd->sub_name = CNULL;
  Nd->nargs = 0;
  Nd->children = make_rb();
  Nd->parents = make_rb();
  Nd->flags = 0;
  Nd->pair = NNULL;
  Nd->scope = NNULL;
  Nd->state = 0;
  Nd->instgen = talloc(int, 1);
  Nd->instgen[0] = 0;
  Nd->inst = Nd->instgen[0]++; 
  Nd->nparents = 0;
  Nd->nchildren = 0;
  Nd->anc = new_anc_list();
  Nd->machine = CNULL;		/* BKM 5 Feb 92 */
  Nd->mirror = Nd;
  Nd->aa = make_dl();
  Nd->ttime = 0;
  Nd->stime = 0;
  Nd->sbtime = 0;
}

Node copy_node(n)
Node n;
{
  Node nn;
  int i;

  nn = talloc(node, 1);
  nn->node_type = n->node_type;
  nn->id = n->id;
  nn->arrays = n->arrays;
  nn->xy.set = 0;
  copy_params(nn, n);
  nn->sub_name = n->sub_name;
  if (n->ret_param == PNULL) nn->ret_param = PNULL;
  else nn->ret_param = n->ret_param->mirror;
  nn->nargs = n->nargs;
  if (nn->nargs > 0) {
    nn->args = talloc(Exp, nn->nargs);
    for(i = 0; i < nn->nargs; i++) {
      nn->args[i] = copy_exp(n->args[i], 1);
    }
  }
  nn->parents = make_rb();
  nn->nparents = 0;
  nn->children = make_rb();
  nn->nchildren = 0;
  nn->pair = NNULL;
  nn->scope = NNULL;
  nn->flags = 0;
  nn->instgen = n->instgen;
  nn->inst = n->instgen[0]++;
  nn->state = 0;
  nn->anc = new_anc_list();
  nn->machine = CNULL;
  nn->pvminum = -1;
  nn->mirror = nn;
  n->mirror = nn;
  nn->aa = make_dl();
  nn->ttime = 0;
  nn->stime = 0;
  nn->sbtime = 0;
  return nn;
}


set_node_id(id)
int id;
{
  Nd->id = id;
}

set_xy(x, y)
int x, y;
{
  Nd->xy.set = 1;
  Nd->xy.x = x;
  Nd->xy.y = y;
}

node_done()
{
  Rb_node r;
  Exp e1, e2;
  Param p1, p2;
  int fnd, i;

  check_node_params(Nd);
  switch (Nd->node_type) {
  case NORMAL: 
    if (Nd->sub_name == CNULL) {
      fprintf(stderr, "ERROR: Node %d -- no subroutine call.\n", Nd->id);
      yyerror();
    }
    if (Nd->nargs > 0) {
      Nd->args = talloc(Exp, Nd->nargs);
      for (i = Nd->nargs-1; i >= 0; i--) {
        Nd->args[i] = last_exp();
      }
    }
    break;
  case COND:
    Nd->nargs = 1;
    Nd->args = talloc(Exp, 1);
    Nd->args[0] = last_exp();
    break;
  case LOOP:
    Nd->nargs = 3;
    Nd->args = talloc(Exp, Nd->nargs);
    Nd->args[2] = last_exp();
    e2 = last_exp();
    Nd->args[1] = last_exp();
    Nd->args[0] = last_exp();
    e1 = last_exp();

    if (e2 != ENULL) {
      if (e2->elt_type != 'P') {
        fprintf(stderr, "LOOP COUNTER 2 not 'P'\n");
        bail(CNULL);
      } else p2 = e2->val.p;
    } else {
      p2 = PNULL;
    }

    if (e1 != ENULL) {
      if (e1->elt_type != 'P') {
        fprintf(stderr, "LOOP COUNTER 1 not 'P'\n");
        bail(CNULL);
      } else p1 = e1->val.p;

      if (p2 != PNULL && p1 != p2) {
        incons_for_loop_params(Nd,p1,p2);
      }

      push_expression(e1);
      set_param_specs('>', 0, 0);
      if (e2 != ENULL) free_exp(e2);

      Nd->ret_param = p1;
    } else {
      Nd->ret_param = PNULL;
    }
    break;
  case PIPE:
  case FANOUT:
    Nd->nargs = 2;
    Nd->args = talloc(Exp, Nd->nargs);
    Nd->args[1] = last_exp();
    Nd->args[0] = last_exp();
    e1 = last_exp();
    if (e1->elt_type != 'P') {
      fprintf(stderr, "PIPE/FAN COUNTER not 'P'\n");
      bail(CNULL);
    } else p1 = e1->val.p;
    push_expression(e1);
    set_param_specs('>', 0, 1);
    Nd->ret_param = p1;
    break;
  case END_COND:
  case END_LOOP:
  case END_PIPE:
  case FANIN:
    break;
  default:
    fprintf(stderr, "ERROR: Node_done: Unknown node type: %d\n", 
      Nd->node_type);
    yyerror();
    break;
  }
  G->numnodes++;
  r = rb_find_ikey_n(G->nlist, Nd->id, &fnd);
  if (fnd) {
    fprintf(stderr, "ERROR: Two definitions of node %d\n", Nd->id);
    yyerror();
  }
  (void) rb_insert_b_i_n(r, Nd->id, Nd);
  (void) rb_inserti_n(G->heads, Nd->id, Nd);
}

int settype(s)
char *s;
{ 
  int i;

  for (i = 0; i < NTYPES; i++) {
    if (strcmp(s, types[i]) == 0) {
      return i;
    }
    if (strcmp(s, TYPES[i]) == 0) {
      return i;
    }
  }
  fprintf(stderr, "Unrecognized type: %s\n", s);
  yyerror();
  return 0; /* To keep lint happy */
}

ret_val()
{
  Exp e;

  e = last_exp_peek();

  if (e->elt_type != 'P') {
    fprintf(stderr, "RETVAL NOT PARAM\n");
    bail(CNULL);
  }
  Nd->ret_param = e->val.p;
}

sub_name(s)
char *s;
{
  if (Nd->sub_name == CNULL) {
    Nd->sub_name = copy_string(s);
  } else {
    fprintf(stderr, 
            "ERROR: Can't have two subroutine calls: %s already called\n", 
             Nd->sub_name);
    yyerror();
  }
}

sub_arg()
{
  Nd->nargs++;
}

add_arc(f, t)
int f, t;
{
  Rb_node p;
  Node nf, nt;
  int fnd;

  p = rb_find_ikey_n(G->nlist, f, &fnd);
  if (!fnd) aa_error(f,t,"Node",f," not defined.");
  nf = (Node) p->v.val;

  p = rb_find_ikey_n(G->nlist, t, &fnd);
  if (!fnd) aa_error(f,t,"Node",t," not defined.");
  nt = (Node) p->v.val;

  p = rb_find_ikey_n(nf->children, (int) nt, &fnd);
  if (fnd) aa_error(f,t,"Already defined in",f,"->children.");
  (void) rb_insert_b_nd(p, nt);

  p = rb_find_ikey_n(nt->parents, (int) nf, &fnd);
  if (fnd) aa_error(f,t,"Already defined in",t,"->parents.");
  (void) rb_insert_b_nd(p, nf);

  nt->nparents++;
  nf->nchildren++;
  if (nt->state == 0) {
    Rb_node r;
    r = rb_find_ikey_n(G->heads, t, &fnd);
    if (!fnd) aa_way_big_error(t);
    rb_delete_node(r);
  }
  nt->state -= 1;
}

aa_error(f,t,s1,i,s2)
int f, t, i;
char *s1, *s2;
{
  fprintf(stderr, "ERROR: ARC (%d,%d): %s %d%s\n", f,t,s1,i,s2);
  bail(CNULL);
}

aa_way_big_error(t)
int t;
{
  fprintf(stderr, "WAY BIG ERROR: %d should be in G->heads but is not\n", t);
  bail(CNULL);
}

tr_n_print(n)
Node n;
{
  Rb_node c;

  if (!n->flags) {
    print_node(n);
    fprintf(stdout, "\n");
    n->flags = 1;
    rb_traverse(c, n->children) tr_n_print((Node) c->v.val);
  }
}

clear_flags(n)
Node n;
{
  Rb_node c;

  if (n->flags) {
    n->flags = 0;
    rb_traverse(c, n->children) clear_flags((Node) c->v.val);
  }
}
print_nodes(g)
Graph g;
{
  Rb_node p;

  if (rb_first(g->heads) == nil(g->heads)) {
    fprintf(stderr, "ERROR: Circular graph -- no starting nodes\n");
    bail(CNULL);
  } else {
    fprintf(stdout, "Heads:");
    rb_traverse(p, g->heads) fprintf(stdout, " %d", p->k.ikey);
    fprintf(stdout, "\n");
    rb_traverse(p, g->heads) clear_flags((Node)p->v.val);
    rb_traverse(p, g->heads) tr_n_print((Node)p->v.val);
    rb_traverse(p, g->heads) clear_flags((Node)p->v.val);
  }
}

incons_for_loop_params(n, p1, p2)
Node n;
Param p1, p2;
{
  fprintf(stderr, 
          "ERROR in node %d: LOOP parameters 1 and 3 must be the same:\n  ",
           n->id);
  fprint_param(stderr, p1);
  fprintf(stderr, "\n  ");
  fprint_param(stderr, p2);
  fprintf(stderr, "\n");
  bail(CNULL);
}
