/* 
 * $Source: /n/fs/vd/jsp/src/jgraph/RCS/list.c,v $
 * $Revision: 5.4 $
 * $Date: 91/06/06 16:14:15 $
 * $Author: jsp $
 */

#include <stdio.h>    /* Basic includes and definitions */
#include "dlist.h"

#define boolean int
#define TRUE 1
#define FALSE 0


/*---------------------------------------------------------------------*
 * PROCEDURES FOR MANIPULATING DOUBLY LINKED LISTS 
 * Each list contains a sentinal node, so that     
 * the first item in list l is l->flink.  If l is  
 * empty, then l->flink = l->blink = l.            
 *---------------------------------------------------------------------*/

Dlist make_dl()
{
  Dlist d;

  d = (Dlist) malloc (sizeof(struct dlist));
  d->flink = d;
  d->blink = d;
  d->val = (char *) 0;
  return d;
}
 
dl_insert_b(node, val)	/* Inserts to the end of a list */
Dlist node;
char *val;
{
  Dlist last_node, new;

  new = (Dlist) malloc (sizeof(struct dlist));
  new->val = val;

  last_node = node->blink;

  node->blink = new;
  last_node->flink = new;
  new->blink = last_node;
  new->flink = node;
}

dl_delete_node(item)		/* Deletes an arbitrary iterm */
Dlist item;
{
  item->flink->blink = item->blink;
  item->blink->flink = item->flink;
  free(item);
}

dl_delete_list(l)
Dlist l;
{
  Dlist d, next_node;

  d = l->flink;
  while(d != l) {
    next_node = d->flink;
    free(d);
    d = next_node;
  }
  free(d);
}
