/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

#include <stdio.h>
#if defined(IMA_SYMM) || defined(IMA_NEXT)
void *malloc ();
void free ();
void *realloc ();
void *calloc ();
#else
#include <malloc.h>
#endif /* IMA_SYMM */
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

Dlist Estack;

double atof();
int atoi();

exp_initialize()
{
  Estack = make_dl();
}

#define yucky_comparison_macro(e1,e2,suff) { \
   if (e1->val.suff < e2->val.suff) return -1; \
   if (e1->val.suff > e2->val.suff) return 1; \
   return 0; }

int exp_comp(e1, e2)
Exp e1, e2;
{
  int cmp, i;

  if (e1 == e2) return 0;
  if (e1 == ENULL) return -1;
  if (e2 == ENULL) return 1;

  if (e1->elt_type < e2->elt_type) return -1;
  if (e1->elt_type > e2->elt_type) return 1;

  switch (e1->elt_type) {
    case 'P': return param_comp(e1->val.p, e2->val.p); break;
    case 'c': 
      if (e1->type < e2->type) return -1;
      if (e1->type > e2->type) return 1;
      switch(e1->type) {
        case CHAR: yucky_comparison_macro(e1,e2,c); break;
        case INT: yucky_comparison_macro(e1,e2,i); break;
        case FLOAT: yucky_comparison_macro(e1,e2,f); break;
        case DOUBLE: yucky_comparison_macro(e1,e2,d); break;
        case ARRAY: yucky_comparison_macro(e1,e2,a); break;
        default: bail("EXP_COMP Unknown type"); break;
      }
    case 'p': exp_comp_ltp_error(e1, e2); break;
    default:
      for (i = 0; i < e1->nargs; i++) {
        cmp = exp_comp(e1->args[i], e2->args[i]);
        if (cmp != 0) return cmp;
      }
      return 0;
    break;
  }
  bail("INT ERROR: Exp comp shouldn't reach this statement\n");
  return 0;   /* Put here to shut up lint */
}
    

push_expression(e)
Exp e;
{
    dl_insert_b_exp(Estack, e);
}
  
Exp last_exp()
{
  Dlist dl;
  Exp retval;

  dl = last(Estack);
  if (dl == nil(Estack)) {
    fprintf(stderr, "ERROR: Last_exp(): Expression stack empty\n");
    bail(CNULL);
  }
  retval = (Exp) dl->val;
  dl_delete_node(dl);
  return retval;
}

Exp last_exp_peek()
{
  Dlist dl;

  dl = last(Estack);
  if (dl == nil(Estack)) return ENULL; else return (Exp) dl->val;
}

push_int(val)
int val;
{
  Exp e;

  e = talloc(struct expression, 1);
  e->elt_type = 'c';
  e->type = INT;
  e->val.i = val;
  e->nargs = 0;
  push_expression(e);
}

Exp make_null_exp(type)
int type;
{
  push_exp('c', "0", type);
  return last_exp();
}


push_str(str)
char *str;
{
  Exp e;

  e = talloc(struct expression, 1);
  e->elt_type = 'c';
  e->type = ARRAY;
  e->nargs = 0;
  e->val.a = brand_new_array(CHAR, 1);
  e->val.a->refd.init = 1;
  e->val.a->v.c = str;
  e->val.a->size[0] = strlen(str) + 1;
  e->val.a->tsize = e->val.a->size[0];
  e->val.a->indsize[0] = 1;
  build_ptr_tree(e->val.a);
  push_expression(e);
}
    

push_exp(elt_type, val, type)
int elt_type;
char *val;
int type;
{
  Exp e;

  e = talloc(struct expression, 1);

  e->elt_type = elt_type;
  if (e->elt_type == 'P') {
    e->val.p = (Param) val;
  } else if (e->elt_type == 'c') {
    switch(type) {
    case INT: e->val.i = atoi(val); break;
    case DOUBLE: e->val.d = atof(val); break;
    case FLOAT: e->val.f = (float) atof(val); break;
    case CHAR: e->val.i = val[0]; break;
    default: fprintf(stderr, "PUSH_EXP: Unknown constant type: %d\n", type);
             bail(CNULL);
             break;
    }
  } else if (val != CNULL) { /* for 'p' and 'T' */
    e->val.s = copy_string(val);
  } else e->val.s = CNULL;
  e->type = type;

  switch (e->elt_type) {
  case 'P': 
  case 'T': 
  case 'c': 
  case 'p':
  case '[':
    e->nargs = 0; break;
  case 'M': 
  case 'I':
  case 'N':
  case 'C':
  case 'A':
  case ']': {
    e->nargs = 1;
    e->args[0] = last_exp();
    break;
    }
  case '*': 
  case '/': 
  case '%': 
  case '+': 
  case '-': 
  case 'L': 
  case 'R':
  case '<': 
  case '>':
  case 'l': 
  case 'g':
  case '!':
  case '=':
  case '&':
  case '^':
  case '|':
  case 'a':
  case 'o':
  case '.':
    e->nargs = 2;
    e->args[1] = last_exp();
    e->args[0] = last_exp();
    break;
  case '?':
    e->nargs = 3;
    e->args[2] = last_exp();
    e->args[1] = last_exp();
    e->args[0] = last_exp();
    break;
  default:
    printf("Pushing EXP: Don't know elt_type: %c\n", e->elt_type);
    bail(CNULL);
    break;
  }
  push_expression(e);
}

free_exp(e)
Exp e;
{
  int i;

  if (e == ENULL) return;
  if (e->elt_type != 'P' && e->elt_type != 'c' && e->val.s != CNULL) {
    free(e->val.s);
  } else if (e->elt_type == 'c' && e->type == ARRAY) {
    free_array(e->val.a);
  }

  for (i = 0; i < e->nargs; i++) free_exp(e->args[i]);
  free(e);
}

/* If mirror = 0, copy parameter pointers.  If mirror = 1, 
   copy parameters' mirror pointers.  If mirror = 2, flag an error
   if there is a parameter (bad bail) */

Exp copy_exp(e, mirror)
Exp e;
int mirror;
{
  Exp newe;
  int i;

  if (e == ENULL) return ENULL;
  newe = talloc(exp_list, 1);
  newe->elt_type = e->elt_type;
  newe->type = e->type;
  if (e->elt_type == 'P') {
    switch(mirror) {
      case 0: newe->val.p = e->val.p; break;
      case 1: newe->val.p = e->val.p->mirror; break;
      case 2: bail("INT ERROR: copy_exp, mirror = 2 -- hit param\n"); break;
      default: bail("INT ERROR: copy_exp mirror < 0 || > 2\n");
    }
  } else if (e->elt_type == 'c') {
    switch(newe->type) {
    case INT: newe->val.i = e->val.i; break;
    case CHAR: newe->val.c = e->val.c; break;
    case FLOAT: newe->val.f = e->val.f; break;
    case DOUBLE: newe->val.d = e->val.d; break;
    case ARRAY: newe->val.a = copy_array(e->val.a); break;
    default:
      fprintf(stderr, "ERROR: Copy_exp: Unknown type %d\n", e->type);
      bail(CNULL);
      break;
    }
  } else newe->val.i = 0;
  newe->nargs = e->nargs;
  for (i = 0; i < newe->nargs; i++) 
    newe->args[i] = copy_exp(e->args[i], mirror);
  return newe;
}

fprint_estack(f)
FILE *f;
{
  Dlist d;
  dl_traverse(d, Estack) {
    if (d != first(Estack)) fprintf(f, ", ");
    fprint_exp(f, (Exp) d->val);
  }
  fprintf(f, "\n");
}

print_estack()
{
  fprint_estack(stdout);
  (void) fflush(stdout);
}

exp_comp_ltp_error(e1, e2)
Exp e1, e2;
{
  fprintf(stderr, "ERROR: Exp_comp: comparing expressions with 'p' types:\n");
  fprintf(stderr, "  Exp e1: 0x%x\n", e1);
  fprintf(stderr, "  Exp e2: 0x%x\n", e2);
  bail(CNULL);
}

