/*
 * $Source$
 * $Revision$
 * $Date$
 * $Author$
 */

/* Arc.c contains routines specific to dealing with arcs in graphs. It is
 * used by the parser to put arcs into the graph. (With the routines 
 * ard_done(), arc_elt(), and arc_initialize()), and it is used by 
 * execute.c to remove and add arcs to the graph when performing 
 * rewriting. 
 */

/* Arc_done, arc_elt, and arc_initialize should be rewritten with the
 * new parser */

#include <stdio.h>
#include "std.h"
#include "list.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "rbhelp.h"

typedef struct intl {
  struct intl *flink;
  struct intl *blink;
  int i;
} int_list;
typedef int_list *Int;
  
Int I;

/* ---------------------------------------------------------------------- */
/* Arc_done is called at the end of an "ARC f t" line by the parser.  */

arc_done()
{
  Int i, ni;
  i = first(I);
  while(i != nil(I)) {
    ni = next(i);
    delete_item(i);
    free_node(i, I);
    i = ni;
  }
}

/* ---------------------------------------------------------------------- */
/* Arc_elt is called by the parser for each from & to element in the arc. */

arc_elt(i, f_or_t)
int i;
int f_or_t;
{
  Int il;

  if (f_or_t == 'f') {
    il = (Int) get_node(I);
    il->i = i;
    insert(il, I);
  } else if (f_or_t == 't') {
    for (il = first(I); il != nil(I); il = next(il)) {
      if (il->i == i) {
        fprintf(stderr, "Ignoring arc %d %d\n", il->i, i);
      } else {
        add_arc(il->i, i);
      }
    }
  } else {
    fprintf(stderr, "ERROR in arc_elt -- unknown char %c\n", f_or_t);
    yyerror();
  }
}

/* ---------------------------------------------------------------------- */ 
/* Arc_initialize is called at the beginning of parsing. */

arc_initialize()
{
  I = mklist(int_list);
}

/*----------------------------------------------------------------------*/
/* Delete_arc() deletes the arc between parent node np and child node nc.
 * It does this by deleting nc from np's child list, and deleting np from
 * nc's parent list.  Parent_done is a boolean -- to be set if np has
 * finished executing (This should probably be done from np's state --
 * ugh).  If it is false, then nc's state should be decremented.
 */


delete_arc(np, nc, parent_done)
Node np, nc;
int parent_done;
{
  Rb_node r;
  r = rb_find_ikey(np->children, (int) nc);
  rb_delete_node(r);
  np->nchildren--;
  r = rb_find_ikey(nc->parents, (int) np);
  rb_delete_node(r);
  nc->nparents--;
  if (!parent_done) nc->state++;
}

/*----------------------------------------------------------------------*/
/* New_arc() is the opposite of delete_arc -- it adds an arc between np
 * and nc.  It doesn't check if the arc is already there.
 */

new_arc(np, nc, parent_done)
Node np, nc;
int parent_done;
{
  (void) rb_inserti_nd(np->children, nc);
  np->nchildren++;
  (void) rb_inserti_nd(nc->parents, np);
  nc->nparents++;
  if (!parent_done) nc->state--;
}


