/*
 *	HeNCE Tool
 *
 *	widmain.c - Main widget stuff.
 *		This is where everything goes that happens in the main panel.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <strings.h>
#include <errno.h>

#include "xincl.h"
#include "FileSelect.h"
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "graph.h"
#include "parse.h"
#include "costmat.h"
#include "xcomn.h"
#include "comn.h"
#include "pvmglue.h"
#include "subproc.h"

#ifndef R_OK				/* get *_OK constants for access call */
#ifdef IMA_PMAX
#include <unistd.h>
#else
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define F_OK 0
#endif /*IMA_PMAX*/
#endif /*R_OK*/

extern int errno;				/* 4.3bsd needs this */

/*******************
*  from elsewhere  *
*                  *
*******************/

int fgetc();

void start_build();
int stop_build();
void start_compose();
int stop_compose();
void start_config();
int stop_config();
void start_trace();
int stop_trace();

/*************
*  exported  *
*            *
*************/

char graphfile[1024];			/* current graph file */
char directory[1024];			/* current directory */
char costfile[1024];			/* current cost matrix */
Graph scratchgraph = 0;			/* current graph */
struct costm *costmatrix = 0;	/* current cost matrix */
Widget composeButton;
Widget configButton;
Widget buildButton;
Widget traceButton;
Widget startPvmButton;

/***********
*  global  *
*          *
***********/

#if 0
static void do_dir_cb();
#endif
static void dir_cb();
static void grfile_cb();
static void build_cb();
static void costfile_cb();
static void compose_cb();
static void config_cb();
static void execute_cb();
static void start_pvm_cb ();
static void print_cb();
static void trace_cb();
#if 0
static void debug_cb();
#endif
static void quit_cb();
static void legend_cb();
static void language_cb();
static void tracefile_cb();

static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];
static char inputname[1024];		/* chdir directory */
static char ptfilename[256];	/* for print */
static Widget dirButton = 0;
Widget grfButton = 0;
Widget costButton = 0;
static Widget languageButton = 0;
Widget traceFileButton = 0;
static char crud[1024];
static Window legendWin;
static int legendVisible = 0;
static Widget legendPop = 0;


/********************
*  widget creation  *
*                   *
********************/

cre_mainwid()
{
	Widget w, w2;
	int n;

	/*
	 * translation table for radio group
	 */

	XtTranslations radio_ttab = XtParseTranslationTable("\
<EnterWindow>:highlight(Always)\n\
<LeaveWindow>:unhighlight()\n\
<Btn1Down>,<Btn1Up>:notify()");
	

	graphfile[0] = 0;
	directory[0] = 0;
	costfile[0] = 0;
	ptfilename[0] = 0;


	scratchgraph = gr_New();

	n = 0;
	mainForm = XtCreateManagedWidget("mainForm", formWidgetClass,
		topLevel, args, n);


	/* create message panel */

    XtSetArg(args[n], XtNheight, 90); n++;
    XtSetArg(args[n], XtNscrollVertical, XawtextScrollAlways); n++;
    XtSetArg(args[n], XtNwrap, XawtextWrapWord); n++;
    XtSetArg(args[n], XtNeditType, XawtextRead); n++;
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;
    XtSetArg(args[n], XtNright, XtChainLeft); n++;
    XtSetArg(args[n], XtNtop, XtChainTop); n++;
    XtSetArg(args[n], XtNbottom, XtChainTop); n++;
    infoBox = XtCreateManagedWidget("infoBox", asciiTextWidgetClass,
        mainForm, args, n);


	/* make command panel */

	n = 0;
	XtSetArg(args[n], XtNresizable, (XtArgVal)True); n++;
	XtSetArg(args[n], XtNfromVert, (XtArgVal)infoBox); n++;
	XtSetArg(args[n], XtNborderWidth, (XtArgVal)0); n++;
	XtSetArg(args[n], XtNhorizDistance, (XtArgVal)0); n++;
	XtSetArg(args[n], XtNleft, XtChainLeft); n++;
	XtSetArg(args[n], XtNright, XtChainLeft); n++;
	XtSetArg(args[n], XtNtop, XtChainTop); n++;
	XtSetArg(args[n], XtNbottom, XtChainTop); n++;
	mainCmd = XtCreateManagedWidget("mainCmd", formWidgetClass, mainForm,
		args, n);

	n = 0;
	XtSetArg(args[n], XtNresizable, (XtArgVal)True); n++;
	XtSetArg(args[n], XtNleft, XtChainLeft); n++;
	XtSetArg(args[n], XtNright, XtChainLeft); n++;
	XtSetArg(args[n], XtNtop, XtChainTop); n++;
	XtSetArg(args[n], XtNbottom, XtChainTop); n++;

	w = cre_cmd_but("directory", mainCmd, args, n,
					(Widget)0, (Widget)0, "directory:",
					(char*)0, 0, 0, dir_cb, 0);
	w2 = w;
	dirButton = w;

	w  = cre_cmd_but("graph", mainCmd, args, n,
					 (Widget)0, w, "graph:",
					 (char*)0, 0, 0, grfile_cb, 0);
	grfButton = w;

	w = cre_cmd_but("costs", mainCmd, args, n,
					(Widget)0, w, "costs:",
					(char*)0, 0, 0, costfile_cb, 0);
	costButton = w;

	w = cre_cmd_but ("tracefile", mainCmd, args, n,
					 (Widget)0, w, "tracefile:",
					 (char *)0, 0, 0, tracefile_cb, 0);
	traceFileButton = w;

	w  = cre_cmd_but ("language", mainCmd, args, n,
					 (Widget)0, w, "language: FORTRAN",
					 (char *) 0, 0, 0, language_cb, 0);
	languageButton = w;

	/* BEGIN RADIO GROUP */
	XtSetArg(args[n], XtNtranslations, radio_ttab); n++;

	w = cre_tog_but ("compose", mainCmd, args, n,
					w2, (Widget)0, "compose",
					(char*)0, 0, 0, compose_cb, 0, 0);
	composeButton = w;
	
	w =  cre_tog_but ("config", mainCmd, args, n,
					 w2, w, "config",
					 (char*)0, 0, 0, config_cb, 0, 0);
	configButton = w;

	w = cre_tog_but ("build", mainCmd, args, n,
					 w2, w, "build",
					 (char*)0, 0, 0, build_cb, 0, 0);
	buildButton = w;

	w = cre_tog_but ("trace", mainCmd, args, n,
					 w2, w, "trace",
					 (char*)0, 0, 0, trace_cb, 0, 0);
	traceButton = w;

	n--;						
	/* END RADIO GROUP */

	XtSetArg(args[n], XtNhorizDistance, 30); n++;
	w = cre_cmd_but ("startPvm", mainCmd, args, n, w2, w,
					 "start pvm", (char *)0, 0, 0, start_pvm_cb, 0);
	startPvmButton = w;
	n--;

	w = cre_cmd_but ("execute", mainCmd, args, n,
					w2, w, "execute", (char*)0, 0, 0, execute_cb, 0);

#if 0
	w = cre_cmd_but ("debug", mainCmd, args, n,
					w2, w, "debug", (char*)0, 0, 0, debug_cb, 0);
#endif

	w = cre_cmd_but ("print", mainCmd, args, n,
					w2, w, "print", (char*)0, 0, 0, print_cb, 0);

	w = cre_tog_but ("legend", mainCmd, args, n,
					w2, w, "legend", (char*)0, 0, 0, legend_cb, 0, 0);

	XtSetArg(args[n], XtNhorizDistance, 30); n++;
	w = cre_cmd_but("quit", mainCmd, args, n,
		w2, w, "quit", (char*)0, 0, 0, quit_cb, 0);
	n--;

}


/**************************
*  main widget callbacks  *
*                         *
**************************/

static void
dir_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	*inputname = '\0';
	if (!fileVerify ("change to directory:", inputname, sizeof(inputname),
					 "", FS_Directory|FS_MustExist|FS_MustBeReadable)) {

		if (chdir(inputname) == -1) {
			message("chdir failed.");
			return;
		} else {
#if 0
			if (currentDirectory)
				free (currentDirectory);
			currentDirectory = strsave (inputname);
#endif
			set_directory();
		}
	}
}

static void
grfile_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int can;
	FILE *ff;

	if (stop_mode == stop_compose) {	/* don't do this if in compose mode */
		msg_Format ("Use either the \"load\" or \"store\" button instead\n");
		return;
	}

	if (trace_ChangeGraphFile (0) == 0)
		return;

	inputname[0] = 0;
#if 1
	can = fileVerify ("load graph from file:", inputname, sizeof(inputname),
					  "*.gr", FS_MustBeReadable);
#else
	can = filever("load graph from file:", inputname, sizeof(inputname));
#endif
	if (!can) {
		if (!inputname[0]) {
			message("no filename.");
			return;
		}
		if (!(ff = fopen(inputname, "r"))) {
			sprintf(crud, "\"%s\": can't read.", inputname);
			message(crud);
			return;
		}
		gr_Free(scratchgraph);
		scratchgraph = parse_Program((int(*)())fgetc, (void*)ff, inputname);
		fclose(ff);
		sprintf(crud,
			(scratchgraph ? "\"%s\" loaded." : "\"%s\": errors in file."),
			inputname);
		message(crud);
		if (!scratchgraph)
			scratchgraph = gr_New();
		set_graphfile(inputname);
		(void) trace_ChangeGraphFile (1);
	}
}

static void
costfile_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	struct costm *newcm;

	if (stop_mode == stop_config) {	/* don't do this if in config mode */
		msg_Format ("Use the \"load\" or \"store\" button instead.\n");
		return;
	}

	inputname[0] = 0;
#if 1
	if (fileVerify ("new cost matrix:", inputname, sizeof(inputname),
					"*.mat", FS_MustBeReadable))
#else
	if (filever("new cost matrix:", inputname, sizeof(inputname)))
#endif
		return;
	switch (cm_ReadFile (inputname, &newcm)) {
	case 1:
		sprintf(crud, "\"%s\": can't read", inputname);
		message(crud);
		break;

	case 2:
		sprintf(crud, "\"%s\": bad cost matrix", inputname);
		message(crud);
		break;

	default:
		cm_Free (costmatrix);
		costmatrix = newcm;
		sprintf(crud, "\"%s\": new cost matrix", inputname);
		message(crud);
		set_costfile(inputname);
		break;
	}
}

static void
build_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	if (stop_mode && stop_mode())
		return;
	if (stop_mode == stop_build) {
		stop_mode = 0;
		message("exit build mode.");

	} else {
		start_build();
		stop_mode = stop_build;
		message("build mode.");
	}
}

static void
compose_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	if (stop_mode && stop_mode())
		return;
	if (stop_mode == stop_compose) {
		stop_mode = 0;
		message("exit compose mode.");

	} else {
		start_compose();
		stop_mode = stop_compose;
		message("compose mode.");
	}
}

static void
config_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	if (stop_mode && stop_mode())
		return;
	if (stop_mode == stop_config) {
		stop_mode = 0;
		message("exit config mode.");

	} else {
		start_config();
		stop_mode = stop_config;
		message("config mode.");
	}
}

/*
 * The "start pvm" button is actually a toggle between "start pvm"
 * and "kill pvm".  pvm_StartStop (in pvmglue.c) handles both actions,
 * and changes the button legend as appropriate.
 */

/*
 * XXX Get rid of this when we fix pvm hosts stuff.
 */

static void
start_pvm_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	char tmpPvmHostFile[255];
	FILE *srcfp, *dstfp;

	if (!pvm_IsRunning ()) {

		if (costmatrix == NULL) {
			msg_Format ("No cost matrix specified.\n");
			return;
		}
		/*
		 * this check doesn't belong here.  It should be okay to start up
		 * pvm even though the graph is not valid.  However, we currently
		 * use cm_CheckGraph to make sure that we can run each node program
		 * on at least one host.  As a side effect, it remembers which hosts
		 * can be used to run the graph, so we don't ask for more hosts than
		 * we need.  Without the call to cm_CheckGraph, we therefore cannot
		 * build a correct pvm_hosts file.
		 */

		if (gr_Empty (scratchgraph)) {
			msg_Format ("Can't startup pvm.  HeNCE graph is empty.\n");
			return;
		}
		if (cm_CheckGraph  (scratchgraph, costmatrix)) {
			msg_Format ("Can't startup pvm.  Some graph nodes cannot be run on any host in the cost matrix.\n");
			return;
		}
		if (*costfile == '\0') {
			msg_Format ("No cost matrix file specified.\n");
			return;
		}
		if (cm_WriteFile (costfile, costmatrix)) {
			msg_Format ("error: Can't write cost matrix \"%s\" (%s)\n",
						costfile, strerror (errno));
			return;
		}
		if ((srcfp = fopen (pvmHostFile, "r")) == NULL) {
			msg_Format ("warning: can't open pvm host file \"%s\" (%s)\n",
						pvmHostFile, strerror (errno));
			srcfp = fopen ("/dev/null", "r");
		}
		strcpy (tmpPvmHostFile, "/tmp/htoolXXXXXX");
		mktemp (tmpPvmHostFile);
		strcat (tmpPvmHostFile, ".p");

		unlink (tmpPvmHostFile);
		if ((dstfp = fopen (tmpPvmHostFile, "w")) == NULL) {
			msg_Format ("Can't create temp pvm hosts file %s (%s)\n",
						tmpPvmHostFile, strerror (errno));
		}
		if (cm_BuildPvmHostFile (srcfp, dstfp, costmatrix) < 0) {
			fclose (srcfp);
			fclose (dstfp);
			unlink (tmpPvmHostFile);
			return;
		}
		fclose (srcfp);
		fclose (dstfp);
	}
	pvm_StartStop (w, tmpPvmHostFile);
}


static void
execute_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
/*
	message("sorry, execute not impl yet");
*/
	do_execute();
}

/*	print_cb()
*
*	Print command.
*/

static void
print_cb()
{
	int can;
	FILE *ff;

#if 1
	can = fileVerify ("write eps to file:", ptfilename, sizeof(ptfilename),
					  "*.ps", FS_MustBeWritable);
#else
	can = filever("write eps to file:", ptfilename, sizeof(ptfilename));
#endif

	if (!can) {
		if (!ptfilename[0]) {
			message("no filename.");
			return;
		}
		if (!(ff = fopen(ptfilename, "w"))) {
			sprintf(crud, "\"%s\": can't write.", ptfilename);
			message(crud);
			return;
		}
		gr_EPS(scratchgraph, ff);
		fclose(ff);
		sprintf(crud, "\"%s\": postscript written.", ptfilename);
		message(crud);
	}
}

static void
trace_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	if (stop_mode && stop_mode())
		return;
	if (stop_mode == stop_trace) {
		stop_mode = 0;
		message("exit trace mode.");

	} else {
		start_trace();
		stop_mode = stop_trace;
		message("trace mode.");
	}
}

#if 0
static void
debug_cb(w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	message("sorry, debug not impl yet");
}
#endif

static void
quit_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	if (stop_mode && stop_mode())
		return;
	if (stop_mode != stop_config && config_SaveLuser () == 1)
		return;
	if (stop_mode != stop_compose && compose_SaveLuser () == 1)
		return;
	stop_mode = 0;
	exit(0);
}


/*	legend_expose()
*
*	Redraw legend window on expose
*/

static void
legend_expose(w, cli, xev, rem)
	Widget w;
	XtPointer cli;
	XEvent *xev;
	Boolean *rem;
{
	if (xev->type == Expose && xev->xexpose.count == 0)
		xgr_DrawLegend(legendWin);
}

/*	legend_cb()
*
*	Pop up legend of node states
*/

static void
legend_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int n;
	Widget canvas;

	if (legendVisible = !legendVisible) {
		if (!legendPop) {
			legendPop = XtCreatePopupShell("legend", topLevelShellWidgetClass,
				topLevel, NULL, NULL);

			n = 0;
			XtSetArg(args[n], XtNheight, (XtArgVal)(10*19 + 50)); n++;
			XtSetArg(args[n], XtNwidth, (XtArgVal)400); n++;
				n++;
			canvas = XtCreateManagedWidget("legendcanvas",
				widgetClass, legendPop, args, n);

			XtPopup(legendPop, XtGrabNone);
			
			legendWin = XtWindow(canvas);
			XtAddEventHandler(canvas, ExposureMask, False, legend_expose, NULL);

		} else {
			XtPopup(legendPop, XtGrabNone);
		}

	} else {
		XtPopdown(legendPop);
	}
}

/********************
*  popup callbacks  *
*                   *
********************/


/*****************
*  misc methods  *
*                *
*****************/


/*	set_directory()
 *
 *	Notify main module that cwd has possibly changed.
 */

#if 1
directorySink (fd, buf)
int fd;
char *buf;
{
	FILE *fp;
	int c;

	if (*buf)
		return;
	if ((fp = fdopen (fd, "r")) == NULL)
		return;
	while ((c = getc (fp)) != '\n' && c != EOF)
		*buf++ = c;
	*buf = '\0';
}

gotDirectory (pid, exitArg, ptr, howDied)
int pid;
int exitArg;
char *ptr;
enum causeOfDeath howDied;
{
	char buf[64];
	char *p;

	if (currentDirectory)
		free (currentDirectory);
	currentDirectory = strsave (ptr);
	msg_Format ("current directory is now \"%s\"\n", currentDirectory);
	p = rindex (ptr, '/');
	sprintf (buf, "directory: %s", p ? p+1 : buf);
	set_label (dirButton, buf);
	XtVaSetValues (dirButton,
				   XtNsensitive, True,
				   NULL);
}

set_directory ()
{
	int pwdPid;

	XtVaSetValues (dirButton,
				   XtNsensitive, False,
				   NULL);
	/*
	 * can't use getcwd() to find out current directory, because
	 * it does a popen ("pwd") and expects that noone else will call
	 * wait() on the child.  In fact, the subproc package will do a wait
	 * if it gets a SIGCHLD. So if user has ever fired off a subprocess
	 * for any reason, the next call to getcwd() will hang forever.
	 *
	 * So basically we do what getcwd() does, using the subproc package.
	 */

	*directory = '\0';
	pwdPid = subproc_Popen ("/bin/pwd",	/* command */
							gotDirectory, /* when exited */
							gotDirectory, /* when killed */
							directorySink, /* when data */
							directory);	/* client data */
	if (pwdPid <= 0) {
		XtVaSetValues (dirButton,
					   XtNsensitive, True,
					   NULL);
		msg_Format ("system error: /bin/pwd failed\n");
	}
}
#else
set_directory()
{
	char *p;
	char buf[64];
	char *rindex ();

	getcwd(directory, sizeof(directory));
	directory[sizeof(directory)-1] = 0;
	message(directory);
	p = (p = rindex(directory, '/')) ? p + 1 : directory;
	strcpy(buf, "directory: ");
	strncat(buf, p, sizeof(buf) - strlen(buf) - 1);
	set_label(dirButton, buf);
}
#endif

/*	set_graphfile()
*
*	Notify main module of possibly new current graph file.
*/

set_graphfile(s)
	char *s;
{
	char buf[64];
	char *p;
	char *rindex ();

	if (s[0] == '/')
		strncpy(graphfile, s, sizeof(graphfile)-1);
	else {
#if 0
		getcwd(graphfile, sizeof(graphfile)-2);
		graphfile[sizeof(graphfile)-2] = 0;
#else
		strcpy (graphfile, currentDirectory);
#endif
		strcat(graphfile, "/");
		strncat(graphfile, s, sizeof(graphfile) - strlen(graphfile) - 1);
	}
	p = (p = rindex(s, '/')) ? p + 1 : s;
	strcpy(buf, "graph: ");
	strncat(buf, p, sizeof(buf) - strlen(buf) - 1);
	set_label(grfButton, buf);
}

set_costfile(s)
	char *s;
{
#if 0
	char buf[64];
	char *p;

	strncpy(costfile, s, sizeof(costfile)-1);
	p = (p = rindex(s, '/')) ? p + 1 : s;
	strcpy(buf, "costs: ");
	strncat(buf, p, sizeof(buf) - strlen(buf) - 1);
	set_label(costButton, buf);
#endif
	char buf[64];
	char *p;
	char *rindex ();

	if (s[0] == '/')
		strncpy(costfile, s, sizeof(costfile)-1);
	else {
#if 0
		getcwd(costfile, sizeof(costfile)-2);
		costfile[sizeof(costfile)-2] = 0;
#else
		strcpy (costfile, currentDirectory);
#endif
		strcat(costfile, "/");
		strncat(costfile, s, sizeof(costfile) - strlen(costfile) - 1);
	}
	p = (p = rindex(s, '/')) ? p + 1 : s;
	strcpy(buf, "costs: ");
	strncat(buf, p, sizeof(buf) - strlen(buf) - 1);
	set_label(costButton, buf);
}

/*
 * set language button label and the language for wrappers
 *
 * if toggle == 1, change from C <-> FORTRAN.
 * if toggle == 0, set from defaults
 *
 */

void
set_language (toggle)
int toggle;
{
	/* make sure there's enough space for either C or FORTRAN in label */
	static char label[] = "language: FORTRAN";

	if (toggle) {
		if (Language == LANG_C)
			Language = LANG_FORTRAN;
		else if (Language == LANG_FORTRAN)
			Language = LANG_C;
		else
			Language = LANG_C;	/* for sanity */
	}
	else {
		if (languageString == NULL)
			Language = LANG_C;
		else if (strcmp (languageString, "FORTRAN") == 0)
			Language = LANG_FORTRAN;
		else if (strcmp (languageString, "Fortran") == 0)
			Language = LANG_FORTRAN;
		else if (strcmp (languageString, "fortran") == 0)
			Language = LANG_FORTRAN;
		else
			Language = LANG_C;
	}

	if (Language == LANG_C)
		languageString = "C";
	else
		languageString = "FORTRAN";

	sprintf (label, "language: %s", languageString);
	set_label (languageButton, label);
}

static void
language_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	set_language (1);
}

void
SetTraceFileLabel ()
{
	char *ptr = traceFileName;

	if (ptr == NULL)
		ptr = "";
	sprintf (crud, "tracefile: %s", ptr);
	set_label (traceFileButton, crud);
}

/*
 * Allow user to specify the name of the trace file.  This will be
 * read by the trace panel, and if the user runs execute, the trace
 * output will be sent there.
 * 
 * We don't actually attempt to read the trace file here, since it
 * might not exist or be bogus at present, only to be scribbled on
 * by the executioner.  We do make sure that either the file exists
 * and is readable, or the directory is writable.
 */

static void
tracefile_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	int can;

	if (trace_ChangeTraceFile (0) == 0)
		return;

	inputname[0] = '\0';
#if 1
	can = fileVerify ("use trace file:", inputname, sizeof (inputname),
					  "*.trace", 0);
#else
	can = filever ("use trace file:", inputname, sizeof (inputname));
#endif
	if (!can) {
		if (*inputname == '\0') {
			msg_Format ("no filename.\n");
			return;
		}
		if (access (inputname, R_OK) != 0) {
			char *ptr = rindex (inputname, '/');
			int dirIsWritable = 0;

			if (ptr) {
				*ptr = '\0';
				dirIsWritable = (access (inputname, W_OK) == 0);
				*ptr = '/';
			}
			else
				dirIsWritable = (access (".", W_OK) == 0);

			if (!dirIsWritable) {
				msg_Format ("%s does not exist, and its directory %s\n",
							inputname, "is not writable");
				return;
			}
		}

		if (traceFileName)
			free (traceFileName);
		traceFileName = strsave (inputname);
		SetTraceFileLabel ();
		(void) trace_ChangeTraceFile (1);
	}
}


/*
 * Local variables:
 * tab-width:4
 * End:
 */
