/*
 *	HeNCE Tool
 *
 *	widgen.c - Generic widget-related stuff.
 *		This is random stuff that's done too many times when using widgets.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#define FILESELECT 1

#include <sys/types.h>
#include <stdio.h>
#include "xincl.h"
#include "xcomn.h"
#include <X11/Xaw/AsciiText.h>
#include "comn.h"
#include "tilde.h"

#ifdef FILESELECT
#include "FileSelect.h"
#endif

#define	MESSAGELINES	8


/*************
*  exported  *
*            *
*************/

/***********
*  global  *
*          *
***********/

static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];
static int verifySt = -1;
static int fileverSt = -1;


/*	cre_cmd_but()
*
*	Create a generic command button.  Saves a bunch of src code.
*	fyi, can use up to 6 Args.
*/

Widget
cre_cmd_but(name, parent, values, nvalues,
		fromy, fromx, label, bits, wd, ht, cbf, cbd)
	char *name;
	Widget parent;			/* our parent */
	Arg *values;			/* optional additional values */
	int nvalues;
	Widget fromy, fromx;	/* positioning */
	char *label;			/* text label */
	char *bits;				/* pixmap label */
	int wd, ht;				/* pixmap size */
	void (*cbf)();			/* callback function */
	int cbd;				/* client data for function */
{
	int n = 0;
	Pixmap pm;
	Window win;
	Arg *argslist;

	if (values && nvalues > 0) {
		argslist = values;
		n = nvalues;
	} else
		argslist = args;
	XtSetArg(argslist[n], XtNresizable, (XtArgVal)True); n++;
	if (bits && wd > 0 && ht > 0) {
		win = RootWindow(xDisp, xScrn);
		pm = XCreatePixmapFromBitmapData(xDisp, win, bits, wd, ht, 1, 0, 1);
		XtSetArg(argslist[n], XtNbitmap, (XtArgVal)pm); n++;
	}
	if (label) {
		XtSetArg(argslist[n], XtNlabel, (XtArgVal)label); n++;
	}
	if (cbf) {
		callback[0].callback = cbf;
		callback[0].closure = (caddr_t)cbd;
		XtSetArg(argslist[n], XtNcallback, callback); n++;
	}
	if (fromx) {
		XtSetArg(argslist[n], XtNfromHoriz, (XtArgVal)fromx);
		n++;
	}
	if (fromy) {
		XtSetArg(argslist[n], XtNfromVert, (XtArgVal)fromy);
		n++;
	}
	return XtCreateManagedWidget(name, commandWidgetClass,
			parent, argslist, n);
}

/*	cre_tog_but()
*
*	Create a generic toggle button.  Saves a bunch of src code.
*	fyi, can use up to 7 Args.
*/

Widget
cre_tog_but(name, parent, values, nvalues,
		fromy, fromx, label, bits, wd, ht, cbf, cbd, ison)
	char *name;
	Widget parent;			/* our parent */
	Arg *values;			/* optional additional values */
	int nvalues;
	Widget fromy, fromx;	/* positioning */
	char *bits;				/* pixmap label */
	char *label;			/* text label */
	int wd, ht;				/* pixmap size */
	void (*cbf)();			/* callback function */
	int cbd;				/* client data for function */
	int ison;				/* initial state */
{
	int n = 0;
	Pixmap pm;
	Window win;
	Arg *argslist;

	if (values && nvalues > 0) {
		argslist = values;
		n = nvalues;
	} else
		argslist = args;
	XtSetArg(argslist[n], XtNresizable, (XtArgVal)True); n++;
	if (ison) {
		XtSetArg(argslist[n], XtNstate, (XtArgVal)ison); n++;
	}
	if (bits && wd > 0 && ht > 0) {
		win = RootWindow(xDisp, xScrn);
		pm = XCreatePixmapFromBitmapData(xDisp, win, bits, wd, ht, 1, 0, 1);
		XtSetArg(argslist[n], XtNbitmap, (XtArgVal)pm); n++;
	}
	if (label) {
		XtSetArg(argslist[n], XtNlabel, (XtArgVal)label); n++;
	}
	if (cbf) {
		callback[0].callback = cbf;
		callback[0].closure = (caddr_t)cbd;
		XtSetArg(argslist[n], XtNcallback, callback); n++;
	}
	if (fromx) {
		XtSetArg(argslist[n], XtNfromHoriz, (XtArgVal)fromx);
		n++;
	}
	if (fromy) {
		XtSetArg(argslist[n], XtNfromVert, (XtArgVal)fromy);
		n++;
	}
	return XtCreateManagedWidget(name, toggleWidgetClass,
			parent, argslist, n);
}

/*	set_label()
*
*	Reset the label prop of a widget to a string
*/

set_label(w, s)
	Widget w;
	char *s;
{
	Arg args[1];

	XtSetArg(args[0], XtNlabel, (XtArgVal)s);
	XtSetValues(w, args, 1);
}

/*	set_togg()
*
*	Set state of toggle button widget.
*/

set_togg(w, v)
	Widget w;
	int v;
{
	Arg args[1];

	XtSetArg(args[0], XtNstate, (XtArgVal)v);
	XtSetValues(w, args, 1);
}

int
cntlines(s)
	char *s;
{
	int n = *s ? 1 : 0;
	char *p = s;

	while (*p)
		if (*p++ == '\n')
			n++;
	return n;
}

char *
findline(s, n)
	char *s;
	int n;
{
	char *p = s;

	while (n-- > 0 && *p)
		while (*p && *p++ != '\n');
	return p;
}

/*	message()
*
*	Log a message to the display.
*/

message(s)
	char *s;
{
    String ptr;
    String current_val;
    XawTextBlock textblock;

    textblock.firstPos = 0;
    textblock.format = FMT8BIT;
    textblock.length = strlen(s);
    textblock.ptr = s;

    XtSetArg(args[0], XtNeditType, XawtextEdit);
    XtSetValues(infoBox, args, 1);

    XawTextReplace(infoBox, 99999, 99999,
        &textblock);

    XawTextSetInsertionPoint(infoBox, 99999);

    XtSetArg(args[0], XtNeditType, XawtextRead);
    XtSetValues(infoBox, args, 1);

    if (s[ strlen(s) -1] != '\n')
		message("\n");

	XtSetArg(args[0], XtNstring, &ptr);
	XtGetValues(infoBox, args, 1);

#define MAX_TEXT_SIZE 40000		/* must be less than 99999 */

	if (strlen(ptr) > MAX_TEXT_SIZE) {
		/* trim it down */
		textblock.firstPos = 0;
		textblock.format = FMT8BIT;
		textblock.length = 0;
		textblock.ptr = 0;

		XtSetArg(args[0], XtNeditType, XawtextEdit);
		XtSetValues(infoBox, args, 1);

		/*
		 * XXX need to eat entire lines from start of buffer
		 * until we have enough space to insert new text
		 */
		
		XawTextReplace(infoBox, 0,  strlen(ptr) - MAX_TEXT_SIZE,
			&textblock);

		XawTextSetInsertionPoint(infoBox, 99999);

		XtSetArg(args[0], XtNeditType, XawtextRead);
		XtSetValues(infoBox, args, 1);
    }
}

static void
verify_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	verifySt = (int)cli;
}

/*	verify()
*
*	Verify an action with user.  Popup up widget with message and wait
*	for confirmation.  On confirmation return
*		0 if 'yes',
*		1 if 'no'
*		2 if 'cancel'
*/

int
verify(msg)
	char *msg;		/* message */
{
	int n;
	Widget w, wf;
	XEvent event;
	int x, y;
	static Widget verifyPop = 0;
	static Widget verifyLabel = 0;
	static Widget verifyCancel = 0;

	get_mousxy(&x, &y);

	/* create popup widget if it doesn't already exist */

	if (verifyPop) {
		n = 0;
		XtSetArg(args[n], XtNlabel, (XtPointer)msg); n++;
		XtSetValues(verifyLabel, args, n);
		if (x)
			XtMoveWidget(verifyPop, x, y);

	} else {
		n = 0;
#if 1
		verifyPop = XtCreatePopupShell("verifyPop",
			transientShellWidgetClass, topLevel, args, n);
#else
		verifyPop = XtCreatePopupShell("verifyPop",
			overrideShellWidgetClass, topLevel, args, n);
#endif
		n = 0;
		wf = XtCreateManagedWidget("", formWidgetClass,
			verifyPop, args, n);

		n = 0;
		XtSetArg(args[n], XtNlabel, (XtPointer)msg); n++;
		XtSetArg(args[n], XtNborderWidth, (XtPointer)0); n++;
		XtSetArg(args[n], XtNresizable, True); n++;

		verifyLabel = XtCreateManagedWidget("bing", labelWidgetClass,
			wf, args, n);

		w = cre_cmd_but("yes", wf, (Arg*)0, 0,
			verifyLabel, (Widget)0, "yes", (char*)0, 0, 0, verify_cb, 0);
		w = cre_cmd_but("no", wf, (Arg*)0, 0,
			verifyLabel, w, "no", (char*)0, 0, 0, verify_cb, 1);
		w = verifyCancel = cre_cmd_but("cancel", wf, (Arg*)0, 0,
			verifyLabel, w, "cancel", (char*)0, 0, 0, verify_cb, 2);

		XtRealizeWidget(verifyPop);
	}

	/* warp it to the current location, bounce off sides of screen */

	if (x) {
		int wd, ht;

		get_wgtxy(verifyPop, &wd, &ht);
		x += wd;
		y += ht;
		get_wgtxy(verifyCancel, &wd, &ht);
		x -= wd;
		y -= ht;
		get_wgtwh(verifyCancel, &wd, &ht);
		x -= wd / 2;
		y -= ht / 2;
		get_wgtwh(verifyPop, &wd, &ht);
		if (x + wd > xDispWd)
			x = xDispWd - wd;
		if (y + ht > xDispHt)
			y = xDispHt - ht;
		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;
		XtMoveWidget(verifyPop, x, y);
	}
	XtPopup(verifyPop, XtGrabExclusive);

	/* let Xt stuff happen until we get a response to popup */

	for (verifySt = -1; verifySt == -1; ) {
		XtAppNextEvent(context, &event);
		XtDispatchEvent(&event);
	}
	XtPopdown(verifyPop);
	return verifySt;
}

static void
filever_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	fileverSt = (int)cli;
}

/*	filever()
 *
 *	Verify a load/store type action with user.  Popup up widget with
 *	message and filename.  Allow user to change filename.
 *	On confirmation return
 *		0 if 'ok',
 *		1 if 'cancel'
 */

int
filever(msg, name, maxlen)
	char *msg;		/* message */
	char *name;		/* [file]name */
	int maxlen;		/* max length of name */
{
	int n;
	Widget w, wf;
	XEvent event;
	int x, y, wd, ht;
	static Widget fileverPop = 0;
	static Widget fileverLabel = 0;
	static Widget fileverName = 0;
	static Widget fileverOk = 0;

	get_mousxy(&x, &y);

	/* create popup if it doesn't already exist */

	if (fileverPop) {
		n = 0;
		XtSetArg(args[n], XtNlabel, msg); n++;
		XtSetValues(fileverLabel, args, n);
		n = 0;
		XtSetArg(args[n], XtNstring, name); n++;
		XtSetArg(args[n], XtNlength, maxlen - 1); n++;
		XtSetValues(fileverName, args, n);
		n = 0;
		XtSetArg(args[n], XtNinsertPosition, strlen(name)); n++;
		XtSetValues(fileverName, args, n);

	} else {
		XtAccelerators atbl;

		atbl = XtParseAcceleratorTable(
			"#override\n<Key>Return:set()notify()reset()\n");
		n = 0;
#if 1
		fileverPop = XtCreatePopupShell("fileverPop",
			transientShellWidgetClass, topLevel, args, n);
#else
		fileverPop = XtCreatePopupShell("fileverPop",
			overrideShellWidgetClass, topLevel, args, n);
#endif

		n = 0;
		wf = XtCreateManagedWidget("", formWidgetClass,
			fileverPop, args, n);

		n = 0;
		XtSetArg(args[n], XtNlabel, (XtPointer)msg); n++;
		XtSetArg(args[n], XtNborderWidth, (XtPointer)0); n++;
		fileverLabel = XtCreateManagedWidget("fileverLabel", labelWidgetClass,
			wf, args, n);

		n = 0;
		XtSetArg(args[n], XtNfromVert, fileverLabel); n++;
		XtSetArg(args[n], XtNstring, name); n++;
		XtSetArg(args[n], XtNlength, maxlen - 1); n++;
		XtSetArg(args[n], XtNeditType, XawtextEdit); n++;
		XtSetArg(args[n], XtNuseStringInPlace, 1); n++;
		XtSetArg(args[n], XtNinsertPosition, strlen(name)); n++;
		XtSetArg(args[n], XtNresize, XawtextResizeBoth); n++;
		XtSetArg(args[n], XtNresizable, True); n++;
		fileverName = XtCreateManagedWidget("filevarName", asciiTextWidgetClass,
				wf, args, n);

		n = 0;
		XtSetArg(args[n], XtNaccelerators, atbl); n++;
		fileverOk = w = cre_cmd_but("ok", wf, args, n,
			fileverName, (Widget)0, "ok", (char*)0, 0, 0, filever_cb, 0);
		w = cre_cmd_but("cancel", wf, (Arg*)0, 0,
			fileverName, w, "cancel", (char*)0, 0, 0, filever_cb, 1);

		XtRealizeWidget(fileverPop);
		XtInstallAccelerators(fileverName, fileverOk);
	}

	/* warp it to mouse location */

	if (x) {
		get_wgtxy(fileverPop, &wd, &ht);
		x += wd;
		y += ht;
		get_wgtxy(fileverName, &wd, &ht);
		x -= wd;
		y -= ht;
		get_wgtwh(fileverName, &wd, &ht);
		x -= wd - 10;
		y -= ht - 10;
		get_wgtwh(fileverPop, &wd, &ht);
		if (x + wd > xDispWd)
			x = xDispWd - wd;
		if (y + ht > xDispHt)
			y = xDispHt - ht;
		if (x < 0)
			x = 0;
		if (y < 0)
			y = 0;
		XtMoveWidget(fileverPop, x, y);
	}
	XtPopup(fileverPop, XtGrabExclusive);
/*
	get_wgtxy(fileverName, &x, &y);
	get_wgtwh(fileverName, &wd, &ht);
	XWarpPointer(xDisp, None, xRootW, 0, 0, 0, 0, x + wd - 10, y + ht / 2);
*/

	/* let Xt stuff run until we get a response to popup */

	for (fileverSt = -1; fileverSt == -1; ) {
		XtAppNextEvent(context, &event);
		XtDispatchEvent(&event);
	}
	XtPopdown(fileverPop);
	return fileverSt;
}

#ifdef FILESELECT

/*	fileVerify ()
 *
 *	Verify a load/store type action with user.  Popup up widget with
 *	message and filename.  Allow user to change filename.
 *	On confirmation return
 *		0 if 'ok',
 *		1 if 'cancel'
 */

static int fileVerifyStatus = -1;

static void
fileVerifyCallback (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	String selection;

	fileVerifyStatus = (int) cd;
	switch (fileVerifyStatus) {
	case 0:
		XtVaGetValues (w, XtNselection, &selection, NULL);
#if 0
		fprintf (stderr, "selected %s\n", selection);
#endif
		break;
	case 1:
#if 0
		fprintf (stderr, "cancel\n");
#endif
		break;
	}
}

int
fileVerify (msg, name, maxlen, filter, flags)
char *msg;
char *name;
int maxlen;
char *filter;
int flags;
{
	int x, y;
	Widget fileVerPop = 0;
	Widget fileVer = 0;
	XEvent event;
	String result;

	get_mousxy(&x, &y);

	/* create a widget */
#if 1
	fileVerPop = XtCreatePopupShell ("fileverPop",
									 transientShellWidgetClass,
									 topLevel, NULL, 0);
#else
	fileVerPop = XtCreatePopupShell ("fileverPop",
									 overrideShellWidgetClass,
									 topLevel, NULL, 0);
#endif
	fileVer = XtVaCreateManagedWidget ("fileselect", fileselectWidgetClass,
									   fileVerPop,
									   XtNlabel1, (XtPointer) msg,
									   XtNfilter, (XtPointer) filter,
									   XtNflags, (XtPointer) flags,
									   NULL);
	XtAddCallback (fileVer, XtNcallback, fileVerifyCallback,
				   (XtPointer) NULL);

	XtVaSetValues (fileVerPop,
				   XtNwidth, (XtPointer) 500,
				   XtNheight, (XtPointer) 300,
				   NULL);

	XtRealizeWidget (fileVerPop);
	if (x)
		XtMoveWidget (fileVerPop, x, y); /* XXX don't do this,
											set origin when created */

	if (*name != '\0') {
#if 0
		fprintf (stderr, "fileVerify: setting selection to %s\n", name);
#endif
		XtVaSetValues (fileVer,
					   XtNselection, (XtPointer) name,
					   NULL);
	}
#if 0
	else
		fprintf (stderr, "fileVerify: not setting selection\n", name);
#endif

	XtPopup (fileVerPop, XtGrabExclusive);
	for (fileVerifyStatus = -1; fileVerifyStatus == -1; ) {
		XtAppNextEvent (context, &event);
		XtDispatchEvent (&event);
	}
	if (fileVerifyStatus == 0) {
		result = NULL;
		XtVaGetValues (fileVer, XtNselection, &result, NULL);
		if (result)
			strncpy (name, texpand (result), maxlen);
	}
	XtPopdown (fileVerPop);

	XtDestroyWidget (fileVerPop);
	return fileVerifyStatus;
}

#endif

float_wgt(wgt)
	Widget wgt;
{
	Window w;

	w = XtWindow(wgt);
	XRaiseWindow(xDisp, w);
}

/*	get_wgtxy()
*
*	Return x &/| y of u.l.c. of widget's window.
*/

get_wgtxy(wgt, px, py)
	Widget wgt;
	int *px, *py;
{
	int x, y;
	Window w, wc;

	w = XtWindow(wgt);
	XTranslateCoordinates(xDisp, w, xRootW,
		0, 0, &x, &y, &wc);
	if (px)
		*px = x;
	if (py)
		*py = y;
}

/*	get_wgtwh()
*
*	Return wd &/| ht of widget's window.
*/

get_wgtwh(wgt, px, py)
	Widget wgt;
	int *px, *py;
{
	Window w;
	XWindowAttributes wat;

	w = XtWindow(wgt);
	XGetWindowAttributes(xDisp, w, &wat);
	if (px)
		*px = wat.width;
	if (py)
		*py = wat.height;
}

/*	get_mousxy()
*
*	Return x, y of mouse in rootwindow.
*/

get_mousxy(px, py)
	int *px, *py;
{
	Window w1, w2;
	int i;

	if (XQueryPointer (xDisp, xRootW, &w1, &w2, px, py, &i, &i,
					   (unsigned int *) &i) == False) {
		*px = *py = 0;
	}
}

/*	get_winwh()
*
*	Return wd &/| ht of widget's window.
*/

get_winwh(win, px, py)
	Window win;
	int *px, *py;
{
	XWindowAttributes wat;

	XGetWindowAttributes(xDisp, win, &wat);
	if (px)
		*px = wat.width;
	if (py)
		*py = wat.height;
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
