#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(x) x
#else
#define __(x) ()
#endif

struct event_time {
    long secs;					/* seconds */
    long serial;				/* serial # */
	long fileaddr;				/* fseek address in trace file */
};

struct trace_event {
	struct event_time timestamp;
    int id;						/* HeNCE node id */
    int inst;					/* HeNCE node instance number */
    int event_type;				/* event type */
#define	TEV_START	0			/* start HeNCE program */
#define	TEV_WAITING	1			/* node waiting for ancestors */
#define	TEV_READY	2			/* node ready to run */
#define	TEV_RUNNING	3			/* node running */
#define	TEV_DONE	4			/* node finished with computation */
#define	TEV_DEAD	5			/* node program dead */
#define	TEV_FINISH	6			/* HeNCE program finished */
#define TEV_MACHINE	7			/* machine name (sent before program starts) */
#define TEV_VNODE	8			/* virtual node expansion */
#define	TEV_UNKNOWN	9
    int tf;						/* true/false for loop, switch, pipe */
    int lo;						/* low fanout value */
    int hi;						/* high fanout value */
	struct host_info *host;		/* *UNTRACED* pointer to host info */
};

typedef struct trace_event *TraceEvent;

int tf_TimeCompare __((struct event_time *t1, struct event_time *t2));
int tf_GetEventCode __((char *event_name));
char *tf_GetEventName __((int event_type));
int tf_NextEvent __((struct trace_event *event));
int tf_PrevEvent __((struct trace_event *event));
int tf_SetFile __((char *filename));
int tf_Seek __((struct event_time *t));
int tf_Rewind __(());

#undef __

/*
 * Local variables:
 * tab-width:4
 * End:
 */
