/*
 *	HeNCE Tool
 *
 *	symtab.c - Symbol table stuff.
 *
 *	Sep 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#include "rb.h"
#include "symtab.h"

static int
nameCompare(a, b)
	Key *a, *b;
{
	return strcmp((char*)(a->pkey), (char*)(b->pkey));
}

/*	st_New()
*
*	Create a new (empty) symbol table and return it.
*/

Tree
st_New()
{
	return rb_MakeTree();
}

void
st_Free(st)
	Tree st;
{
	TreeNode tn;
	Key *k;

	for (tn = rb_First(st); tn != st; tn = rb_Next(tn)) {
		k = rb_Key(tn);
		free(k->pkey);
	}
	rb_FreeTree(st);
}

/*	st_Lookup()
*
*	Look up a name in a symbol table.
*	Return 1 if found, else 0.
*/

int
st_Lookup(st, name)
	Tree st;
	char *name;
{
	TreeNode tn;
	Key key;
	int fnd;

	key.pkey = (void*)name;
    tn = rb_Find(st, &key, nameCompare, &fnd);
    return fnd ? 1 : 0;
}

/*	st_Insert()
*
*	Insert up a name in a symbol table.
*	Return 0 if okay, else 1 if name already there.
*/

int
st_Insert(st, name)
	Tree st;
	char *name;
{
	TreeNode tn;
	Key key;
	int fnd;

	key.pkey = (void*)name;
    tn = rb_Find(st, &key, nameCompare, &fnd);
	if (fnd)
		return 1;
	key.pkey = (void*)strsave(name);
	rb_InsertBefore(tn, &key, (void*)1);
	return 0;
}

char*
st_Key(tn)
	TreeNode tn;
{
	Key *k;

	k = rb_Key(tn);
	return (char*)(k->pkey);
}

