/*
 *	HeNCE Tool
 *
 *	pvm.c - Interface to pvm
 *
 *	October 1991  Keith Moore <moore@cs.utk.edu>
 *
 *	Revision Log
 *
 $Log$
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include "xincl.h"
#include "rb.h"
#include "param.h"
#include "exp.h"				/* XXX Yuk! */
#include "graph.h"
#include "costmat.h"
#include "xcomn.h"
#include "comn.h"
#include "subproc.h"
#include "pvmglue.h"

extern int errno;				/* 4.3bsd needs this */

static int pvmPid = 0;

static void
pvm_Done (pid, exitArg, clientData, howDied)
int pid;
int exitArg;
void *clientData;
enum causeOfDeath howDied;
{
    if (howDied == SUBPROC_KILLED) {
		msg_Format ("pvmd (pid %d) was killed with signal %d\n",
					pid, exitArg & ~0200);
    }
    else if (exitArg != 0) {
		msg_Format ("pvmd (pid %d) exited abnormally with status %d\n",
					pid, exitArg);
    }
    else
		msg_Format ("pvmd exited normally\n");

    if (pid == pvmPid) {	/* should always be true */
		subproc_Pclose (pvmPid);
		pvmPid = 0;
		if (clientData != NULL) {
#if 0
			set_label ((Widget) clientData, "start pvm");
#else
			XtVaSetValues ((Widget) clientData,
						   XtNsensitive, True,
						   NULL);
#endif
		}
    }
}

static void
pvm_Sink (fd, x)
int fd;
void *x;
{
    char buf[5120];
    int nread;
    char *ptr1, *ptr2;
    
    if ((nread = read (fd, buf, sizeof buf - 1)) <= 0)
		return;
    buf[nread] = '\0';
    
    /*
     * print out one line at a time, so we can print the child process
     * name before the line of output.
     */
    ptr1 = buf;
    while (ptr2 = index (ptr1, '\n')) {
		*ptr2 = '\0';
		msg_Format ("%s\n", ptr1);
		ptr1 = ptr2 + 1;
    }
    if (ptr1 < buf + nread)
		msg_Format ("%s\n", ptr1);
}

/*
 * If pvmd is running, kill it.
 * If pvmd is not running, start one up.
 *
 * called from pvm_start_cb() in widmain.c
 */

extern Widget startPvmButton;	/* XXX I'm ashamed of this - km */

void
pvm_StartStop (w, hostfile)
Widget w;
char *hostfile;
{
    if (pvmPid != 0) {
		if (kill (pvmPid, SIGTERM) < 0) {
			if (errno == EPERM) {
				msg_Format ("can't kill pvm (pid %d): not owner (!)\n",
							pvmPid);
				msg_Format ("try typing \"quit\" in the pvm console window\n");
				return;
			}
			else if (errno == ESRCH) {
				/*
				 * child died without our knowing it - do appropriate
				 * cleanup.
				 */
				msg_Format ("OOPS: pvmd (pid %d) died without SIGCHLD\n",
							pvmPid);
				pvm_Done (pvmPid, 0, startPvmButton, SUBPROC_EXITED);
			}
		}
		return;
	}
    else
		pvm_Start (hostfile);
}


/*
 * start up pvmd in an xterm with the supplied host file as an argument
 *
 * XXX putting this in an xterm window is lame.  For one thing,
 * there is no way to see what went wrong if pvmd startup fails,
 * because the window goes away when pvmd dies.  Another problem
 * is that "kill pvm" doesn't work, because xterm often runs set-uid
 * to root (so it can write /etc/utmp).
 *
 * XXX need to check and see if there's already a pvm running.
 * (i.e. one that was started external to htool)
 *
 * this is called from do_execute () in execute.c, as well as from
 * pvm_StartStop(), above.
 */

int
pvm_Start (hostfile)
char *hostfile;
{
    char crud[1024];
    
    if (pvmPid != 0)
		return 1;

    sprintf (crud, "exec %s -title 'HeNCE - PVM console' -sb -e %s -i %s",
	     xtermCommand, pvmdExecPath, hostfile);
#if 0
	fprintf (stderr, "%s\n", crud);
#endif
    if ((pvmPid = subproc_Popen (crud, pvm_Done,
								 pvm_Done, pvm_Sink, startPvmButton)) <= 0) {
		msg_Format ("couldn't run %s\n", pvmdExecPath);
		pvmPid = 0;
		return -1;
    }
#if 0
    set_label (startPvmButton, "kill pvm");
#else
	XtVaSetValues (startPvmButton,
				   XtNsensitive, False,
				   NULL);
#endif
    return 0;
}

int
pvm_IsRunning ()
{
    return (pvmPid != 0);
}



/*
 * Local variables:
 * tab-width:4
 * End:
 */
