/*
 *	HeNCE Tool
 *
 *	psgraph.c - Postscript graph routines.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <pwd.h>
#include "rb.h"
#include "param.h"
#include "exp.h"		/* XXX Yuk! */
#include "graph.h"
#include "graphP.h"
#include "comn.h"

/* these define the arrowhead size and proximity to node */

#define	NODERADIUS 10	/* size of graph node circle */
#define	ARROWX	NODERADIUS/2
#define	ARROWY	(NODERADIUS/4)
#define	ARROWPROX (NODERADIUS*5/4)

extern char *psheader[];	/* from psheader.c */

static char *psnodenames[] = {
	"RegularNode",
	"BeginSwitchNode",
	"EndSwitchNode",
	"BeginLoopNode",
	"EndLoopNode",
	"BeginFanNode",
	"EndFanNode",
	"BeginPipeNode",
	"EndPipeNode",
	0
};

/*	gr_EPS()
*
*	Write graph to a text file in encapsulated postscript.
*/

void
gr_EPS(grf, ff)
	Graph grf;
	FILE *ff;
{
	Tree tr = grf->nlist;
	Tree tra;
	TreeNode tn, tna;
	Node n, n2;
#if 0
	int i;
#endif
	long now = time((long*)0);
	int bbx1 = 0, bby1 = 0, bbx2 = 0, bby2 = 0;
	int x, y;
	char **pp;
	struct passwd *pe;
	char *loginname = strsave("who_am_i");

	if (pe = getpwuid(getuid())) {
		free(loginname);
		loginname = strsave(pe->pw_name);
	}
	endpwent();

	/* get bbx of graph */

	if ((tn = rb_First(tr)) != tr) {
		n = (Node)rb_Value(tn);
		bbx1 = bbx2 = n->xy.x;
		bby1 = bby2 = n->xy.y;

		while ((tn = rb_Next(tn)) != tr) {
			n = (Node)rb_Value(tn);
			if (n->xy.x < bbx1) bbx1 = n->xy.x;
			if (n->xy.x > bbx2) bbx2 = n->xy.x;
			if (n->xy.y < bby1) bby1 = n->xy.y;
			if (n->xy.y > bby2) bby2 = n->xy.y;
		}
	}
	bbx1 -= NODERADIUS*2;
	bby1 -= NODERADIUS*2;
	bbx2 += NODERADIUS*2;
	bby2 += NODERADIUS*2;

	/* write eps header */

	fprintf(ff, "%%!\n");
	fprintf(ff, "%%%%Title: A HeNCE Graph\n");
	fprintf(ff, "%%%%Creator: htool\n");
	fprintf(ff, "%%%%CreationDate: %s", ctime(&now));
	fprintf(ff, "%%%%For: %s@thishost\n", loginname);
	fprintf(ff, "%%%%Pages: 0\n");
	fprintf(ff, "%%%%BoundingBox: %d %d %d %d\n", bbx1, bby1, bbx2, bby2);
	fprintf(ff, "%%%%EndComments\n");

	/* write postscript function defs */
	for (pp = psheader; *pp; pp++)
		fputs(*pp, ff);

	fprintf(ff, "/NodeRad %d def\n", NODERADIUS);
	fprintf(ff, "/NodeRad2 NodeRad 2 div def\n");
	fprintf(ff, "/ArrowX %d def\n", ARROWX);
	fprintf(ff, "/ArrowY %d def\n", ARROWY);
	fprintf(ff, "/ArrowProx %d def\n", ARROWPROX);

	/* draw all the node outlines */

	fprintf(ff, "/Helvetica findfont %d scalefont setfont\n",
		NODERADIUS*2);
	for (tn = rb_First(tr); tn != tr; tn = rb_Next(tn)) {
		n = (Node)rb_Value(tn);
		x = n->xy.x;
		y = bby2 - n->xy.y + bby1;
		fprintf(ff, "%d %d %s\n", x, y, psnodenames[n->node_type]);
	}

	/* draw all the arcs */

	for (tn = rb_First(tr); tn != tr; tn = rb_Next(tn)) {
		n = (Node)rb_Value(tn);
		tra = n->children;
		for (tna = rb_First(tra); tna != tra; tna = rb_Next(tna)) {
			n2 = (Node)rb_Value(tna);
			fprintf(ff, "%d %d %d %d ConnectArc\n",
				n->xy.x, bby2 - n->xy.y + bby1,
				n2->xy.x, bby2 - n2->xy.y + bby1);
		}
	}

	/* label all the nodes */

	fprintf(ff, "/Helvetica findfont %d scalefont setfont\n",
		NODERADIUS);
	for (tn = rb_First(tr); tn != tr; tn = rb_Next(tn)) {
		n = (Node)rb_Value(tn);
		x = n->xy.x;
		y = bby2 - n->xy.y + bby1;
		fprintf(ff, "%d %d (%d) LabelNodeId\n", x, y, n->nk.id);

		switch (n->node_type) {
		case NODE_NORMAL:
			if (n->sub_name) {
				fprintf(ff, "%d %d (%s()) LabelNodeParam\n",
					x, y, n->sub_name);
			}
			break;

#if 0
		case NTYPE_BP:
		case NTYPE_BL:
		case NTYPE_FO:
			fprintf(ff, "%d %d (%s; (%s)) LabelNodeParam\n",
				x, y, (n->fun ? n->fun : ""), (n->par ? n->par : ""));
			break;

		case NTYPE_BS:
			fprintf(ff, "%d %d ((%s)) LabelNodeParam\n",
				x, y, (n->par ? n->par : ""));
			break;
#endif

		default:
			break;
		}
	}

	fprintf(ff, "showpage\n");
}

