#include <stdio.h>
#include "misc.h"

char *
strsave (
#if FuncPr
	char *s)
#else
	s)
	char *s;
#endif
{
    char *p;
    int len;
	char *malloc();
	
    if (s == NULL)
	return NULL;
    p = malloc (len = (strlen(s) + 1));
    bcopy (s, p, len);
    return p;
}

#if defined(IMA_SYMM) || defined(IMA_NEXT)
/*
 * getcwd() implemented in terms of getwd().
 */

#include <errno.h>
#include <sys/param.h>

char *
getcwd (buf, size)
char *buf;
int size;
{
	char mybuf[MAXPATHLEN];
	int length;

	if (size <= 0) {
		errno = EINVAL;
		return NULL;
	}
	(void) getwd (mybuf);
	length = strlen (mybuf);

	if (length + 1 > size){
		errno = ERANGE;
		return NULL;
	}
	if (buf == NULL)
		buf = malloc (length + 1);
	if (buf == NULL)
		return NULL;
	strcpy (buf, mybuf);
	return buf;
}
#endif

#ifdef IMA_SYMM
#include <varargs.h>

int
vsprintf (buf, format, args)
char *buf, *format;
va_list args;
{
	FILE f;
	int length;

	f._flag = _IOWRT|_IOSTRG;
	f._ptr = buf;
	f._cnt = 32767;
	length = _doprnt (format, args, &f);
	*(f._ptr) = '\0';
	return (length);
}
#endif

/*
 * POSIX-style strerror() function
 */

char *
strerror (errno)
int errno;
{
	extern int sys_nerr;
	extern char *sys_errlist[];
	static char msg[25];

	if (errno >= 0 && errno < sys_nerr)
		return sys_errlist[errno];

	sprintf (msg, "Error %d", errno);
	return msg;
}

#ifdef IMA_HP9K
#include <unistd.h>

int
getdtablesize ()
{
	return sysconf(_SC_OPEN_MAX);
}
#endif


/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
