#ifdef __
#undef __
#endif
#if defined(__STDC__)
#define __(x) x
#else
#define __(x) ()
#endif

typedef struct graph *Graph;

struct xyloc {
	int set;
	int x;
	int y;
};

struct nodekey {
	int id;
	int inst;
};

struct node {					/* Representation of a node */
	int node_type;				/* Node's type: e.g. NORMAL */
#define NODE_NORMAL		0
#define NODE_COND		1
#define NODE_ENDCOND	2
#define NODE_LOOP		3
#define NODE_ENDLOOP	4
#define NODE_FANOUT		5
#define NODE_FANIN		6
#define NODE_PIPE		7
#define NODE_ENDPIPE	8
	struct xyloc xy;
	struct nodekey nk;			/* Node's id and instance */
	int *instgen;				/* Instance number generator */
	int nparams;				/* Number of parameters */
	Tree params;				/* Parameters: RB_Tree: 
								 * key: Param name p->name
								 * val: Param pointer p */
	char *sub_name;				/* Subroutine name */
	Param ret_param;			/* The return parameter (or ind var in
								 * FAN's, PIPES) */
	char arrays;				/* Boolean: Are there any array params */
	int nargs;					/* Number of args to the subroutine */
	struct expression **args;	/* Array of args to the subroutine */
	Tree parents;				/* Parent nodes:  Rb_tree:
								 * key, val: node pointer (sorted as an int) */
	int nparents;				/* The number of parents */
	Tree children;				/* Child nodes:  Rb_tree:
								   key, val: node pointer (sorted as an int) */
	int nchildren;				/* The number of children */
	struct node *pair;			/* Pair nodes: LOOP-ENDLOOP, etc. */
	struct node *scope;			/* For static error checking */
	int flags;					/* Random manipulative variable */
#define NF_SCOPE_VALID	01
#define NF_BEEN_HERE	02
#define NF_EDITING		04		/* 1 if node being edited */
	int pvminum;				/* Pvm instance number */
	int state;					/* State (e.g. READY, RUNNING, DONE).  If the 
								   state is negative, it is the number of
								   parents that this node is waiting for. */
#define	ST_NOT_BEGUN	0		/* for execution */
#define	ST_READY		1
#define	ST_RUNNING		2
#define	ST_DONE			3
#define	ST_DEAD			4

#define	ST_ERROR		5		/* for graph checking */
#define	ST_WARNING		6
/* XXX be sure these work out with the GCs in xgraph.c */

	struct node *mirror;		/* For help in copying */

#if 0
	char *machine;				/* Machine name */
	Anc anc;					/* Ancestor information */
	Dlist aa;					/* Ancestor/Array information */
	long ttime;					/* Total time, from initiateM to rcv */
	long stime;					/* Total slave time */
	long sbtime;				/* Total subroutine time */
#endif
	/* these are for tracing */
	int numRunning;				/* number of instances running */
	int numIdle;			    /* number of instances idle */
};

typedef struct node *Node;

/*
 * Create a new graph
 */
extern Graph gr_New ();

/*
 * free all of the storage associated with a graph
 */
extern void gr_Free ();

/*
 * Add a node to the graph
 */
extern void gr_AddNode __((Graph g, Node n));

/*
 * Remove a node from the graph
 */

extern int gr_RemNode __((Graph g, Node n));

/*
 * set the number of args for a node
 */

extern void gr_ResizeNodeArgs __((Node node, int nargs));

/*
 * add an argument to a node
 */

extern void gr_AddNodeArg __((Node node, Expr exp));

/*
 * Build an arc from one node to another
 *
 * Returns 0 if ok, else 1 if arc exists.
 */

extern int gr_BuildAnArc __((Graph g, Node from, Node to));

/*
 * build an arc from one node to another
 *
 * Returns 0 if ok, else 1 if arc exists, 2 if node not found.
 */

extern int gr_BuildArc __((Graph g, int from, int to));

/*
 * remove an arc from one node to another
 *  XXX in the process of being tossed
 */

extern int gr_RemArc __((Graph g, int from, int to));

/*
 *  Remove an arc from one node to another
 */

extern int gr_RemAnArc __((Graph g, Node from, Node to));

/*
 *  Tell if arc from one node to another
 */

extern int gr_IsArc __((Node from, Node to));

/*
 * Given a node id, return the node structure that corresponds to it
 */

extern Node gr_GetNodeById __((Graph g, int node_id));

extern Node gr_GetNodeByIdInst __((Graph g, int node_id, int instance));

/*
 * Create and return a pointer to a new node.  if node_id < 1,
 * find a unique node id and assign it.
 */

extern Node gr_NewNode __((int node_id));

/*
 *  Free all storage associated with a node.
 *  Node should not be in a graph.
 */

extern void gr_FreeNode __((Node n));

/*
 * Set the display location of a node
 */

extern void gr_SetNodeLoc __((Node n, int x, int y));

/*
 * return the display location of a node.  Return value is zero if
 * the location is valid, otherwise -1.
 */

extern int gr_GetNodeLoc __((Node n, int *x, int *y));

extern void gr_SetNodeType __((Node n, int node_type));

extern int gr_GetNodeType __((Node n));

extern int gr_GetNodeId __((Node n));

extern int gr_HiNodeId __((Graph g));

/*
 * add a parameter to this node
 */

extern void gr_AddNodeParam __((Node n, Param p));

extern int gr_PatchNode __((Node n1, Node n2));

/*
 *	Make an independant copy of a graph.  All nodes in src graph must
 *	have only a single instance.
 */

extern Graph gr_CopyGraph __((Graph g));

/*
 *	Make a new instance of a node.
 */

extern Node gr_CopyNode __((Node n));

/*
 *	Make a new instance of a subgraph.  Must be handed a paired node.
 *	Returns pointer to the new instance of the node originally passed.
 *
 *	If 'sep' is true, makes a complete separate copy, else copies
 *	interior nodes only and links them in.
 */

extern Node gr_CopySubgraph __((Graph g, Node n, int sep, int xof, int yof));

extern void gr_NullifyNode __((Graph g, Node n));

/* ________________________________________________________________________
 *  XXX This stuff might want to be in a separate .h, it's in files
 *      other than graph.c
 */

extern void gr_EPS __((Graph grf, FILE *ff));

extern int gr_Empty __((Graph g));

/*
 * set the state of every node in the graph to "state".
 */

extern void gr_ResetGraph __((Graph g, int state));


/*
 * reset the state of every node in a subgraph to state,
 * and reset their numRunning and numIdle counters to zero.
 */

void gr_ResetSubGraph __((Node n, int state));

#undef __

/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
