#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(X) X
#else
#define __(X) ()
#endif

typedef struct expression *Expr;

extern Expr expr_New __((char data_type, char op));
extern void expr_Free __((Expr x));
extern Expr expr_UnaryOp __((char op, Expr operand));
extern Expr expr_BinaryOp __((char op, Expr operand1, Expr operand2));
extern Expr expr_TernaryOp __((char op, Expr operand1, Expr operand2,
							   Expr operand3));
extern Expr expr_Param __((Param p));
extern Expr expr_Const __((char type, void *ptr));
/* extern int expr_Type __((Expr e)); */

#if 0
extern int expr_Compare __((Expr e1, Expr e2));
#endif

/* operators */

#define OP_COND_EXPR	'?'
#define OP_LOGICAL_OR	'o'
#define OP_LOGICAL_AND	'a'
#define OP_LOGICAL_CMPL	'N'		/* logical negation ('!') */
#define OP_BIT_OR	'|'
#define OP_BIT_AND	'&'
#define OP_BIT_XOR	'^'
#define OP_BIT_CMPL	'~'		/* one's complement */
#define OP_COMP_NE	'!'
#define OP_COMP_EQ	'='
#define OP_COMP_LE	'l'
#define OP_COMP_GE	'g'
#define OP_COMP_LT	'<'
#define OP_COMP_GT	'>'
#define OP_LSHIFT	'L'
#define OP_RSHIFT	'R'
#define OP_MULT		'*'
#define OP_DIV		'/'
#define OP_MOD		'%'
#define OP_ADD		'+'
#define OP_SUBTRACT	'-'
#define OP_NEG		'M'		/* additive inverse (unary '-') */
#define OP_INDIR	'I'		/* pointer indirection (unary '*') */
#define OP_ADDRESS	'A'		/* address of (unary '&') */
#define OP_EMPTY_DIM	'['		/* empty array dimension */
#define OP_DIM		']'		/* array dimension */
#define OP_ARR_SECTION	'.'		/* array section e.g. [ x1 : x2 ] */
#define OP_PARAM	'P'		/* "parameter" (e.g. variable name) */
#define OP_CONST	'c'		/* constant expression */

/* data types */

#define TYPE_PARAM		-3	/* data type is that of parameter */
#define TYPE_UNSPECIFIED	-2	/* node type unspecified */
#define TYPE_INHERITED		-1	/* type inherited from ancestors */
#define TYPE_INT		0
#define TYPE_CHAR		1
#define TYPE_FLOAT		2
#define TYPE_DOUBLE		3
#define TYPE_ARRAY		4
#define TYPE_STRING		5	/* XXX is this used? */
#define NTYPES			6	/* number of "real" types */

#undef __

/*
 * Local Variables:
 * tab-width:4
 * comment-column:40
 * End:
 */
