/*
 *	HeNCE Tool
 *
 *	costmat.h - Main widget stuff.
 *		Defines for using costmat.c
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(X) X
#else
#define __(X) ()
#endif

/* Cost matrix */

struct costm {
	int isModified;			/* true iff modified since last read/save */
	int nhost;				/* number of hosts */
	int nsub;				/* number of subroutines */
	char **hosts;			/* pointers to hostnames */
	int *hflag;				/* flags for hosts */
	char **subs;			/* pointers to sub names */
	int *sflag;				/* flags for subs */
	int *mat;				/* the matrix, first dimension is by host */
};

/* flags for ->hflag[] and ->sflag[] */

#define	SUBHOST_EN		1	/* host is enabled for use */
#define	SUBHOST_HOST	2	/* host is needed */
#define	SUBHOST_SUB		4	/* sub is needed */
#define SUBHOST_INPVM	8	/* host is included in pvm hosts file */


struct costm *cm_New __(());
void cm_Free __((struct costm *cm));
int cm_AddEntry __((struct costm *cm, char *host, char *sub, int val));
int cm_ReadFile __((char *filename, struct costm **cmp));
int cm_WriteFile __((char *filename, struct costm *cmp));
int cm_CheckGraph __((Graph grf, struct costm *cm));
/* int cm_MakePvmHostFile __((struct costm *cm, char *filename)); */
int cm_HostIsPresent __((struct costm *cm, char *hostname));
void cm_ClearPvmFlag __((struct costm *cm));
int cm_CheckPvmFlag __((struct costm *cm));
int cm_SubIsPresent __((struct costm *cm, char *subname));
int cm_BuildPvmHostFile __((FILE *in, FILE *out, struct costm *costmat));
int cm_AddNamesFromGraph __((Graph g, struct costm *cm));
#undef __

/*
 * Local variables:
 * tab-width:4
 * End:
 */

