/*
 *	HeNCE Tool
 *
 *	build.c - Building and Installation stuff.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log$
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include "xincl.h"
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "graph.h"
#include "symtab.h"
#include "xcomn.h"
#include "comn.h"
#include "funcdefs.h"

#define SUBPROX 1				/* experimental subprocess stuff */
#define BUTTONZ 1				/* experimental buttons stuff */

#ifdef SUBPROX					/* XXX experimental for now */
#include "subproc.h"
int build_ChildPid;
#endif

/* #define	SUBDEFSFILE		"sub.defs" */
#define	MAKEFILENAME	"Makefile"

extern int errno;				/* 4.3bsd needs this */

/*******************
*  from elsewhere  *
*                  *
*******************/

extern char directory[1024];		/* from widmain.c */
extern char costfile[1024];			/* from widmain.c */
extern Graph scratchgraph;			/* from widmain.c */
extern struct costm *costmatrix;	/* from widmain.c */
extern Widget buildButton;			/* from widmain.c */


/*************
*  exported  *
*            *
*************/

void start_build();
int stop_build();


/***********
*  global  *
*          *
***********/

static void subdefs_cb();
static void mkmf_cb();
static void mkwraps_cb();
static void make_cb();
static void make_clean_cb();
static void make_install_cb();
static Widget cre_cmdpanel();

static Widget buildCmd = 0;
static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];
static char crud[1024];

#if 0
static Widget makeButton;
#endif

/*********************
 *                   *
 *  widget creation  *
 *                   *
 *********************/

/*	start_build()
 *
 *	Start method for build mode.  Create any widgets and manage em.
 */

void
start_build()
{
	cre_cmdpanel(mainCmd);
	XtManageChild(buildCmd);
	set_togg(buildButton, 1);
}

/*	stop_build()
 *
 *	Stop method for build mode.
 *	Returns 0 if successfully stopped, else 1.
 */

int
stop_build()
{
#ifdef SUBPROX
	if (build_ChildPid != 0) {
		msg_Format ("Subprocess must complete before leaving build mode");
		return 1;
	}
#endif
	XtUnmanageChild(buildCmd);
	set_togg(buildButton, 0);
	return 0;
}

static Widget
cre_cmdpanel(below)
Widget below;
{
	Widget w;
#if 0
	Widget w2, w3;
#endif
	int n;

	if (buildCmd)
		return buildCmd;
	n = 0;
	XtSetArg(args[n], XtNfromVert, (XtArgVal)below); n++;
	XtSetArg(args[n], XtNborderWidth, (XtArgVal)0); n++;
	XtSetArg(args[n], XtNhorizDistance, (XtArgVal)0); n++;
	buildCmd = XtCreateWidget("buildCmd", formWidgetClass,
			mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNleft, XtChainLeft); n++;
	XtSetArg(args[n], XtNright, XtChainLeft); n++;
	XtSetArg(args[n], XtNtop, XtChainTop); n++;
	XtSetArg(args[n], XtNbottom, XtChainTop); n++;

#ifdef BUTTONZ
	w = cre_tog_but ("subdefs", buildCmd, args, n, (Widget)0, (Widget)0,
					 "edit subdefs", (char*)0, 0, 0, subdefs_cb, 0, 0);
	w = cre_tog_but ("mkwraps", buildCmd, args, n, (Widget)0, w,
					 "write wrappers", (char*)0, 0, 0, mkwraps_cb, 0, 0);
	w = cre_tog_but ("mkmf", buildCmd, args, n, (Widget)0, w,
					 "write makefile", (char*)0, 0, 0, mkmf_cb, 0, 0);	
	w = cre_tog_but ("mkclean", buildCmd, args, n, (Widget) 0, w,
					 "make clean", (char*)0, 0, 0, make_clean_cb, 0, 0);
	w = cre_tog_but ("make", buildCmd, args, n, (Widget) 0, w,
					 "make", (char*)0, 0, 0, make_cb, 0, 0);
	w = cre_tog_but ("mkinstall", buildCmd, args, n, (Widget) 0, w,
					 "make install", (char*)0, 0, 0, make_install_cb, 0, 0);
#else
	w = cre_cmd_but ("subdefs", buildCmd, args, n, (Widget)0, (Widget)0,
					 "edit subdefs", (char*)0, 0, 0, subdefs_cb, 0);
	w = cre_cmd_but ("mkwraps", buildCmd, args, n, (Widget)0, w,
					 "write wrappers", (char*)0, 0, 0, mkwraps_cb, 0);
	w = cre_cmd_but ("mkmf", buildCmd, args, n, (Widget)0, w,
					 "write makefile", (char*)0, 0, 0, mkmf_cb, 0);	
	w = cre_cmd_but ("mkclean", buildCmd, args, n, (Widget) 0, w,
					 "make clean", (char*)0, 0, 0, make_clean_cb, 0);
	w = cre_cmd_but ("make", buildCmd, args, n, (Widget) 0, w,
					 "make", (char*)0, 0, 0, make_cb, 0);
	w = cre_cmd_but ("mkinstall", buildCmd, args, n, (Widget) 0, w,
					 "make install", (char*)0, 0, 0, make_install_cb, 0);
#endif				 
	XtRealizeWidget(buildCmd);
	return buildCmd;
}

#ifdef SUBPROX

/*
 * This routine gets called whenever the child has output something.
 * We just stuff it into the message window.
 */

static void
build_ChildOutputSink (fd, name)
int fd;
char *name;
{
	char buf[5120];
	int nread;
	char *ptr1, *ptr2;

	if ((nread = read (fd, buf, sizeof buf - 1)) <= 0)
		return;
	buf[nread] = '\0';

	/*
	 * print out one line at a time, so we can print the child process
	 * name before the line of output.
	 */
	ptr1 = buf;
	while (ptr2 = index (ptr1, '\n')) {
		*ptr2 = '\0';
		msg_Format ("%s: %s\n", name, ptr1);
		ptr1 = ptr2 + 1;
	}
	if (ptr1 < buf + nread)
		msg_Format ("%s: %s\n", name, ptr1);
}

static Widget currentButton = NULL;

/*
 * This routine gets called when the child exits or is killed.
 */

static void
build_ChildDone (pid, exitArg, ptr, howDied)
int pid;
int exitArg;
char *ptr;
enum causeOfDeath howDied;
{
	if (howDied == SUBPROC_KILLED)
		msg_Format ("\"%s\" (pid %d) was killed with signal %d.\n",
					ptr, pid, exitArg & ~0200);
	else if (exitArg == 0)
		msg_Format ("\"%s\" completed.\n", ptr);
	else
		msg_Format ("\"%s\" exited abnormally with status %d.\n",
					ptr, exitArg);

	if (pid == build_ChildPid)	{ /* should always be the case */
#ifdef BUTTONZ
		if (currentButton)
			set_togg (currentButton, 0);
#endif	
		build_ChildPid = 0;
	}

	subproc_Pclose (pid);
}

/*
 * run a managed subprocess.
 *
 * Disable other buttons while process is running (currently done by setting
 * build_ChildPid to child's pid).
 *
 * If widget is a button, set the button appearance to "on" while the
 * process is running, and to "off" when it is finished.
 *
 * If the process outputs anything to stdout or stderr, put it in the message
 * window, prefixed by the process name.
 */

static void
build_RunChild (name, command, button)
char *name;
char *command;
Widget button;
{
#ifdef BUTTONZ
	currentButton = button;
#endif


#ifdef BUTTONZ
	if (build_ChildPid != 0) {
		if (currentButton) {
			set_togg (currentButton, 0);
			return;
		}
	}
#else
	if (build_ChildPid != 0)
		return;
#endif

	msg_Format ("running \"%s\"...\n", name);

	build_ChildPid = subproc_Popen (command, build_ChildDone, build_ChildDone,
									build_ChildOutputSink, name);
	if (build_ChildPid <= 0) {
		msg_Format ("couldn't run \"%s\"\n", name);
#ifdef BUTTONZ
		if (currentButton)
			set_togg (currentButton, 0);
#endif
		build_ChildPid = 0;
	}
}


/*	subdefs_cb()
 *
 *	Edit sub.defs file.
 */

static void
subdefs_cb(w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	(void)sprintf (crud, editorCommand, subDefsFile, subDefsFile,
				   subDefsFile);
	build_RunChild ("editor", crud, w);
}


/*
 * Hack for Sequents and other machines whose "make" program doesn't
 * inherit environment variables as make variables.  In particular,
 * it's often handy to use $(HOME) in Makefiles to find out the
 * location of the user's home directory (for installations, etc.)
 * We call this function to find out the proper value for the HOME
 * environment variable, which we pass to make on the command line.
 */

/*
 * hopefully everybody has getpwXXX() by now... It goes as far back
 * as at least V7, but isn't in the SVID book that I have. Did they
 * really leave this out of SysV prior to R4?
 */

#include <pwd.h>

static char *
getHome ()
{
	static char *home = NULL;
	struct passwd *pw;
	char *getenv ();

	if (home)
		;
	else if (home = getenv ("HOME"))
		;
	else if (pw = getpwuid (getuid ()))
		home = strsave (pw->pw_dir);
	else
		home = "/";

	return home;
}

static void
make_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	char *home = getHome ();

#ifdef ARCHSTR
	(void) sprintf (crud, "make ARCH=%s HOME=%s", ARCHSTR, home);
#else
	(void) sprintf (crud, "make HOME=%s", home);
#endif

	build_RunChild ("make", crud, w);
}


static void
make_clean_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	char *home = getHome ();

#ifdef ARCHSTR
	(void) sprintf (crud, "make clean ARCH=%s HOME=%s", ARCHSTR, home);
#else
	(void) sprintf (crud, "make clean HOME=%s", home);
#endif

	build_RunChild ("make clean", crud, w);
}

static void
make_install_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	char *home = getHome ();

#ifdef ARCHSTR
	(void) sprintf (crud, "make install ARCH=%s HOME=%s", ARCHSTR, home);
#else
	(void) sprintf (crud, "make install HOME=%s", home);
#endif

	build_RunChild ("make install", crud, w);
}

static void
mkwraps_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	char tmpSubDefsFile[1024];
	FILE *fp;

	if (scratchgraph == NULL || gr_Empty (scratchgraph)) {
		msg_Format ("Graph is empty");
		set_togg (w, 0);
		return;
	}
		
	subdefs_NukeDecls ();
	if (subdefs_CheckGraph (scratchgraph, subDefsFile) != 0) {
		msg_Format ("errors in graph - wrappers not made\n");
		set_togg (w, 0);
		return;
	}

	strcpy (tmpSubDefsFile, "/tmp/htoolXXXXXX");
	mktemp (tmpSubDefsFile);
	strcat (tmpSubDefsFile, ".s");
	if ((fp = fopen (tmpSubDefsFile, "w")) == NULL) {
		msg_Format ("can't create %s [%s]\n", tmpSubDefsFile, strerror(errno));
		set_togg (w, 0);
		return;
	}
	subdefs_WriteDecls (fp);
	fclose (fp);
	subdefs_NukeDecls ();

	sprintf (crud, "mkwrap %s %s",
			 Language == LANG_FORTRAN ? "-f" : "-c",
			 tmpSubDefsFile);

	build_RunChild ("mkwrap", crud, w);

	/* XXX need to remove tmp file when done */
}

#else /* SUBPROX */

/*	subdefs_cb()
 *
 *	Edit sub.defs file.
 */

static void
subdefs_cb(w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	/* XXX need to use a subprocess package instead of system () */
	(void)sprintf (crud, editorCommand, subDefsFile, subDefsFile, subDefsFile);

	system(crud);
}

static void
make_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	/*
	 * XXX need to use a subprocess package instead of popen ()
	 * Ideally, the stdout/stderr of the subprocess should be
	 * a pty, and it's difficult to do that portably.
	 */

	FILE *popen();
	FILE *fp;
	char *home = getHome ();

#ifdef ARCHSTR
	(void) sprintf (crud, "make ARCH=%s HOME=%s 2>&1", ARCHSTR, home);
#else
	(void) sprintf (crud, "make HOME=%s 2>&1", home);
#endif

	msg_Format ("running \"%s\"...\n", crud);
	if ((fp = popen (crud, "r")) == NULL)
		msg_Format ("Command \"%s\" failed\n", crud);
	else {
		while (fgets (crud, sizeof crud, fp) != NULL) {
			msg_Format ("%s", crud);
		}
		pclose (fp);
	}
	msg_Format ("make finished\n", crud);
}

static void
make_clean_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	FILE *popen();
	FILE *fp;

	/*
	 * XXX need to use a subprocess package instead of popen ()
	 * Ideally, the stdout/stderr of the subprocess should be
	 * a pty, and it's difficult to do that portably.
	 */

	msg_Format ("running \"make clean\"...\n");
	if ((fp = popen ("make clean 2>&1", "r")) == NULL)
		msg_Format ("Command \"make clean\" failed\n", crud);
	else {
		while (fgets (crud, sizeof crud, fp) != NULL) {
			msg_Format ("%s", crud);
		}
		pclose (fp);
	}
	msg_Format ("\"make clean\" finished\n");
}

static void
make_install_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	FILE *popen();
	FILE *fp;

	/*
	 * XXX need to use a subprocess package instead of popen ()
	 * Ideally, the stdout/stderr of the subprocess should be
	 * a pty, and it's difficult to do that portably.
	 */

	msg_Format ("running \"make install\"...\n");
	if ((fp = popen ("make install 2>&1", "r")) == NULL)
		msg_Format ("Command \"make install\" failed\n", crud);
	else {
		while (fgets (crud, sizeof crud, fp) != NULL) {
			msg_Format ("%s", crud);
		}
		pclose (fp);
	}
	msg_Format ("\"make install\" finished\n");
}

/*	mkwraps_cb()
 *
 *	Write wrappers for user node functions.
 */

static void
mkwraps_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	/*
	 * XXX this code needs to be integrated into htool itself.
	 */

	FILE *fp;
	int saw_output = 0;

	(void) sprintf (crud, "mkwrap %s %s 2>&1 || echo mkwrap failed",
					Language == LANG_FORTRAN ? "-f" : "-c",
					subDefsFile);
	if ((fp = popen (crud, "r")) == NULL) {
		msg_Format ("can't execute mkwrap command\n");
		return;
	}
	while (fgets (crud, sizeof crud, fp) != NULL) {
		saw_output = 1;
		msg_Format ("mkwrap: %s", crud);
	}
	pclose (fp);

	if (saw_output == 0) {
		if (Language == LANG_C)
			msg_Format ("C wrappers created from %s\n", subDefsFile);
		else
			msg_Format ("FORTRAN wrappers created from %s\n", subDefsFile);
	}
	else {
		msg_Format ("failed to create wrappers\n");
	}
}

#endif

/*	mkmf_cb()
*
*	Write makefile for user node functions.
*/

extern Tree xgr_GetSubNames();

static void
mkmf_cb(w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	Tree st;				/* symbol table for unique nodenames */
	TreeNode tn;
	FILE *ff;
	struct stat sb;
	int i;
	char buf[256];
	static char *libnames[] = {
		"$(HLIBDIR)/libslave.a",
		"$(HLIBDIR)/libhence.a",
		"$(HLIBDIR)/librb.a",
		"$(HLIBDIR)/libdl.a",
		"$(HLIBDIR)/liballoc.a",
		"$(PLIB)"
	};

	if (build_ChildPid != 0) {
		msg_Format ("Can't write Makefile while make is running.\n");
		goto done;
	}
	if (scratchgraph == (Graph) NULL) {
		msg_Format ("Build error: Empty HeNCE graph.\n");
		goto done;
	}
	st = xgr_GetSubNames(scratchgraph);
	if (rb_First(st) == (TreeNode) st) {
		msg_Format ("Build error: Empty HeNCE graph.\n");
		goto done;
	}

	if ((i = stat(MAKEFILENAME, &sb)) == -1) {
		if (errno != ENOENT) {
			(void)sprintf(crud, "Can't write \"%s\".", MAKEFILENAME);
			message(crud);
			goto done;
		}
	} else {
		sprintf(buf, "%s exists.  overwrite?", MAKEFILENAME);
		if (verify(buf)) {
			message("cancelled.");
			goto done;
		}
	}
	if (!(ff = fopen(MAKEFILENAME, "w"))) {
		(void)sprintf(crud, "Can't write \"%s\".", MAKEFILENAME);
		message(crud);
		goto done;
	}

#define FP fprintf
#ifdef ARCHSTR
	FP (ff, "# This variable needs to be set according to the architecture\n");
	FP (ff, "# of the machine you are compiling on.  It is set by default\n");
	FP (ff, "# to the architecture of the machine that generated the\n");
	FP (ff, "# Makefile.  To compile a node program on another machine,\n");
	FP (ff, "# either type \"make ARCH=something-else\"\n");
	FP (ff, "# or just edit this Makefile to change the value below\n");
	FP (ff, "ARCH\t=\t%s\n", ARCHSTR);
	FP (ff, "\n");
#else
	FP (ff, "# You need to change the value of ARCH to reflect the\n");
	FP (ff, "# architecture name for your machine.\n");
	FP (ff, "#ARCH\t=\t%s\n", "unknown");
	FP (ff, "\n");
#endif
	FP (ff, "# The following defines are set from these X resources:\n");
	FP (ff, "# HLIBDIR\thtool.henceLibDir\n");
	FP (ff, "# PLIB\thtool.pvmLib\n");
	FP (ff, "# XDIR\thtool.binDir\n");
	FP (ff, "# INCLUDES\thtool.includeDir\n");
	FP (ff, "HLIBDIR\t=\t%s\n", henceLibDir);
	FP (ff, "PLIB\t=\t%s\n", pvmLib);
	FP (ff, "XDIR\t=\t%s\n", binDir);
	FP (ff, "INCLUDES=\t-I%s\n", includeDir);
	FP (ff, "\n");
	FP (ff, "# work around brain-damage in some versions of make\n");
	FP (ff, "SHELL\t=\t/bin/sh\n");
	FP (ff, "\n");

#define SIZE(x) (sizeof (x) / sizeof (*x))
	FP (ff, "HLIBS\t=\t%s \\\n", libnames[0]);
	for (i = 1; i < SIZE(libnames); ++i)
		FP (ff, "\t\t%s %s\n",
			libnames[i],
			i == SIZE(libnames) - 1 ? "" : "\\");
#undef SIZE

	if (Language == LANG_FORTRAN) {
		FP (ff, "# extra glue for FORTRAN\n");
		FP (ff, "FMAIN\t=\tfmain.o\n");
		FP (ff, "\n");
	}

    FP (ff, "\n");
	FP (ff, "# These are commented out because the correct definitions\n");
	FP (ff, "# vary from one system to another.\n");
	FP (ff, "# Uncomment and redefine as necessary.\n");
	FP (ff, "#CC\t=\tcc\n");
	FP (ff, "#FC\t=\tf77\n");
	FP (ff, "#\n");
	FP (ff, "# CFLAGS is used here to allow us to add the -DIMA_$(ARCH)\n");
	FP (ff, "# option to the default compile rule for C programs.\n");
	FP (ff, "# If you need to add -g or -O or whatever, put them in\n");
	FP (ff, "# CDEBUGFLAGS or just type \"make CDEBUGFLAGS=whatever\"\n");
	FP (ff, "#\n");
	FP (ff, "#CDEBUGFLAGS=-g\n");
	FP (ff, "CFLAGS\t=\t-DIMA_$(ARCH) $(CDEBUGFLAGS)\n");
    FP (ff, "\n");
	FP (ff, "all:");
	for (tn = rb_First(st); tn != st; tn = rb_Next(tn))
		if (strcmp (st_Key(tn), "null") != 0)
			fprintf(ff, " %s", st_Key(tn));
    FP (ff, "\n");
    FP (ff, "\n");

	FP (ff, "install: all\n");
	FP (ff, "\t@- if [ ! -d $(XDIR) ] ; then \\\n");
	FP (ff, "\t\techo creating dir $(XDIR) ; \\\n");
	FP (ff, "\t\tmkdir $(XDIR) ; \\\n");
	FP (ff, "\tfi ; \\\n");
	FP (ff, "\texit 0\n");
	FP (ff, "\tmv");
	for (tn = rb_First(st); tn != st; tn = rb_Next(tn))
		if (strcmp (st_Key(tn), "null") != 0)
			fprintf(ff, " %s", st_Key(tn));
	FP (ff, " $(XDIR)\n");
	FP (ff, "\n");

	FP (ff, "clean:\n");
	FP (ff, "\trm -f");
	for (tn = rb_First(st); tn != st; tn = rb_Next(tn))
		if (strcmp (st_Key(tn), "null") != 0)
			fprintf(ff, " %s", st_Key(tn));
	FP (ff, " *.o\n");
	FP (ff, "\n");

	if (Language == LANG_FORTRAN) {
		for (tn = rb_First(st); tn != st; tn = rb_Next(tn)) {
			if (strcmp (st_Key(tn), "null") == 0)
				continue;
			FP (ff, "%s:	%s.o w_%s.o $(FMAIN) $(HLIBS)\n",
				st_Key (tn), st_Key (tn), st_Key (tn));
			FP (ff,
				"\t$(FC) $(FFLAGS) -o %s %s.o w_%s.o $(HLIBS) $(FMAIN)\n\n",
				st_Key (tn), st_Key (tn), st_Key (tn));
			FP (ff, "w_%s.o:\tfw_%s.c\n", st_Key (tn), st_Key (tn));
			FP (ff, "\t$(CC) $(CFLAGS) $(INCLUDES)  -c fw_%s.c\n",
				st_Key (tn));
			FP (ff, "\tmv fw_%s.o w_%s.o\n", st_Key (tn), st_Key (tn));
			FP (ff, "\n");
			FP (ff, "fmain.o: fmain.f\n");
		}
	}
	else if (Language == LANG_C) {
		for (tn = rb_First(st); tn != st; tn = rb_Next(tn)) {
			if (strcmp (st_Key(tn), "null") == 0)
				continue;
			FP (ff, "%s:	%s.o w_%s.o $(HLIBS)\n",
				st_Key (tn), st_Key (tn), st_Key (tn));
			FP (ff,
				"\t$(CC) $(CFLAGS) -o %s %s.o w_%s.o $(HLIBS)\n\n",
				st_Key (tn), st_Key (tn), st_Key (tn));
			FP (ff, "w_%s.o:\tcw_%s.c\n", st_Key (tn), st_Key (tn));
			FP (ff, "\t$(CC) $(CFLAGS) $(INCLUDES)  -c cw_%s.c\n",
				st_Key (tn));
			FP (ff, "\tmv cw_%s.o w_%s.o\n", st_Key (tn), st_Key (tn));
			FP (ff, "\n");
		}
	}

	fclose(ff);
#undef FP

	(void)sprintf(crud, "wrote \"%s\".", MAKEFILENAME);
	message(crud);
	st_Free(st);

 done:
#ifdef BUTTONZ
	set_togg (w, 0);
#endif
	return;
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
