/*
 * $Source: /wayward/homes/moore/src/hence2/master/RCS/param.c,v $
 * $Revision: 1.2 $
 * $Date: 1994/06/11 21:04:37 $
 * $Author: moore $
 */

/*
 */

#include <stdio.h>
#include "std.h"
#include "dlist.h"
#include "rb.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

#define isadim(e) (e->elt_type == '[' || e->elt_type == ']' \
                                      || e->elt_type == '.')


static check_param_consistency ();
static param_cons_error ();
static two_init_vals_error ();
static twice_declared_error ();
static twice_io_declared_error ();
static error_conf_types ();
static error_bad_typed_dtype ();
static error_conf_dims ();
static error_main_output ();
static error_main_output2 ();

/* One has to be careful here not to be susceptable to infinite loops, with
 * exp_comp and param_comp recursively calling one another.
 */
 
int param_comp(p1, p2)
Param p1, p2;
{
  int cmp, i;

  if (p1 == p2) return 0;
  if (p1 == PNULL) return -1;
  if (p2 == PNULL) return  1;
  cmp = strcmp(p1->name, p2->name);
  if (cmp != 0) return cmp;
  if (p1->type != ARRAY && p2->type != ARRAY) {
    if (p1->type == p2->type || p1->type == -1 || p2->type == -1) return 0;
    error_conf_types(p1, p2, NNULL);
  }
  if (p1->type == -1) {
    if (p2->io.main) return 0; else return -1;
  } 
  if (p2->type == -1) {
    if (p1->io.main) return 0; else return  1;
  }
  if (p1->type != p2->type) error_conf_types(p1, p2, NNULL);

  if (p1->a->ndims != p2->a->ndims) error_conf_dims(p1, p2, NNULL);
  for (i = 0; i < p1->a->ndims; i++) {
    cmp = exp_comp(p1->a->dims[i], p2->a->dims[i]);
    if (cmp != 0) return cmp;
  }
  return 0;
}
   
free_param(p)
Param p;
{
  int i;
  Parray a;
  Rb_node r;

  if (p == PNULL) return;
  free(p->name);
  if (p->type == ARRAY) {
    a = p->a;
    for (i = 0; i < a->ndims; i++) {
      free_exp(a->dims[i]);
    } 
    free(a->dims);
    rb_traverse(r, a->p) {
      free_param((Param) r->v.val);
    }
    rb_free_tree(a->p);
    free(a);
  }  
  free(p);
}

Parray new_parray(type, ndims)
int ndims, type;
{
  Parray a;
  int i;

  a = talloc(struct param_array, 1);
  a->p = make_rb();
  a->ndims = ndims;
  a->nadims = ndims;
  a->type = type;
  a->dims = talloc(Exp, ndims);
  a->n_level2 = 0;
  a->main = PNULL;
  for (i = 0; i < ndims; i++) a->dims[i] = ENULL;
  return a;
}
  
Param brand_new_param(name)
char *name;
{
  Param p;
  p = talloc(param, 1);
  clear_param(p);
  p->name = copy_string(name);
  return p;
}

clear_param(p)
Param p;
{
  p->io.in = 0;
  p->io.out = 0;
  p->io.inj = 0;
  p->io.new = 0;
  p->io.main = 0;
  p->io.used = 0;
  p->val = ENULL;
  p->mirror = p;
  p->state = 0;
  p->type = -1;
}

Param new_param(n)
Node n;
{

  Param p, rp;
  Exp e, t, dval;
  Rb_node r;
  Dlist dims, d;
  int i, tp, ndims;
  int fnd;

  /* Get any dimensions, and the parameter's name */

  ndims = 0;

  for (e = last_exp(); e->elt_type != 'p'; e = last_exp()) {
    if (isadim(e)) {
      if (ndims == 0) dims = make_dl();
      dl_insert_a_exp(dims, e);
      ndims++;
    } else bail("INTERNAL ERROR in new_param: !isadim(e)\n");
  }

  /* Make the new paramter */

  p = brand_new_param(e->val.s);

  /* Get the parameter's type */

  t = last_exp_peek();
  if (t != ENULL && t->elt_type == 'T') {
    t = last_exp();
    tp = t->type;
    free_exp(t);
  } else tp = -1;

  /* Set the type (if there is one), and the array information */

  if (ndims == 0) {
    p->type = tp;
  } else {
    p->type = ARRAY;
    p->a = new_parray(tp, ndims);
    i = 0;
    dl_traverse(d, dims) {
      dval = (Exp) d->val;
      if (!isadim(dval)) bail("ERROR: new_param: !isadim(dval)\n");

      if (tp == -1) {
        p->a->dims[i] = dval;
        if (dval->elt_type == ']') p->a->nadims--;
      } else {

        /* If the array is typed, change a[n][c] to a[0..n-1][0..c-1].
           a[] is only legal if it is initialized, but let it go here. */

        if (dval->elt_type == '.') error_bad_typed_dtype(p, dval, i);
        else if (dval->elt_type == ']') {
          push_exp('c', "0", INT);
          if (dval->args[0]->elt_type == 'c') {
            convert_exp_type(dval->args[0], INT);
            dval->args[0]->val.i -= 1;
            push_expression(dval->args[0]);
          } else {
            push_expression(dval->args[0]);
            push_int(1);
            push_exp('-', CNULL, -1);
          }
          push_exp('.', CNULL, -1);
          p->a->dims[i] = last_exp();
          dval->nargs = 0;
          free_exp(dval);
        } else p->a->dims[i] = dval; 
      }
      i++;
    }
    dl_delete_list(dims);
  }
  free_exp(e);
  
/* Look for the parameter in the main parameter rb-tree.  If it's not there, 
 * then enter it.  If it is and it's a scalar, coelesce it and the new one.
 * For array parameters, go the extra level. */

  r = rb_find_key_n(n->params, p->name, &fnd);

  if (p->type != ARRAY) {
    if (fnd) {
      rp = (Param) r->v.val;
      if (rp->type != p->type) {
        if (rp->type == -1) rp->type = p->type;
        else if (p->type != -1) error_conf_types(rp, p, n);
      }
      rp->io.used = 1;
      free_param(p);
      return rp;
    } else {
      p->io.used = 1;
      n->nparams++;
      (void) rb_insert_b_p1(r, p);
      return p;
    }

  } else {
    n->arrays = 1;
    if (fnd) {
      rp = (Param) r->v.val;
      if (rp->type == -1) {
        rp->type = ARRAY;
        rp->io.main = 1;
        rp->a = new_parray(-1, ndims);
        rp->a->main = rp;
      } else if (rp->type != ARRAY) {
        error_conf_types(rp, p, n);
      } else {
        if (rp->a->ndims != ndims) error_conf_dims(rp, p, n);
      }
    } else {
      rp = brand_new_param(p->name);
      rp->type = ARRAY;
      rp->io.main = 1;
      rp->a = new_parray(-1, ndims);
      rp->a->main = rp;
      n->nparams++;
      (void) rb_insert_b_p1(r, rp);
    }

    /* Extra level */

    /* If the parameter is typed, set it to be the level 1 parameter */

    if (tp != -1) {
      Exp *etmp;
      if (rp->a->type != -1) twice_declared_error(rp, p, n);
      set_array_type(rp, tp);
      etmp = rp->a->dims;  /* Swap p's dims w/ rp's and free p */
      rp->a->dims = p->a->dims;  
      p->a->dims = etmp;
      rp->io.used = 1;
      free_param(p);
      return rp;
    }
      
    /* Otherwise, look for it in rp's p-list, then put it in if not there */

    r = rb_find_gkey_n(rp->a->p, p, param_comp, &fnd);
 
    if (fnd) {
      free_param(p);
      return (Param) r->v.val;
    } else {
      n->nparams++;
      (void) rb_insert_b_p2(r, p);
      p->a->type = rp->a->type;
      p->io.used = 1;
      p->a->main = rp;
      rp->a->n_level2++;
      if (!rp->io.in && rp->io.out) {
        error_main_output(rp, n);
      }
      return p;
    }
  }
}

/* Set_param_specs sets the io and val fields of a parameter.  
 * If Init = 1, then the val field is in the first last_exp().
 * The parameter is in the expression in the next last_exp().
 * It will set p->io to be the correct combination of io and the
 * current p->io.  It also sets p->val to be the initial expression.
 * If new = 1, then it will set p->io.new to be 1.
 */

set_param_specs(io, init, new)
int io, init, new;
{
  Exp ep, in;
  Param p;

  if (init) in = last_exp(); else in = ENULL;
  ep = last_exp();

  if (ep->elt_type != 'P') 
    bail("INTERNAL set_param_specs error: ep->elt_type != 'P'\n");

  p = ep->val.p;

  if (new || io == '>') p->io.new = 1;

  if (io != '<' && io != '>' && io != 'B') 
    bail("INTERNAL set_param_specs error: Bad io param\n");

  if (p->io.in || p->io.out) twice_io_declared_error(p, io, NNULL);

  p->io.in = (io != '>');
  p->io.out = (io != '<');

  if (p->type == ARRAY && p->io.main && !p->io.in && p->io.out &&
      p->a->n_level2 > 0) {
    error_main_output2(p);
  }

  if (init) {
    if (p->val == ENULL) {
      p->val = in;
    } else {
      two_init_vals_error(p, in);
    }
  }
  free_exp(ep);
}

inject_param(n, p, v)
Node n;
Param p;
int v;
{
  Param np;
  
  push_exp('p', p->name, -1);
  np = new_param(n);
  if (np->type == -1) np->type = INT;
  np->io.inj = 1;
  np->inj = v;

/*   printf("Injected val of %d in ", v); */
/*   print_param(np); */
/*   printf(" to node %d/%d\n", n->id, n->inst); */
}

number_parameters(n)
Node n;
{
  int i;
  Rb_node r, ra;
  Param p, pa;

  i = 0;
  rb_traverse(r, n->params) {
    p = (Param) r->v.val;
    p->num = i;
    i++;
    if (p->type == ARRAY) {
      rb_traverse(ra, p->a->p) {
        pa = (Param) ra->v.val;
        pa->num = i;
        i++;
      }
    }
  }
  if (i != n->nparams) bail("INT ERROR: number_parameters: i != n->nparams\n");
}

Param copy_param(p)
Param p;
{
  Param newp;

  if (p == PNULL) return PNULL;
  newp = talloc(param, 1);
  newp->name = copy_string(p->name);
  newp->type = p->type;
  newp->io = p->io;
  newp->inj = p->inj;
  newp->val = ENULL;
  newp->state = p->state;
  if (newp->type == ARRAY) {
    newp->a = new_parray(p->a->type, p->a->ndims);
  }
  newp->mirror = newp;
  p->mirror = newp;
  return newp;
}
  

copy_params(n2, n1)  /* Copies the parameters of node 1 to node 2.  It  */
Node n2;             /* assumes that n2->param hasn't been touched yet. */
Node n1;
{
  Param p1, p2, pa1, pa2, lastpa2;
  Rb_node r, ra;
  int i;

  n2->nparams = n1->nparams;
  n2->params = make_rb();
  
  /* First copy the parameters with no expressions (i.e. no initvals
     and no dimension expressions.   This is to set up the mirror fields
     on all parameters in n1. */

  rb_traverse(r, n1->params) {
    p1 = (Param) r->v.val;
    p2 = copy_param(p1);
    (void) rb_insert_b_p1(n2->params, p2);
    if (p2->type == ARRAY) {
      rb_traverse(ra, p1->a->p) {
        pa1 = (Param) ra->v.val;
        pa2 = copy_param((Param) ra->v.val);
        (void) rb_insert_b_p2(p2->a->p, pa2);
      }
    }
  }

  /* Now copy the initvals, dimensions, and ->a->main fields */

  rb_traverse(r, n1->params) {
    p1 = (Param) r->v.val;
    p2 = p1->mirror;
    if (p1->val != ENULL) p2->val = copy_exp(p1->val, 1);
    if (p1->type == ARRAY) {
      for (i = 0; i < p1->a->ndims; i++)
        p2->a->dims[i] = copy_exp(p1->a->dims[i], 1);
      p2->a->main = p2;
      p2->a->nadims = p1->a->nadims;
      p2->a->n_level2 = p1->a->n_level2;
      lastpa2 = PNULL;
      rb_traverse(ra, p1->a->p) {
        pa1 = (Param) ra->v.val;
        pa2 = pa1->mirror;
        pa2->a->nadims = pa1->a->nadims;
        pa2->a->main = p2;
        for (i = 0; i < pa1->a->ndims; i++)
          pa2->a->dims[i] = copy_exp(pa1->a->dims[i], 1);
        /* Error check -- just make sure the rb_tree is in order.  It might
           be ok if it isn't, but just make sure. */
        if (lastpa2 != PNULL) {
          if (param_comp(pa2, lastpa2) != 1) {
            bail_copy_params_not_in_order(n1, n2, pa2, lastpa2);
          }
        }
        lastpa2 = pa2;
      }
    }
  }
}


    
   
check_node_params(n)
Node n;
{
  Param p;
  Rb_node r1, r2;

  rb_traverse(r1, n->params) {
    p = (Param) r1->v.val;
    check_param_consistency(p, n);
    if (p->type == ARRAY) {
      rb_traverse(r2, p->a->p) {
        check_param_consistency( (Param) r2->v.val, n);
      }
    }
  }
}
    
/* Checks the consistency of a parameter and it's initval */

static check_param_consistency(p, n)
Param p;
Node n;
{
  if (p->val == ENULL) return;
  if (p->type == -1)
    bail("INTERNAL ERROR: check_param_consistency type = -1\n");

  if (p->type == ARRAY && p->a->nadims != 0) {
    if (p->val->elt_type == 'c') {
      if (p->val->type != ARRAY) 
        param_cons_error(p, n, "Cannot set array parameter to a scalar value");
      if (p->val->val.a->ndims != p->a->nadims &&
          p->val->val.a->ndims != 1 && p->a->nadims != 1) 
        param_cons_error(p, n, 
                         "Value and parameter have differing dimensions");
    } else if (p->val->elt_type == 'P') {
      if (p->val->val.p->type != -1) {
        if (p->val->val.p->type != ARRAY || p->val->val.p->a->nadims == 0) 
          param_cons_error(p, n, 
                           "Can't set array parameter to scalar parameter");
        if (p->val->val.p->a->nadims != p->a->nadims &&
            p->val->val.p->a->nadims != 1 && p->a->nadims != 1) 
          param_cons_error(p, n, 
                           "Value and parameter have differing dimensions");
      }
    } else {
      param_cons_error(p, n, 
                       "Can't set array parameter to a scalar expression");
    }
  } else if (p->val->elt_type == 'c' && p->val->type == ARRAY ||
             p->val->elt_type == 'P' && p->val->val.p->type == ARRAY
             && p->val->val.p->a->nadims != 0) {
    param_cons_error(p, n, "Cannot set scalar parameter to an array");
  }
}

set_array_type(p, t)
Param p;
int t;
{
  Rb_node r;
  Param p2;

  p->a->type = t;
  rb_traverse(r, p->a->p) {
    p2 = (Param) r->v.val;
    p2->a->type = t;
  }
}
 
static param_cons_error(p, n, s)
Param p;
Node n;
char *s;
{
  param_error_header(n, p);
  fprintf(stderr, "  Parameter can't be properly initialized:\n  %s\n", s);
  nice_bail(CNULL);
}
  
static two_init_vals_error(p, in)
Param p;
Exp in;
{
  fprintf(stderr, 
          "ERROR: Parameter %s has two initial values:\n  ", p->name);
  fprint_exp(stderr, p->val);
  fprintf(stderr, "\n  ");
  fprint_exp(stderr, in);
  fprintf(stderr, "\n");
  nice_bail(CNULL);
}

static twice_declared_error(p1, p2, n)
Param p1;
Param p2;
Node n;
{
  fprintf(stderr, "ERROR: ");
  fprint_node_id(stderr, n);
  fprintf(stderr, "Parameter %s declared twice:\n     ", p1->name);
  fprint_param(stderr, p1);
  fprintf(stderr, "\n  and ");
  fprint_param(stderr, p2);
  fprintf(stderr, "\n");
  nice_bail(CNULL);
}

static twice_io_declared_error(p, io, n)
Param p;
int io;
Node n;
{
  fprintf(stderr, "ERROR: ");
  fprint_node_id(stderr, n);
  fprintf(stderr, "Parameter %s declared twice:\n     ", p->name);
  fprintf(stderr, "As ");
  if (p->io.in) fprintf(stderr, "<");
  if (p->io.out) fprintf(stderr, ">");
  fprintf(stderr, " and as ");
  if (io != '>') fprintf(stderr, "<");;
  if (io != '<') fprintf(stderr, ">");;
  nice_bail("\n");
}

static error_conf_types(p1, p2, n)
Param p1, p2;
Node n;
{
  fprintf(stderr, "ERROR: ");
  fprint_node_id(stderr, n);
  fprintf(stderr, "Conflicting declarations of parameter %s:\n  ", p2->name);
  fprint_param(stderr, p1);
  fprintf(stderr, "\n  ");
  fprint_param(stderr, p2);
  fprintf(stderr, "\n");
  nice_bail(CNULL);
}

static error_bad_typed_dtype(p, dval, i)
Param p;
Exp dval;
{
  fprintf(stderr, "ERROR in declaration of parameter %s, dimension %d:\n", 
          p->name, i+1);
  fprintf(stderr, "  Definition = ");
  fprint_exp(stderr, dval);
  fprintf(stderr, "\n  Typed arrays cannot be defined by [ .. ]\n");
  nice_bail(CNULL);
}

static error_conf_dims(p1, p2, n)
Param p1;
Param p2;
Node n;
{
  fprintf(stderr, "ERROR: ");
  fprint_node_id(stderr, n);
  fprintf(stderr, 
    "Parameter %s declared twice with conflicting dimensions\n  ", p2->name);
  fprint_param(stderr, p1);
  fprintf(stderr, "\n  ");
  fprint_param(stderr, p2);
  fprintf(stderr, "\n");
  nice_bail(CNULL);
}

param_error_header(n, p)
Node n;
Param p;
{
  fprintf(stderr, "ERROR: ");
  fprint_node_id(stderr, n);
  fprintf(stderr, "Parameter: ");
  fprint_param(stderr, p);
  fprintf(stderr, "\n");
}

bail_copy_params_not_in_order(n1, n2, pa2, lastpa2)
Node n1, n2;
Param pa2, lastpa2;
{
  fprintf(stderr, "INTERNAL ERROR Copying node %d/%d to %d/%d\n",
          n1->id, n1->inst, n2->id, n2->inst);
  fprintf(stderr, "  2nd level parameters:\n    ");
  fprint_param(stderr, lastpa2);
  fprintf(stderr, "  and\n    ");
  fprint_param(stderr, pa2);
  fprintf(stderr, "\n  are sequential in the rb_tree, but param_comp = %d\n",
          param_comp(lastpa2, pa2));
  bail(CNULL);
}

static error_main_output(main, n)
Param main;
Node n;
{
  fprint_node_id(stderr, n);
  error_main_output2(main);
}
  
static error_main_output2(main)
Param main;
{
  Rb_node r;
  Param p;
  fprintf(stderr, "ERROR: ");
  fprintf(stderr, "Entire array paramter declared as output-only:\n  ");
  fprint_param(stderr, main);
  fprintf(stderr, "\nHowever, parts of %s have been declared otherwise:",
    main->name);
  rb_traverse(r, main->a->p) {
    p = (Param) r->v.val;
    fprintf(stderr, "\n  ");
    fprint_param(stderr, p);
  }
  nice_bail("\n");
}
