/*
 * $Source: /wayward/homes/moore/src/hence2/master/RCS/manip.c,v $
 * $Revision: 1.2 $
 * $Date: 1994/06/11 21:02:45 $
 * $Author: moore $
 */

#include <stdio.h>
#include "std.h"
#include "dlist.h"
#include "rb.h"
#include "hence.h"
#include "htypes.h"
#include "rbhelp.h"

/*----------------------------------------------------------------------*/
/* Copy_subgraph copies a subgraph, and returns the head and tail 
 * nodes of that new subgraph in dlists.  It is given a special node
 * n, and a dlist of nodes, which are children of n.  It traverses 
 * all the nodes reachable from those in to_copy, which are contained
 * by n and its pair, and copies them.  When a copy is made, the node's
 * ->mirror field is set to its copy.  Next, these nodes are traversed
 * once more, and the ->mirror nodes are connected in the same way as the
 * original nodes.  Thus, the subgraph is copied.  The heads list is 
 * initialized to be new nodes who don't have parents, and the tails 
 * list is initialized to be new nodes who don't have children.  If 
 * attach is 1, then the nodes in the heads list are attached to n, and
 * those in the tails list are attached to n->pair. */

copy_subgraph(n, to_copy, heads, tails, attach)
Node n;
Dlist to_copy, heads, tails;
int attach;
{
  Dlist stack;  /* A stack for doing depth-first traversal */
  Dlist all;    /* A list of all the nodes in the subgraph */
  Dlist tmp;
  Node nd, m, p, mp, c, npair;
  Rb_node r;

  /* Initialize */

  stack = make_dl();
  all = make_dl();
  npair = n->pair;

  n->mirror = n;
  npair->mirror = npair;
  npair->flags = 1;

  /* Put the nodes in to_copy onto the stack */

  dl_traverse(tmp, to_copy) {
    c = (Node) tmp->val;
    c->flags = 1;
    dl_insert_b_nd(stack, c);
  }

  /* Until the stack is empty, pop off a node, copy it, put it into all, and
   * put its children on the stack.  The flags field is stop at npair, 
   * and to keep nodes from being put on the stack twice. */

  while(!dl_empty(stack)) {
    tmp = first(stack);
    nd = (Node) tmp->val;
    dl_delete_node(tmp);
    (void) copy_node(nd);
    dl_insert_b_nd(all, nd);
    rb_traverse(r, nd->children) {
      c = (Node) r->v.val;
      if (c->flags == 0) {
        c->flags = 1;
        dl_insert_b_nd(stack, c);
      }
    }
  }

  dl_delete_list(stack);
  npair->flags = 0;

  /* Traverse the nodes, and attach arcs to their copies according to 
   * their parents.  Also initialize the head and tail lists. */

  dl_traverse(tmp, all) {
    nd = (Node) tmp->val;
    m = nd->mirror;
    nd->flags = 0;
    m->flags = 0;
    m->scope = nd->scope->mirror;
    if (nd->pair == NNULL) m->pair = NNULL; else m->pair = nd->pair->mirror;
    rb_traverse(r, nd->parents) {
      p = (Node) r->v.val;
      if (p == n) {
        dl_insert_b_nd(heads, m);
        if (attach) new_arc(n, m, 0);
      } else {
        mp = p->mirror;
        new_arc(mp, m, 0);
      }
    }
    rb_traverse(r, nd->children) {
      c = (Node) r->v.val;
      if (c == npair) {
        dl_insert_b_nd(tails, m);
        if (attach) new_arc(m, npair, 0);
      }
    }
  }

  dl_delete_list(all);
  return;
}

/*----------------------------------------------------------------------*/
/* Connect_pipe_arcs() works much like copy_subgraph, only here it 
 * creates arcs from nodes to their mirror copies, thereby effecting 
 * a pipe.  In the case of a special-purpose node, an arc is made from
 * the ending-pair node to the mirror of the beginning-pair node.  Subgraph
 * nodes of the special-purpose nodes are ignored.  The flow of control is
 * exactly as in conpy_subgraph().
 */
 
connect_pipe_arcs(n, heads)
Node n;
Dlist heads;
{
  
  Dlist stack;
  Dlist all;
  Dlist tmp;
  Node nd, pipechild, npair, c;
  Rb_node r;

  stack = make_dl();
  all = make_dl();

  npair = n->pair;
  npair->flags = 1;

  dl_traverse(tmp, heads) {
    c = (Node) tmp->val;
    c->flags = 1;
    dl_insert_b_nd(stack, c);
  }

  dl_traverse(tmp, stack) {
    nd = (Node) tmp->val;
    dl_insert_b_nd(all, nd);
    if (nd->node_type != NORMAL) nd = nd->pair;
    rb_traverse(r, nd->children) {
      c = (Node) r->v.val;
      if (c->flags == 0) {
        c->flags = 1;
        dl_insert_b_nd(stack, c);
      }
    }
  }

  dl_delete_list(stack);
  npair->flags = 0;

  dl_traverse(tmp, all) {
    nd = (Node) tmp->val;
    nd->flags = 0;
    pipechild = nd->mirror;
    if (nd->node_type != NORMAL) nd = nd->pair;
    new_arc(nd, pipechild, 0);
  }
  dl_delete_list(all);
}

remove_node_pair(n, G)
Node n;
Graph G;
{
  Rb_node rc;
  Node c;

  remove_special_node(n, 1);
  remove_special_node(n->pair, 0);
  rb_traverse(rc, n->children) {
    c = (Node) rc->v.val;
    update_anc_list(c->anc, n);
    if (c->state == 0) make_ready(c, G);
  }
  free_anc_list(n->anc);
}
    
remove_special_node(n, beg)
Node n;
int beg;
{
  Rb_node rp, rc;
  Node p, c;

  rb_traverse(rc, n->children) {
    c = (Node) rc->v.val;
    rb_traverse(rp, n->parents) new_arc((Node) rp->v.val, c, beg);
    rp = rb_find_ndkey(c->parents, n);
    rb_delete_node(rp);
    c->nparents--;
    c->state++;
  }
  rb_traverse(rp, n->parents) {
    p = (Node) rp->v.val;
    rc = rb_find_ndkey(p->children, n);
    rb_delete_node(rc);
    p->nchildren--;
  }
}
