/*
 * $Source: /chalk/homes/moore/src/hence2/master/RCS/grparse.y,v $
 * $Revision: 1.2 $
 * $Date: 1992/06/24 22:14:14 $
 * $Author: moore $
 * $Log: grparse.y,v $
 * Revision 1.2  1992/06/24  22:14:14  moore
 * 1. increase yacc stack depth to allow long arg lists.
 * 2. make yyerror() print out the error msg passed by caller.
 *
 */

%{
#define YYMAXDEPTH 300		/* to allow long argument lists */
#include <sys/types.h>
#include <stdio.h>
#include "std.h"
#include "rb.h"
#include "dlist.h"
#include "hence.h"
#include "htypes.h"

char yy_last_id[500];
int yy_last_int;
int yy_prev_int;
float yy_last_float;
char yy_last_io;
int yy_last_type;
char *yy_last_str;

double atof();

extern Node Nd;
%}

%start program

/* identifiers and constants */
%token  TK_int TK_float TK_id TK_type
%token  TK_NODE TK_ARC TK_string TK_IO
%token  TK_LS TK_RS TK_AND TK_OR TK_LE TK_GE TK_NE TK_EQ TK_DDOTS
%token  TK_END_COND TK_COND TK_END_LOOP TK_LOOP TK_END_PIPE TK_PIPE 
%token	TK_FANOUT TK_FANIN TK_TO TK_NEW TK_PROGRAM

%%

program: TK_PROGRAM decl_list
       ;

decl_list: decl
	 | decl_list decl
	 ;

decl:	 node_decl
         { node_done(); }
       | arc_decl
       ;

arc_decl: TK_ARC from_list to_list 
          { arc_done(); }
        ;

from_list: from_elt
         | from_elt ',' from_list
         ;

from_elt: TK_int
          { arc_elt(yy_last_int, 'f'); }
        ;
        
to_list: to_elt
       | to_elt ',' to_list
       ;

to_elt: TK_int
        { arc_elt(yy_last_int, 't'); }
      ;
        
node_decl: normal_node loc_n_id node_program
	 | end_node loc_n_id ';'
         | cond_node loc_n_id '(' expression ')' ';'
         | other_node loc_n_id var '=' expression TK_TO expression ';' 
         | loop_node loc_n_id loop_exp ';'

normal_node: TK_NODE
             { new_node(NORMAL); }
           ;

end_node: TK_END_COND
          { new_node(END_COND); }
        | TK_END_LOOP
          { new_node(END_LOOP); }
        | TK_END_PIPE
          { new_node(END_PIPE); }
        | TK_FANIN
          { new_node(FANIN); }
        ;
            
cond_node: TK_COND
           { new_node(COND); }
         ;

other_node: TK_FANOUT
            { new_node(FANOUT); }
          | TK_PIPE
            { new_node(PIPE); }
          ;
  
loop_node: TK_LOOP
           { new_node(LOOP); }
         ;

loop_exp: '(' loop_set_var ';' expression ';' loop_set_var ')'
        | '(' loop_set_var ';' expression ';' loop_no_set_var ')'
        | '(' loop_no_set_var ';' expression ';' loop_no_set_var ')'

loop_set_var: var '=' expression 
            ;

loop_no_set_var: 
               { push_expression(ENULL); push_expression(ENULL); }
               ;

loc_n_id: TK_int
          { set_node_id(yy_last_int); }
        | '[' x y ']' TK_int
          { set_node_id(yy_last_int); }
        ;

x: TK_int
 ;
y: TK_int
   { set_xy(yy_prev_int, yy_last_int); }
 ;

node_program: input_decls sub_n_output
            | sub_n_output
            ;

input_decls: in_decl
           | input_decls param_decl
           ; 

sub_n_output: sub_call ';' output_decls
            | sub_call ';'
            ;

output_decls: out_decl
            | output_decls out_decl
            ; 

param_decl: in_decl
          ;

in_decl: in_or_io var ';'
         { set_param_specs(yy_last_io, 0, 0); }
       | TK_NEW in_or_io type var ';'
         { set_param_specs(yy_last_io, 0, 1); }
       | in_or_io type var ';'
          { set_param_specs(yy_last_io, 0, 0); }
       | TK_NEW in_or_io type var '=' expression ';'
         { set_param_specs(yy_last_io, 1, 1); }
       | in_or_io type var '=' expression ';'
         { set_param_specs(yy_last_io, 1, 0); }
       ;

in_or_io: '<'
    { yy_last_io = '<'; }
  | TK_IO
    { yy_last_io = 'B'; }
  ;

out_decl: '>' type var ';'
         { set_param_specs('>', 0, 0); }
        ;

type: TK_type
      { push_exp('T', yytext, settype(yytext)); }
      ;

expression: e_level13
          ; 

e_level13: e_level12 '?' e_level13 ':' e_level13
           { push_exp('?', CNULL, -1); } 
         | e_level12
         ;

e_level12: e_level12 TK_OR e_level11
           { push_exp('o', CNULL, -1); } 
         | e_level11
         ;

e_level11: e_level11 TK_AND e_level10
           { push_exp('a', CNULL, -1); } 
         | e_level10
         ;

e_level10: e_level10 '|' e_level9
           { push_exp('|', CNULL, -1); } 
         | e_level9
         ;

e_level9: e_level9 '^' e_level8
          { push_exp('^', CNULL, -1); } 
        | e_level8
        ;

e_level8: e_level8 '&' e_level7
          { push_exp('&', CNULL, -1); } 
        | e_level7
        ;

e_level7: e_level7 TK_NE e_level6
          { push_exp('!', CNULL, -1); } 
        | e_level7 TK_EQ e_level6
          { push_exp('=', CNULL, -1); } 
        | e_level6
        ;

e_level6: e_level6 TK_LE e_level5
          { push_exp('l', CNULL, -1); } 
        | e_level6 TK_GE e_level5
          { push_exp('g', CNULL, -1); } 
        | e_level6 '<' e_level5
          { push_exp('<', CNULL, -1); } 
        | e_level6 '>' e_level5
          { push_exp('>', CNULL, -1); } 
        | e_level5
        ;

e_level5: e_level5 TK_LS e_level4
          { push_exp('L', CNULL, -1); } 
        | e_level5 TK_RS e_level4
          { push_exp('R', CNULL, -1); } 
        | e_level4
        ;

e_level4: e_level4 '+' e_level3
          { push_exp('+', CNULL, -1); } 
        | e_level4 '-' e_level3
          { push_exp('-', CNULL, -1); } 
        | e_level3
        ;

e_level3: e_level3 '*' e_level2
          { push_exp('*', CNULL, -1); } 
        | e_level3 '/' e_level2
          { push_exp('/', CNULL, -1); } 
        | e_level3 '%' e_level2
          { push_exp('%', CNULL, -1); } 
        | e_level2
        ;

e_level2: '-' e_level2
          { push_exp('M', CNULL, -1); } /* Unary Minus */
        | '*' e_level2
          { push_exp('I', CNULL, -1); } /* Indirection */
        | '!' e_level2
          { push_exp('N', CNULL, -1); } /* Unary Not */
        | '~' e_level2
          { push_exp('C', CNULL, -1); } /* Unary Complement */
        | '&' e_level2
          { push_exp('A', CNULL, -1); } /* Address */
        | paren
        | const
        | var
        ;

paren: '(' expression ')'
     ;

const: TK_int
       { push_exp('c', yytext, INT); }
     | TK_float
       { push_exp('c', yytext, FLOAT); }
     | TK_string
       { push_str(yy_last_str); } 
     ;

/* array_var: arrays */
/*      { push_exp('P', (char *) new_param(Nd), -1); } */
/*      ; */
     
var: all_vars
     { push_exp('P', (char *) new_param(Nd), -1); }
   ;

all_vars: scalars
        | arrays
        ;

arrays: id dims
      ;

scalars: id
       ;

id: TK_id
    { push_exp('p', (char *) yy_last_id, -1); }
    ;

dims: dim
    | dims dim
    ;

dim: '[' ']'
     { push_exp('[', CNULL, -1); }  /* Entire Contents */
   | '[' expression ']'
     { push_exp(']', CNULL, -1); }
   | '[' expression ':' expression ']'
     { push_exp('.', CNULL, -1); }
   ;

sub_call: sub_name sub_args 
        | ret_val '=' sub_name sub_args
        ;

ret_val: var
         { ret_val(); }
       ;

sub_name: TK_id
         { sub_name(yy_last_id); }
        ;

sub_args: '(' ')' 
        | '(' args ')' 
        ;

args: arg
    | arg ',' args
    ;

arg: expression
     { sub_arg(); }
   ;
         
%%

#include "grparse.inc"

yyerror(s)
char *s;
{
  fprintf(stderr, 
          "%s at line %d token <%s>\n", s, yylineno, yytext);
  exit(1);
}

yywrap() { return 1; }

grparse(G)
Graph G;
{
  char *file;

  file = G->graph_file;
  parse_begin(G);
  if (strcmp(file, "-") == 0) yyin = stdin;
  else {
    if (!(yyin = fopen(file, "r"))) {
      fprintf(stderr, "Error: Can't read graph file: %s\n", file);
      _exit(1);
    }
  }
  (void) yyparse();
}

