/*
 * glue to make the Xt and Xaw routines easier to use.
 *
 * $Id: xtglue.c,v 1.1 1994/02/17 21:39:25 moore Exp $
 *
 * $Log: xtglue.c,v $
 * Revision 1.1  1994/02/17  21:39:25  moore
 * Initial revision
 *
 */

#include <stdio.h>
#ifdef HAVE_STDARG
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "global.h"
#include "xtglue.h"

#include <Malloc.h>

#ifdef HAVE_STDARG
XtGlueCreateFormSubWidget (char *widget_name, WidgetClass widget_class,
			   Widget parent, XtGlueFormGravity gravity, ...)
{
    va_list arglist;
    
#else
Widget
XtGlueCreateFormSubWidget (va_alist)
va_dcl
{
    va_list arglist;
    char *widget_name;
    WidgetClass widget_class;
    Widget parent;
    XtGlueFormGravity gravity;
#endif
    Widget result;
    XtEdgeType top, bottom, left, right;
    Arg args[100];
    int nargs = 0;
    
#ifdef HAVE_STDARG
    va_start (arglist, gravity);
#else
    va_start (arglist);

    widget_name = va_arg (arglist, char *);
    widget_class = va_arg (arglist, WidgetClass);
    parent = va_arg (arglist, Widget);
    gravity = va_arg (arglist, XtGlueFormGravity);
#endif

    while (1) {
	char *name;
	XtArgVal value;

	name = va_arg (arglist, char *);
	if (name == NULL)
	    break;
	value = va_arg (arglist, XtArgVal);
	args[nargs].name = name;
	args[nargs].value = value;
	nargs++;
    };

    top = XtChainTop;
    bottom = XtChainBottom;
    left = XtChainLeft;
    right = XtChainRight;
    switch (gravity) {
    case North:
	bottom = XtChainTop;
	break;
    case NorthEast:
	left = XtChainRight;
	bottom = XtChainTop;
	break;
    case East:
	left = XtChainRight;
	break;
    case SouthEast:
	left = XtChainRight;
	top = XtChainBottom;
	break;
    case South:
	top = XtChainBottom;
	break;
    case SouthWest:
	top = XtChainBottom;
	right = XtChainLeft;
	break;
    case West:
	right = XtChainLeft;
	break;
    case NorthWest:
	right = XtChainLeft;
	bottom = XtChainTop;
    case Center:
	break;
    default:
	break;
    }

    XtSetArg (args[nargs], XtNtop, top); nargs++;
    XtSetArg (args[nargs], XtNbottom, bottom); nargs++;
    XtSetArg (args[nargs], XtNleft, left); nargs++;
    XtSetArg (args[nargs], XtNright, right); nargs++;

    result = XtCreateManagedWidget (widget_name, widget_class, parent,
				    args, nargs);
    va_end (arglist);
    return result;
}


Pixmap
XtGlueMakePixmap (bits, width, height)
char *bits;
int width, height;
{
    return XCreatePixmapFromBitmapData (global.display, global.rootWindow,
					bits, width, height,
					1, 0, 1);
}


int
width_of (w)
Widget w;
{
    Dimension width, borderWidth;
    width = borderWidth = 0;
    XtVaGetValues (w,
		   XtNwidth, &width,
		   XtNborderWidth, &borderWidth,
		   NULL);
#if 0
    fprintf (stderr, "width_of (%s) = %d\n", w->core.name, width);
#endif    
    return width + 2 * borderWidth;
}

int
height_of (w)
Widget w;
{
    Dimension height, borderWidth;
    XtVaGetValues (w,
		   XtNheight, &height,
		   XtNborderWidth, &borderWidth,
		   NULL);
#if 0
    fprintf (stderr, "height_of (%s) = %d\n", w->core.name, height);
#endif    
    return height + 2 * borderWidth;
}

