#include <sys/types.h>
#include <netinet/in.h>
#include "tfnew.h"

int
read_section_hdr (fd, h)
struct section_hdr *h;
{
    struct section_hdr buf;

    if (read (fd, &buf, sizeof (buf)) != sizeof (buf))
	return -1;
    h->section_type = ntohl (buf.section_type);
    h->record_count = ntohl (buf.record_count);
    h->record_length = ntohl (buf.record_length);
    h->version_number = ntohl (buf.version_number);
    return 0;
}


int
read_hdr_rec (fd, h)
struct hdr_rec *h;
{
    if (read (fd, h, sizeof (*h)) != sizeof (*h))
	return -1;
    return 0;
}

int
read_machine_rec (fd, m)
struct machine_rec *m;
{
    if (read (fd, m, sizeof (*m)) != sizeof (*m))
	return -1;
    return 0;
}


int
read_subr_rec (fd, s)
struct subr_rec *s;
{
    if (read (fd, s, sizeof (*s)) != sizeof (*s))
	return -1;
    return 0;
}

int
read_node_rec (fd, n)
struct node_rec *n;
{
    struct node_rec buf;

    if (read (fd, &buf, sizeof (buf)) != sizeof (buf))
	return -1;
    n->node_number = ntohs (buf.node_number);
    n->node_type = ntohs (buf.node_type);
    n->x = ntohs (buf.x);
    n->y = ntohs (buf.y);
    n->subr_number = ntohs (buf.subr_number);
    return 0;
}

int
read_link_rec (fd, l)
struct link_rec *l;
{
    struct link_rec buf;

    if (read (fd, &buf, sizeof (buf)) != sizeof (buf))
	return -1;

    l->from_node = ntohs (buf.from_node);
    l->to_node = ntohs (buf.to_node);
    return 0;
}

int
read_cost_rec (fd, c)
struct cost_rec *c;
{
    struct cost_rec buf;

    if (read (fd, &buf, sizeof (buf)) != sizeof (buf))
	return -1;
    c->host_number = ntohs (buf.host_number);
    c->subr_number = ntohs (buf.subr_number);
    c->cost = ntohl (buf.cost);
    return 0;
}

int
read_event_rec (fd, e)
struct event_rec *e;
{
    struct event_rec buf;

    if (read (fd, &buf, sizeof (buf)) != sizeof (buf))
	return -1;
    e->sequence = ntohl (buf.sequence);
    e->seconds = ntohl (buf.seconds);
    e->msec = ntohs (buf.msec);
    e->event_type = buf.event_type;
    e->state = buf.state;
    e->node_number = ntohs (buf.node_number);
    e->machine_number = ntohs (buf.machine_number);
    e->inst_number = ntohl (buf.inst_number);
    e->lower_bound = ntohl (buf.lower_bound);
    e->upper_bound = ntohl (buf.upper_bound);
    e->num_running = ntohs (buf.num_running);
    e->num_idle = ntohs (buf.num_idle);
    return 0;
}
