/*
 * new trace file definitions
 *
 * $Id: tfnew.h,v 1.1 1994/02/17 21:38:26 moore Exp $
 *
 * $Log: tfnew.h,v $
 * Revision 1.1  1994/02/17  21:38:26  moore
 * Initial revision
 *
 */

#ifndef TFNEW_INCLUDED
#define TFNEW_INCLUDED

/* type declarations go here */

/*
 * The trace file consists of several sections, each with the following
 * format:
 *
 * |<-----------32 bits------------>|
 *
 * +--------------------------------+
 * |                                |
 * |         section type           |
 * |                                |
 * +--------------------------------+
 * |                                |
 * |        section length          | (section length in #records)
 * |                                |
 * +--------------------------------+
 * |                                |
 * |        record length           | (record length in bytes)
 * |                                |
 * +--------------------------------+
 * |                                |
 * |        version number          |
 * |                                |
 * +--------------------------------+
 * |                                |
 * ~               .                ~
 *                 .                   (length bytes)
 * ~               .                ~
 * |                                |
 * +--------------------------------+
 */

struct section_hdr {
    unsigned int section_type;
    unsigned int record_count;	/* 0 means 'til end of file */
    unsigned int record_length;
    unsigned int version_number;
};

/*
 * section types
 * type numbers must appear in increasing order.
 *
 * I didn't pick these numbers for any particular reason, other
 * than they're odd, and to leave some space in between in case
 * I need to define more section types.
 */

#define SECT_HDR		0x3401
#define SECT_MACHINES		0x3501
#define SECT_SUBRS		0x3601
#define SECT_NODES		0x3701
#define SECT_LINKS		0x3801
#define SECT_COSTS		0x3901
#define SECT_EVENTS		0x3A01

/*
 * record formats
 */


/*
 * file header (magic = SECT_HDR)
 *
 * there is a single record consisting of 16 bytes, which is a NUL
 * padded version string.  The last byte is always a NUL.
 */
struct hdr_rec {
    char version[16];
};

/*
 * machines (magic = SECT_MACHINES)
 *
 * each record consists of 64 bytes, NUL padded, containing the machine
 * name.  The last byte is always a NUL.
 */

struct machine_rec {
    char machine_name[64];
};

/*
 * subrs (magic = SECT_SUBRS)
 *
 * each record consists of 32 bytes, NUL padded, containing the subr
 * name.  The last byte is always a NUL.
 */

struct subr_rec {
    char subr_name[32];
};

/*
 * nodes (magic = SECT_NODES)
 *
 * each record contains:
 * + a node number (16 bits)
 * + a node type (16 bits)
 * + a subr number (16 bits)
 *
 */

struct node_rec {
    unsigned short node_number;
    unsigned short node_type;
#define NT_NORMAL   0
#define NT_COND	    1
#define NT_ENDCOND  2
#define NT_LOOP     3
#define NT_ENDLOOP  4
#define NT_FANOUT   5
#define NT_FANIN    6
#define NT_PIPE     7
#define NT_ENDPIPE  8
    unsigned short subr_number;
    unsigned short x, y;
};

/*
 * links (magic = SECT_LINKS)
 *
 * each record contains:
 * + from node number (16 bits)
 * + to node number (16 bits)
 *
 */

struct link_rec {
    unsigned short from_node;
    unsigned short to_node;
};

/*
 * costs (magic = SECT_COSTS)
 *
 * each record contains:
 * + host number (16 bits)
 * + subr number (16 bits)
 * + cost (32 bits)
 */

struct cost_rec {
    unsigned short host_number;
    unsigned short subr_number;
    unsigned int cost;
};

/*
 * events (magic = SECT_EVENTS)
 *
 * each record contains:
 * + abs time in seconds (32 bits) + thousandths (16 bits)
 * + event type (8 bits)
 * + reserved (8 bits)
 * + node number (16 bits)
 * + instance number (32 bits)
 * + machine number (16 bits)
 * + previous node state (32 bits)
 * + new node state (32 bits)
 * + previous machine state (32 bits)
 * + new machine state (32 bits)
 */

struct event_rec {
    unsigned int sequence;	/* sequence number */
    unsigned int seconds;	/* clock time, secs since 70.01.01 GMT */
    unsigned short msec;	/* msec */
    unsigned char event_type;
#define EV_START	0
#define EV_STATE_CHANGE	1
#define EV_FINISH	2
#define EV_VNODE	3
/*
 * for STATE_CHANGE events, state refers to the new state
 * for VNODE evets, state is true iff vnode is expanded
 */
    unsigned char state;	/* new state (SC/VNODE) */
/*
 * XXX sigh.  some of these are also defined in graph.h
 */
#ifndef ST_NOT_BEGUN
#define ST_NOT_BEGUN	0
#define ST_READY	1
#define ST_RUNNING	2
#define ST_DONE		3
#define ST_DEAD		4
#endif
    unsigned short node_number;	/* node number (SC|VNODE) */
/*
 * + machine number is only valid for state changes, and only then if the
 *   new state is running, done, or dead.
 */
    unsigned short machine_number; 	/* machine number (SC) */
    unsigned int inst_number;		/* inst number (SC|VNODE) */
    unsigned int lower_bound;
    unsigned int upper_bound;
/*
 * the last two fields are a portion of the machine state at the time
 * that the trace event was written.  Which portion is based on the
 * sequence number.  If:
 *
 * M is the number of machines, and
 * S is the number of subroutines, and
 * N is the number of nodes, 
 * q is the sequence number, modulo (M + N + S + (M*S)), then
 *
 * if...			then num_running and num_idle refer to...
 * ======================================================================
 * 0 <= q < M			machine q
 * M <= q < M+S			subr q - M
 * M+S <= q < M+S+N		node q - M - S
 * M+S+N <= q < M+S+N+(M*S)	cell q - M - S - N
 *				where cell(m,s) = m * S + s
 *
 * so to get the complete machine state at any point,
 *
 * + initialize all state to zero
 * + seek to M + N + S + (M*S) records before that point (or to the
 *   epoch)
 * + read all records up to the desired point, updating whatever statistics
 *   are indicated by the sequence number.  Note that additional changes
 *   in the machine state, as indicated by other fields, will be happening,
 *   so the reader has to keep track of these also.
 */
    unsigned short num_running;
    unsigned short num_idle;
};

#endif /* TFNEW_INCLUDED */
