#include <stdio.h>
#include "tfnew.h"

struct section_hdr sect;
struct hdr_rec hdr;
struct machine_rec machine;
struct subr_rec subr;
struct node_rec node;
struct link_rec link;
struct cost_rec cost;
struct event_rec event;

char *
sect_type_name (s)
int s;
{
    switch (s) {
    case SECT_HDR: return "file header";
    case SECT_MACHINES: return "machine";
    case SECT_SUBRS: return "subrs";
    case SECT_NODES: return "nodes";
    case SECT_LINKS: return "links";
    case SECT_COSTS: return "costs";
    case SECT_EVENTS: return "events";
    default: return "unknown";
    }
}

char *
node_type_name (nt)
int nt;
{
    switch (nt) {
    case NT_NORMAL: return "NORMAL";
    case NT_COND: return "COND";
    case NT_ENDCOND: return "ENDCOND";
    case NT_LOOP: return "LOOP";
    case NT_ENDLOOP: return "ENDLOOP";
    case NT_FANOUT: return "FANOUT";
    case NT_FANIN: return "FANIN";
    case NT_PIPE: return "PIPE";
    case NT_ENDPIPE: return "ENDPIPE";
    default: return "unknown";
    }
}


char *
event_type_name (et)
int et;
{
    static char buf[10];

    switch (et) {
    case EV_START: return "START";
    case EV_STATE_CHANGE: return "STATE";
    case EV_FINISH: return "FINISH";
    case EV_VNODE: return "VNODE";
    default:
	sprintf (buf, "%d", et);
	return buf;
    }
}

char *
event_state_name (es)
int es;
{
    static char buf[10];

    switch (es) {
    case ST_NOT_BEGUN: return "UNBEGUN";
    case ST_READY: return "READY";
    case ST_RUNNING: return "RUNNING";
    case ST_DONE: return "DONE";
    case ST_DEAD: return "DEAD";
    default:
	sprintf (buf, "%d", es);
	return buf;
    }
}

main ()
{
    int fd = 0;
    int i;
    char buf[5120];

    while (read_section_hdr (fd, &sect) >= 0) {
	printf ("section type=0x%x (%s) nrec=%d recl=%d vers=%d\n",
		sect.section_type, sect_type_name(sect.section_type),
		sect.record_count, sect.record_length, sect.version_number);
	switch (sect.section_type) {
	case SECT_HDR:
	    for (i = 0; i < sect.record_count; ++i) {
		read_hdr_rec (fd, &hdr);
		printf ("[%d] version = %s\n", i, hdr.version);
	    }
	    break;
	case SECT_MACHINES:
	    for (i = 0; i < sect.record_count; ++i) {
		read_machine_rec (fd, &machine);
		printf ("[%d] machine_name = %s\n", i,
			machine.machine_name);
	    }
	    break;
	case SECT_SUBRS:
	    for (i = 0; i < sect.record_count; ++i) {
		read_subr_rec (fd, &subr);
		printf ("[%d] subr_name = %s\n", i,
			subr.subr_name);
	    }
	    break;
	case SECT_NODES:
	    for (i = 0; i < sect.record_count; ++i) {
		read_node_rec (fd, &node);
		printf ("[%d] id = %d, type = %d (%s), subr = %d\n", i,
			node.node_number,
			node.node_type, node_type_name (node.node_type),
			node.subr_number);
	    }
	    break;
	case SECT_LINKS:
	    for (i = 0; i < sect.record_count; ++i) {
		read_link_rec (fd, &link);
		printf ("[%d] from=%d to=%d\n", i,
			link.from_node, link.to_node);
	    }
	    break;
	case SECT_COSTS:
	    for (i = 0; i < sect.record_count; ++i) {
		read_cost_rec (fd, &cost);
		printf ("[%d] host=%d subr=%d cost=%d\n", i,
			cost.host_number, cost.subr_number, cost.cost);
	    }
	    break;
	case SECT_EVENTS:
	    while (read_event_rec (fd, &event) >= 0) {
		printf ("%d %d.%d type=%s state=%s node=%d/%d",
			event.sequence, event.seconds, event.msec,
			event_type_name(event.event_type),
			event_state_name(event.state),
			event.node_number,
			event.inst_number);
		if (event.event_type == EV_STATE_CHANGE) {
		    printf (" mach=%d", event.machine_number);
		}
		else if (event.event_type == EV_VNODE) {
		    printf (" (%d %d)", event.lower_bound, event.upper_bound);
		}
		printf (" [%d %d]\n", event.num_running, event.num_idle);
	    }
	default:
	    for (i = 0; i < sect.record_count; ++i) {
		if (read (fd, buf, sect.record_length) < sect.record_length)
		    exit (0);
		printf ("[%d] skipping\n");
	    }	    
	    break;
	}
    }
}
