#include <stdio.h>
#include "regexp.h"
#include <Malloc.h>

#if 0
static char *pattern = "";
#endif

/*
 * filter to do something approximating /bin/sh-style globbing.
 * based on Henry Spenser's V8-style regexp() routines.  This
 * works by translating the globbing pattern into a regexp,
 * then compiling it with regcomp().
 *
 * Keith Moore
 * December 1991
 */

regexp *
compile_filter (src)
char *src;
{
    char re[1000];
    char *dst = re;
    int ccl = 0;

    if (src == NULL)
	return regcomp ("");

#if 0
    pattern = src;
#endif

    *dst++ = '^';
    /*
     * first char is special - never match a '.' at the start of
     * a file name unless it appears explicitly in the pattern
     */
    switch (*src) {
    case '.':
	*dst++ = '\\';
	*dst++ = '.';
	break;
    case '*':			/* any string not starting with '.' */
	*dst++ = '[';
	*dst++ = '^';
	*dst++ = '.';
	*dst++ = ']';
	*dst++ = '.';
	*dst++ = '*';
	break;
    case '?':			/* any character (except '.') */
	*dst++ = '[';
	*dst++ = '^';
	*dst++ = '.';
	*dst++ = ']';
	break;
    case '[':			/* begin character class */
	*dst++ = '[';
	ccl = 1;
	/*
	 * check for initial '^' or ']' now.  Otherwise we might think
	 * that the ']' closed the character class when in fact it is
	 * a member of the class
	 */
	if (src[1] == '^')
	    *dst++ = *++src;
	if (src[1] == ']')
	    *dst++ = *++src;
	break;
    case '\0':
	return regcomp("");
    case ']':
    case '(':
    case ')':
    case '+':
    case '^':
    case '$':
	*dst++ = '\\';
	*dst++ = *src;
	break;
    case '\\':
	if (src[1] != '\0') {
	    *dst++ = *src++;
	    *dst++ = *src;
	}
	break;
    default:
	*dst++ = *src;
    }
    ++src;
    /*
     * process the rest of the pattern
     */
    while (*src) {
	switch (*src) {
	case '*':		/* matches any string, including "" */
	    *dst++ = '.';
	    *dst++ = '*';
	    break;
	case '?':		/* matches any single character */
	    *dst++ = '.';
	    break;
	case '[':		/* begin character class */
	    *dst++ = '[';
	    ccl = 1;
	    /*
	     * check for initial '^' or ']' now.  Otherwise we might think
	     * that the ']' closed the character class when in fact it is
	     * a member of the class
	     */
	    if (src[1] == '^')
		*dst++ = *++src;
	    if (src[1] == ']')
		*dst++ = *++src;
	    break;
	case ']':
	    ccl = 0;
	    *dst++ = ']';
	    break;
	case '.':
	case '(':
	case ')':
	case '+':
	case '^':
	case '$':
	    if (!ccl)
		*dst++ = '\\';
	    *dst++ = *src;
	    break;
	case '\\':
	    if (src[1] != '\0') {
		*dst++ = *src++;
		*dst++ = *src;
	    }
	    break;
	default:
	    *dst++ = *src;
	}
	++src;
    }
    *dst++ = '$';
    *dst = '\0';
#if 0
    fprintf (stderr, "regexp = %s\n", re);
#endif
    return regcomp (re);
}

int
match_filter (re, str)
char *str;
regexp *re;
{
#if 0
    int x = regexec (re, str);
    fprintf (stderr, "match_filter (\"%s\", \"%s\") = %d\n", pattern, str, x);
    return x;
#else
    return (regexec (re, str));
#endif
}


void
regerror (str)
char *str;
{
    fprintf (stderr, "regexp error: %s", str);
}
