/*
 * definitions for red-black tree routines.
 *
 * $Id: rb.h,v 1.1 1994/02/17 21:35:35 moore Exp $
 *
 * $Log: rb.h,v $
 * Revision 1.1  1994/02/17  21:35:35  moore
 * Initial revision
 *
 */

#ifndef RB_INCLUDED

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

typedef struct rb_node *rbNode;
typedef struct rb_tree *rbTree;

extern rbTree rb_Create __((int (*compare)()));
extern rbNode rb_Find __((rbTree tree, void *key, int *found));
extern void rb_DeleteNode __((rbNode node));
extern void rb_DeleteTree __((rbTree tree));
extern void rb_Insert __((rbTree tree, void *key, void *value));
extern void rb_InsertBefore __((rbNode node, void *key, void *value));
extern void rb_InsertAfter __((rbNode node, void *key, void *value));
extern rbNode rb_First __((rbTree tree));
extern rbNode rb_Last __((rbTree tree));
extern rbNode rb_Next __((rbNode node));
extern rbNode rb_Prev __((rbNode node));
extern int rb_Empty __((rbTree tree));
extern int rb_Done __((rbNode node, rbTree tree));
extern void *rb_Key __((rbNode node));
extern void *rb_Value __((rbNode node));
extern void rb_SetValue __((rbNode node, void *value));
extern int rb_Traverse __((rbTree t, int (*func)()));
extern int rb_TraverseX __((rbTree t, int (*func)(), void *arg));
#undef __

#define RB_INCLUDED
#endif
