/*
 * 'proxy' module definitions
 *
 * $Id: proxy.h,v 1.2 1994/06/11 20:43:15 moore Exp $
 *
 * $Log: proxy.h,v $
 * Revision 1.2  1994/06/11  20:43:15  moore
 * change protocol version #
 * add new 'exclusive file create' command
 * add decl for proxy_copy_lock_file function
 *
 * Revision 1.1  1994/02/17  21:34:07  moore
 * Initial revision
 *
 */

#ifndef PROXY_INCLUDED

/* type declarations go here */

#define PROXY_PROTOCOL_VERSION 17

/*
 * msg tags
 */

#define commandTag	100	/* command to server */
#define responseTag	101	/* response from server */
#define cmdStdoutTag	102	/* stdout message from server */
#define cmdStderrTag	103	/* stderr message from server */
#define pvmDiedTag	104	/* pvm system died */
#define hostDiedTag	105	/* a server host died */
#define serverDiedTag	106	/* proxyd died */
#define cmdExitTag	107	/* a shell command exited */
#define pvmStdoutTag	108	/* stdout from pvm children */

/*
 * commands
 */

#define illegalCmd	-1	/* illegal command (used in responses) */
#define versionCmd	0	/* what is your version? */
#define createFileCmd	1	/* create file (filename, size, mtime) */
#define writeFileCmd	2	/* write file (nbytes, buf) */
#define abortCmd	3	/* abort command */
#define spawnCmd	4	/* spawn a program */
#define createExclusiveFileCmd 5 /* create file (filename)
				  * fail if it already exists */

/*
 * error code
 */

/*
 * errors between pvmMaxError and pvmMinError are defined in pvm3.h
 */

#define pvmMaxError	0
#define pvmMinError	-100
#define isPvmErr(x)	((x) > pvmMinError && (x) < pvmMaxError)

/*
 * errors between unixMaxError and unixMinError are the negative
 * of the UNIX errno, plus unixMinError
 */
#define unixMaxError	-99
#define unixMinError	-200
#define isUnixErr(x)  ((x) > unixMinError && (x) < unixMaxError)
#define unixErrno(x)  (unixMinError - (x))

/*
 * errors between proxyMaxError and proxyMinError are defined below
 */

#define proxyMaxError	-199
#define pBadHostErr	-200	/* bad host number */
#define pIllegalCmdErr	-201	/* illegal command */
#define pHostDiedErr	-202	/* host died */
#define pServerDiedErr	-203	/* server died */
#define pVersionErr	-204	/* server version mismatch */
#define pFileExistsErr	-205	/* file already exists */
#define pProtocolErr	-206	/* protocol error */
#define pIllegalArgErr	-207	/* illegal argument error */
#define proxyMinError	-208

#define isProxyErr(x) ((x) > proxyMinError && (x) < proxyMaxError)

#define MSGBUFSIZE 1024
#define PROXY_FILEBUFSIZE 1024

/* function declarations go here */
#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

char *proxy_strerror __((int x));
int proxy_init __((int nhosts));
int proxy_start_server __((int hostnum));
int proxy_shutdown_server __((int hostnum));
int proxy_get_server_version __((int hostnum, int *version));
int proxy_copy_file __((char *src_filename, int dest_host,
			char *dest_filename));
int proxy_copy_lock_file __((char *src_filename, int dest_host,
			     char *dest_filename));
int proxy_queue_cmd __((int host, int subr, char *cmd));
int proxy_run_cmds __((void));

#undef __

#define PROXY_INCLUDED
#endif /* PROXY_INCLUDED */
