/*
 * param structure definition for htool 2.x
 *
 * $Id: param.h,v 1.1 1994/02/17 21:33:39 moore Exp $
 *
 * $Log: param.h,v $
 * Revision 1.1  1994/02/17  21:33:39  moore
 * Initial revision
 *
 */

#ifndef PARAM_INCLUDED

#include "rb.h"

#ifdef __
#undef __
#endif
#if defined (__STDC__) || defined(FUNCPROTO)
#define __(X) X
#else
#define __(X) ()
#endif

struct array {			/* The representation of array constants */
    union {
	char *c;		/* Pointer to raw hunk of bytes */
	int *i;
	double *d;
	float *f;
    } v;
    void *ptr;			/* Indirection pointer */
    int type;			/* Type of v */
    int ndims;			/* Number of indirections */
    int tsize;			/* # of elements in v */
    int *size;			/* Size of each dimension */
    int *indsize;		/* Increment of number of elements per
				 * counter in each dimension */
    struct {
	unsigned ptr  : 1;
	unsigned v    : 1;
	unsigned init : 1;
	unsigned junk : 5;
    } refd;
};

typedef struct array *Array;

struct param_array {		/* Information for array parameters */
    int type;			/* The type of the array elements */
    int nadims;			/* The number of dimensions of the array */
    int ndims;			/* The number of dims of the array parameter */
    struct expression **dims;	/* The dimension expressions */
    rbTree p;			/* The level-2 array parameters */
    int n_level2;		/* The # of level-2 array parameters */
    struct parameter *main;	/* (For level-2 params): The level-1 param */
};

typedef struct param_array *Parray;

typedef struct {
    unsigned in	  : 1;
    unsigned out  : 1;
    unsigned inj  : 1;
    unsigned new  : 1;
    unsigned main : 1;
    unsigned used : 1;
    unsigned junk : 2;
} param_flags;

struct parameter {		/* Representation of parameters */
    char *name;			/* The name */
    int num;			/* The parameter number (set in execute.c) */
    param_flags io;		/* All the flags */
    int type;			/* The type */
    Parray a;			/* Array info if type = ARRAY */
    int inj;			/* The injected value, if it's injected */
    struct expression *val;	/* The initialization value */
    int state;			/* State field for various manipulation */
    struct parameter *mirror;	/* Field to help copying parameters */
#if 0
    struct node *nodeWhereDeclared;
#endif
};

typedef struct parameter *Param;

extern Param param_New __((char *s));
extern void param_Free __((Param p));
extern Parray param_NewArrayParams ();
extern void param_FreeArrayParams __((Parray p));
extern void param_AddArrayDim __((Parray p, struct expression *e));

#undef __

#define PARAM_INCLUDED
#endif /* PARAM_INCLUDED */
