/*
 * routines for outputting formatted text to a message window
 *
 * $Id: msg.c,v 1.1 1994/02/17 21:33:15 moore Exp $
 *
 * $Log: msg.c,v $
 * Revision 1.1  1994/02/17  21:33:15  moore
 * Initial revision
 *
 */

static char msg_buf[1024];
static int (*msg_writebuf)();

static void msg_Flush ();

#if defined(HAVE_STDARG)

#include <stdio.h>
#include <stdarg.h>

#include <Malloc.h>

void
msg_Format (char *format, ... )
{
    va_list arglist;

    va_start (arglist, format);
    vsprintf (msg_buf, format, arglist);
    va_end (arglist);
    msg_Flush ();
}

#else /* defined(HAVE_STDARG) */

#include <stdio.h>
#include <varargs.h>

#include <Malloc.h>

void
msg_Format (va_alist)
va_dcl
{
    va_list arglist;
    char *format;

    va_start (arglist);
    format = va_arg (arglist, char *);
    vsprintf (msg_buf, format, arglist);
    va_end (arglist);
    msg_Flush ();
}

#endif /* HAVE_STDARG */

int
msg_WriteToStderr (buf)
char *buf;
{
    fprintf (stderr, "%s", buf);
    fflush (stderr);
    return 0;
}

void
msg_SetWriteFunction (fn)
int (*fn)();
{
    if (fn != (int (*)()) NULL)
	msg_writebuf = fn;
    else
	msg_writebuf = msg_WriteToStderr;
}

static void
msg_Flush ()
{
    if (msg_writebuf != (int (*)()) NULL)
	(*msg_writebuf)(msg_buf);
    else
	msg_WriteToStderr (msg_buf);
}
