/*
 * routines for drawing HeNCE graphs
 *
 * $Id: graph_draw.h,v 1.1 1994/02/17 20:22:52 moore Exp $
 *
 * $Log: graph_draw.h,v $
 * Revision 1.1  1994/02/17  20:22:52  moore
 * Initial revision
 *
 */

#ifndef GRAPH_DRAW_INCLUDED

#include "graph.h"		/* for Graph */
#include "trace_new.h"		/* for struct event_time */

#define	NODERADIUS 11	/* size of graph node circle */

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

void draw_init __((Widget w));
void draw_node __((Widget w, Node n, int how));
void draw_line __((Widget w, GC gc, int x1, int y1, int x2, int y2));
void draw_arc __((Widget w, Node n1, Node n2, int how));
void draw_graph __((Widget w, Graph g, int tracemode));
void draw_time __((Widget w, struct event_time *t, int seq));
void redraw_graph __((Widget w, Graph g));
Node find_nearest_node __((Graph g, int x, int y));
void find_nearest_arc __((Graph g, int x, int y, Node *from, Node *to));
#undef __

#define GRAPH_DRAW_INCLUDED
#endif /* GRAPH_DRAW_INCLUDED */
