/*
 * verify popups
 *
 * $Id: filever.c,v 1.2 1994/06/11 20:40:11 moore Exp $
 *
 * $Log: filever.c,v $
 * Revision 1.2  1994/06/11  20:40:11  moore
 * add missing #include "tilde.h" decl
 *
 * Revision 1.1  1994/02/17  20:21:35  moore
 * Initial revision
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xos.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "FileSelect.h"
#include "global.h"
#include "tilde.h"

/*
 * Bondo
 */
#include <Malloc.h>

#define XtVaCMW XtVaCreateManagedWidget

/*
 *	get_window_origin ()
 *
 *	Return x and/or y of u.l.c. of widget's window.
 */

static void
get_window_origin (wgt, px, py)
Widget wgt;
int *px, *py;
{
    int x, y;
    Window w, wc;

    w = XtWindow (wgt);
    XTranslateCoordinates (global.display, w, global.rootWindow,
			   0, 0, &x, &y, &wc);
    if (px)
	*px = x;
    if (py)
	*py = y;
}

/*
 *	get_window_size ()
 *
 *	Return wd and/or ht of widget's window.
 */

static void
get_window_size (wgt, px, py)
Widget wgt;
int *px, *py;
{
    Window w;
    XWindowAttributes wat;

    w = XtWindow (wgt);
    XGetWindowAttributes (global.display, w, &wat);
    if (px)
	*px = wat.width;
    if (py)
	*py = wat.height;
}


/*	fileVerify ()
 *
 *	Verify a load/store type action with user.  Popup up widget with
 *	message and filename.  Allow user to change filename.
 *	On confirmation return
 *		0 if 'ok',
 *		1 if 'cancel'
 */

static int status = -1;

static void
file_verify_callback (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    String selection;

    status = (int) cd;
    switch (status) {
    case 0:
	XtVaGetValues (w, XtNselection, &selection, NULL);
	break;
    case 1:
	break;
    }
}

/*
 *	get_mousxy()
 *
 *	Return x, y of mouse in rootwindow.
 */

static void
get_mouse_position (px, py)
int *px, *py;
{
    Window w1, w2;
    int i;

    if (XQueryPointer (global.display, global.rootWindow,
		       &w1, &w2, px, py, &i, &i,
		       (unsigned int *) &i) == False) {
	*px = *py = 0;
    }
}

int
fileVerify (msg, name, maxlen, filter, flags)
char *msg;
char *name;
int maxlen;
char *filter;
int flags;
{
    int x, y;
    Widget fileVerPop = 0;
    Widget fileVer = 0;
    XEvent event;
    String result;

    get_mouse_position (&x, &y);

    /* create a widget */
    fileVerPop = XtCreatePopupShell ("fileverPop",
				     transientShellWidgetClass,
				     global.topLevel, NULL, 0);
    fileVer = XtVaCreateManagedWidget ("fileselect", fileselectWidgetClass,
				       fileVerPop,
				       XtNlabel1, (XtPointer) msg,
				       XtNfilter, (XtPointer) filter,
				       XtNflags, (XtPointer) flags,
				       NULL);
    XtAddCallback (fileVer, XtNcallback, file_verify_callback,
		   (XtPointer) NULL);

    if (x == 0 && y == 0)
	XtVaSetValues (fileVerPop,
		       XtNwidth, (XtPointer) 500,
		       XtNheight, (XtPointer) 300,
		       NULL);
    else
	XtVaSetValues (fileVerPop,
		       XtNwidth, (XtPointer) 500,
		       XtNheight, (XtPointer) 300,
		       XtNx, (XtPointer) x,
		       XtNy, (XtPointer) y,
		       NULL);

    XtRealizeWidget (fileVerPop);

    if (*name != '\0') {
	XtVaSetValues (fileVer,
		       XtNselection, (XtPointer) name,
		       NULL);
    }
#if 0
    else
	fprintf (stderr, "fileVerify: not setting selection\n", name);
#endif

    XtPopup (fileVerPop, XtGrabExclusive);
    for (status = -1; status == -1; ) {
	XtAppNextEvent (global.context, &event);
	XtDispatchEvent (&event);
    }
    if (status == 0) {
	result = NULL;
	XtVaGetValues (fileVer, XtNselection, &result, NULL);
	if (result)
	    strncpy (name, texpand (result), maxlen);
    }
    XtPopdown (fileVerPop);
    
    XtDestroyWidget (fileVerPop);
    return status;
}


static int verify_status;

static void
verify_cb (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    verify_status = (int)cli;
}

/*
 *	verify()
 *
 * Verify an action with user.  Popup up widget with message and wait
 * for confirmation.  On confirmation return
 *		0 if 'yes',
 *		1 if 'no'
 *		2 if 'cancel'
 *
 * XXX really should take printf-style args
 */

int
verify (msg)
char *msg;		/* message */
{
    int n;
    Widget w, wf;
    XEvent event;
    int x, y;
    static Widget verifyPop = 0;
    static Widget verifyLabel = 0;
    static Widget verifyCancel = 0;

    get_mouse_position (&x, &y);

    /* create popup widget if it doesn't already exist */

    if (verifyPop) {
	XtVaSetValues(verifyLabel,
		      XtNlabel, (XtPointer) msg,
		      NULL);
	if (x)
	    XtMoveWidget(verifyPop, x, y);
    }
    else {
	verifyPop = XtVaCreatePopupShell ("verifyPop",
					  transientShellWidgetClass,
					  global.topLevel,
					  NULL);
	wf = XtVaCMW ("", formWidgetClass,
		      verifyPop,
		      NULL);

	verifyLabel = XtVaCMW ("bing", labelWidgetClass, wf,
			       XtNlabel, (XtPointer) msg,
			       XtNborderWidth, 0,
			       XtNresizable, True,
			       XtNbackground, wf->core.background_pixel,
			       NULL);
	w = XtVaCMW ("yes", commandWidgetClass, wf,
		     XtNfromHoriz, verifyLabel,
		     XtNlabel, "yes",
		     NULL);
	XtAddCallback (w, XtNcallback, verify_cb, (XtPointer) 0);

	w = XtVaCMW ("no", commandWidgetClass, wf,
		     XtNfromHoriz, verifyLabel,
		     XtNfromVert, w,
		     XtNlabel, "no",
		     NULL);
	XtAddCallback (w, XtNcallback, verify_cb, (XtPointer) 1);
	
	w = XtVaCMW ("cancel", commandWidgetClass, wf,
		     XtNfromHoriz, verifyLabel,
		     XtNfromVert, w,
		     XtNlabel, "cancel",
		     NULL);
	XtAddCallback (w, XtNcallback, verify_cb, (XtPointer) 2);
	verifyCancel = w;

	XtRealizeWidget(verifyPop);
    }

    /* warp it to the current location, bounce off sides of screen */

    if (x) {
	int wd, ht;

	get_window_origin (verifyPop, &wd, &ht);
	x += wd;
	y += ht;
	get_window_origin (verifyCancel, &wd, &ht);
	x -= wd;
	y -= ht;
	get_window_size (verifyCancel, &wd, &ht);
	x -= wd / 2;
	y -= ht / 2;
	get_window_size (verifyPop, &wd, &ht);
	if (x + wd > global.displayWidth)
	    x = global.displayWidth - wd;
	if (y + ht > global.displayHeight)
	    y = global.displayHeight - ht;
	if (x < 0)
	    x = 0;
	if (y < 0)
	    y = 0;
	XtMoveWidget (verifyPop, x, y);
    }
    XtPopup (verifyPop, XtGrabExclusive);

    /* let Xt stuff happen until we get a response to popup */

    for (verify_status = -1; verify_status == -1; ) {
	XtAppNextEvent (global.context, &event);
	XtDispatchEvent (&event);
    }
    XtPopdown (verifyPop);
    return verify_status;
}
