/*
 * description goes here
 *
 * $Id: exp.h,v 1.1 1994/02/17 20:21:08 moore Exp $
 *
 * $Log: exp.h,v $
 * Revision 1.1  1994/02/17  20:21:08  moore
 * Initial revision
 *
 */

#ifndef EXP_INCLUDED

#include "param.h"

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(X) X
#else
#define __(X) ()
#endif

/*
 * structure of an expression.
 * Ideally, no one but exp.c should have to see this.
 */

/* XXX change "elt_type" to something like "operator" */
/* XXX change "type" to something like "data_type" */

struct expression {
    char elt_type;		/* operator (e.g. OP_ADD) for this node */
    int type;			/* type (e.g. TYPE_INT) (leaf nodes only?) */
    union {
	char *s;		/* value when TYPE_STRING (?) */
	int i;			/* value when TYPE_INT */
	char c;			/* value when TYPE_CHAR (?) */
	Array a;		/* value when TYPE_ARRAY */
	struct parameter *p;	/* points to parameter when OP_PARAM
				   no type name (shouldn't there be?) */
	double d;		/* value when TYPE_DOUBLE */
	float f;		/* value when TYPE_FLOAT */
    } val;
    int nargs;			/* number of operands */
    struct expression *args[3];	/* possible operands */
};

typedef struct expression *Expr;

extern Expr expr_New __((int data_type, int op));
extern void expr_Free __((Expr x));
extern Expr expr_UnaryOp __((int op, Expr operand));
extern Expr expr_BinaryOp __((int op, Expr operand1, Expr operand2));
extern Expr expr_TernaryOp __((int op, Expr operand1, Expr operand2,
			       Expr operand3));
extern Expr expr_Param __((Param p));
extern Expr expr_Const __((int type, void *ptr));
/* extern int expr_Type __((Expr e)); */


/* operators */

#define OP_COND_EXPR	'?'
#define OP_LOGICAL_OR	'o'
#define OP_LOGICAL_AND	'a'
#define OP_LOGICAL_CMPL 'N'	/* logical negation ('!') */
#define OP_BIT_OR       '|'
#define OP_BIT_AND      '&'
#define OP_BIT_XOR      '^'
#define OP_BIT_CMPL     '~'	/* one's complement */
#define OP_COMP_NE      '!'
#define OP_COMP_EQ      '='
#define OP_COMP_LE      'l'
#define OP_COMP_GE      'g'
#define OP_COMP_LT      '<'
#define OP_COMP_GT      '>'
#define OP_LSHIFT       'L'
#define OP_RSHIFT       'R'
#define OP_MULT	        '*'
#define OP_DIV	        '/'
#define OP_MOD	        '%'
#define OP_ADD	        '+'
#define OP_SUBTRACT     '-'
#define OP_NEG	        'M'	/* additive inverse (unary '-') */
#define OP_INDIR        'I'	/* pointer indirection (unary '*') */
#define OP_ADDRESS      'A'	/* address of (unary '&') */
#define OP_EMPTY_DIM	'['	/* empty array dimension */
#define OP_DIM	        ']'	/* array dimension */
#define OP_ARR_SECTION	'.'	/* array section e.g. [ x1 : x2 ] */
#define OP_PARAM        'P'	/* "parameter" (e.g. variable name) */
#define OP_CONST        'c'	/* constant expression */

/* data types */

#define TYPE_VOID	    -4	/* type of function with no return value */
#define TYPE_PARAM	    -3	/* data type is that of parameter */
#define TYPE_UNSPECIFIED    -2	/* node type unspecified */
#define TYPE_INHERITED	    -1	/* type inherited from ancestors */
#define TYPE_INT	    0
#define TYPE_CHAR	    1
#define TYPE_FLOAT	    2
#define TYPE_DOUBLE	    3
#define TYPE_ARRAY	    4
#define TYPE_STRING	    5   /* XXX is this used? */
#define NTYPES		    6   /* number of "real" types */

#define EXPR_IS_ARRAY(x) ((x) > NTYPES)
#define EXPR_NUM_DIMS(x) ((x) / 100)
#define EXPR_BASE_TYPE(x) ((x) % 100)
#define MAKE_EXPR_TYPE(base,ndims) ((ndims) * 100 + (base))

#ifdef NOT_DEFINED
extern int expr_Compare __((Expr e1, Expr e2));
#endif

#undef __

#define EXP_INCLUDED
#endif /* EXP_INCLUDED */
