/*
 * code to handle expressions
 *
 * $Id: exp.c,v 1.1 1994/02/17 20:21:00 moore Exp $
 *
 * $Log: exp.c,v $
 * Revision 1.1  1994/02/17  20:21:00  moore
 * Initial revision
 *
 */

#include "exp.h"

#if 1
#include <stdio.h>
#endif

/*
 * Bondo
 */
#include <Malloc.h>

/* XXX should be private */
Expr
expr_New (data_type, op)
int data_type;
int op;
{
    Expr expr = TALLOC (1, struct expression);
    
    expr->elt_type = op;    /* operation */
    expr->type = data_type; /* data type */
    /*
     * set nargs to zero so we can count on its having a reasonable
     * value.  in particular, if nargs is non zero we can count on
     * args[0..nargs-1] pointing to legitimate expression trees
     * regardless of the data type or operation, for printing or
     * recursive freeing or whatever.
     */
    expr->nargs = 0;
    return expr;
}

void
expr_Free (x)
Expr x;
{
    int i;
    
    if (x == (Expr) NULL)
	return;
    
    switch (x->type) {
    case TYPE_STRING:
	FREE (x->val.s);
	break;
    case TYPE_ARRAY:
	/*
	 * XXX this isn't right -- fix it
	 */
#if 0
	param_FreeArrayParams (x->val.a);
#endif
	break;
    case TYPE_PARAM:
	param_Free (x->val.p);
	break;
    }
    if (x-> nargs < 0 || x->nargs > 3) {
	msg_Format ("expr_Free: illegal number of operands\n");
    }
    for (i = 0; i < x->nargs; ++i)
	expr_Free (x->args[i]);
    FREE ((char *) x);
}

Expr
expr_UnaryOp (op, operand)
int op;
Expr operand;
{
    Expr expr = expr_New (TYPE_UNSPECIFIED, op);
    expr->nargs = 1;
    expr->args[0] = operand;
    return expr;
}

Expr 
expr_BinaryOp (op, operand1, operand2)
int op;
Expr operand1;
Expr operand2;
{
    Expr expr = expr_New (TYPE_UNSPECIFIED, op);
    expr->nargs = 2;
    expr->args[0] = operand1;
    expr->args[1] = operand2;
    return expr;
}

Expr 
expr_TernaryOp (op, operand1, operand2, operand3)
int op;
Expr operand1;
Expr operand2;
Expr operand3;
{
    Expr expr = expr_New (TYPE_UNSPECIFIED, op);
    expr->nargs = 3;
    expr->args[0] = operand1;
    expr->args[1] = operand2;
    expr->args[2] = operand3;
    return expr;
}

/*
 * Convert a constant of some kind into an expression.
 * The value is *always* passed by reference.
 * If type == TYPE_STRING, value MUST be from heap (malloc) storage
 */

Expr 
expr_Const (type, value)
int type;
void *value;
{
    Expr x = expr_New (type, OP_CONST);
    
    switch (type) {
	/*
	 * XXX fill in other types also
	 */
    case TYPE_INT:
	x->val.i = *((int *) value);
	break;
    case TYPE_FLOAT:
	x->val.f = *((float *) value);
	break;
    case TYPE_STRING:
	x->val.s = (char *) value;
	break;
    case TYPE_CHAR:
	x->val.c = *((char *) value);
	break;
    case TYPE_DOUBLE:
	x->val.d = *((double *) value);
	break;
    default:
	msg_Format ("expr_Const: illegal type %d in constant\n", type);
	break;
    }
    return x;
}

Expr 
expr_Param (p)
Param p;
{
    Expr x = expr_New (TYPE_PARAM, OP_PARAM);
    
    x->val.p = p;
    /* XXX set input/output/other flags? */
    return x;
}

#ifdef NOT_DEFINED
/*
 * This is left over from the code scarfed from the original HeNCE
 * executioner.  This tries to determine whether two expressions
 * are equal by comparing their parse trees...doomed to failure.
 */

#define COMPARE(e1,e2,SUFFIX) (e1->val.SUFFIX - e2->val.SUFFIX)

int
expr_Compare (Expr e1, Expr e2)
{
    
    if (e1 == e2)
	return 0;
    
    /*
     * XXX Why?	 Is there supposed to be an ordering relation on
     * expressions?
     */
    if (e1 == (Expr) NULL)
	return -1;
    else if (e2 == (Expr) NULL)
	return 1;
    
    /* XXX Why? */
    if (e1->elt_type != e2->elt_type) 
	return e1->elt_type - e2->elt_type;
    
    switch (e1->elt_type) {
    case OP_PARAM:
	return param_Compare (e1->val.p, e2->val.p);
    case OP_CONST:
	if (e1->type != e2->type)
	    return e1->type - e2->type;
	switch (e1->type) {
	case TYPE_CHAR:
	    return COMPARE (e1,e2,c);
	case TYPE_INT:
	    return COMPARE (e1,e2,i);
	case TYPE_STRING:
	    return strcmp (e1->val.s, e2->val.s);
#if 0
	case TYPE_ARRAY:
	    /* XXX need to fix this */
	    return COMPARE (e1,e2,a);
#endif
	case TYPE_DOUBLE:
	    return COMPARE (e1,e2,d);
	case TYPE_FLOAT:
	    return COMPARE (e1,e2,f);
	}
    default:
	msg ("Can't compare expressions of type %c", e1->elt_type);
    }
}
#endif
