/*
 * panel definitions
 *
 * $Id: costmat.h,v 1.1 1994/02/17 20:19:46 moore Exp $
 *
 * $Log: costmat.h,v $
 * Revision 1.1  1994/02/17  20:19:46  moore
 * Initial revision
 *
 */

#include "graph.h"

#ifndef COSTMAT_INCLUDED

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

/* type declarations go here */

struct cost_matrix {
    int modified;		/* true iff modified since last read/save */
    int nhost;			/* number of hosts */
    int nsub;			/* number of subroutines */
    char **hosts;		/* pointers to hostnames */
    int *hflag;			/* flags for hosts */
    char **subs;		/* pointers to sub names */
    int *sflag;			/* flags for subs */
    int *mat;			/* the matrix, first dimension is by host */
    int *colors;		/* colors for each cell */
    int *hostColors;		/* colors for each host name */
    int *subColors;		/* colors for each sub name */
};

/* flags for ->hflag[] and ->sflag[] */

#define	SUBHOST_EN	1	/* host is enabled for use */
#define	SUBHOST_HOST	2	/* host is needed */
#define	SUBHOST_SUB	4	/* sub is needed */
#define SUBHOST_INPVM	8	/* host is included in pvm hosts file */


/* function declarations go here */

struct cost_matrix *cm_New __((void));
void cm_Free __((struct cost_matrix *cm));
int cm_AddEntry __((struct cost_matrix *cm, char *host, char *sub, int val));
int cm_SetColor __((struct cost_matrix *cm, int hostnum, int subnum,
		    int color));
void cm_SetAllColors __((struct cost_matrix *cm, int color));
int cm_SubrNum __((struct cost_matrix *cm, char *sub));
int cm_HostNum __((struct cost_matrix *cm, char *host));
int cm_ReadFile __((char *filename, struct cost_matrix **cmp));
int cm_WriteFile __((char *filename, struct cost_matrix *cmp));
int cm_WriteTempFile __((char *filename, struct cost_matrix *cmp));
int cm_AddHostsToPvm __((struct graph *g, struct cost_matrix *cm));
int cm_AddNamesFromGraph __((struct graph *g, struct cost_matrix *cm));
int cm_IsEmpty __((struct cost_matrix *cm));
void cm_BuildDefaultCostMatrix __((struct graph *g, struct cost_matrix *cm));
#undef __

#define COSTMAT_INCLUDED
#endif /* COSTMAT_INCLUDED */

/* Cost matrix */


