/*
 * htool version 2.x - "config" panel a.k.a. cost matrix
 * Keith Moore
 *
 * $Id: config.c,v 1.1 1994/02/17 20:19:10 moore Exp $
 *
 * $Log: config.c,v $
 * Revision 1.1  1994/02/17  20:19:10  moore
 * Initial revision
 *
 */

#include <stdio.h>
#include <varargs.h>

/*
 * from bondo...
 */
#include <Errno.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

#include "config.h"
#include "costmat.h"
#include "filenames.h"
#include "global.h"
#include "menu.h"
#include "xtglue.h"

#include "FileSelect.h"
#include "Matrix.h"

/*
 * Bondo
 */
#include <Malloc.h>

#define XtVaCMW XtVaCreateManagedWidget
#define XtGCFSW XtGlueCreateFormSubWidget

static Widget subMatrix, hostMatrix, costMatrix, horizScroll, vertScroll;
int *row_colors;
int *col_colors;
int *cell_colors;
Pixel pixels[NUM_COLORS];

/*
 * callback for whenever we change a cell
 */

static void
cell_changed (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    if (global.costMatrix->modified == 0) {
	set_costfile_label (global.costFile, 1);
	global.costMatrix->modified = 1;
    }
}


/*
 * callback to update scrollbars to reflect current positions etc.
 *
 * XXX need to call this for window resize also
 */

static void
fix_scrollbars ()
{
    int rowSpacing, colSpacing;
    int nRows, nCols;
    int rowOffset, colOffset;
    Dimension height, width;

    XtVaGetValues (costMatrix,
		   HgwNrows, &nRows,
		   HgwNcols, &nCols,
		   HgwNrowSpacing, &rowSpacing,
		   HgwNcolSpacing, &colSpacing,
		   HgwNrowOffset, &rowOffset,
		   HgwNcolOffset, &colOffset,
		   XtNheight, &height,
		   XtNwidth, &width,
		   NULL);

    /* vertical scrollbar */
    if (nRows * rowSpacing <= ((int) height))
	XawScrollbarSetThumb (vertScroll, 0.0, 1.0);
    else {
	int win_height = ((int) height) / rowSpacing;
	int total_height = nRows * rowSpacing;
	int scroll_max = nRows - 2;

	if (rowOffset > scroll_max) {
	    XtVaSetValues (hostMatrix,
			   HgwNrowOffset, scroll_max,
			   NULL);
	    XtVaSetValues (costMatrix,
			   HgwNrowOffset, scroll_max,
			   NULL);
	}
	XawScrollbarSetThumb (vertScroll,
			      (float) rowOffset / (float) scroll_max,
			      (float) height / (float) total_height);
    }

    /* horizontal scrollbar */
    if (nCols * colSpacing <= ((int) width))
	XawScrollbarSetThumb (horizScroll, 0.0, 1.0);
    else {
	int win_width = ((int) width) / colSpacing;
	int total_width = nCols * colSpacing;
	int scroll_max = nCols - 2;

	if (colOffset > scroll_max) {
	    XtVaSetValues (subMatrix,
			   HgwNcolOffset, scroll_max,
			   NULL);
	    XtVaSetValues (costMatrix,
			   HgwNcolOffset, scroll_max,
			   NULL);
	}
	XawScrollbarSetThumb (horizScroll,
			      (float) colOffset / (float) scroll_max,
			      (float) width / (float) total_width);
    }
}

/*
 * jump proc for vertical (hosts) scrollbar
 */

static void
vert_jump (w, client_data, perc)
Widget w;
XtPointer client_data;
XtPointer perc;
{
    float percent = *((float *) perc);
    int max_offset;
    Dimension height;
    int rowOffset;
    int rowSpacing;
    int nRows;

    XtVaGetValues (costMatrix,
		   XtNheight, &height,
		   HgwNrowSpacing, &rowSpacing,
		   HgwNrows, &nRows,
		   NULL);

    max_offset = nRows - 2;
    rowOffset =  (int) (percent * max_offset + 0.5);
    XtVaSetValues (costMatrix,
		   HgwNrowOffset, rowOffset,
		   NULL);
    XtVaSetValues (hostMatrix,
		   HgwNrowOffset, rowOffset,
		   NULL);
    fix_scrollbars ();
}

/*
 * jump proc for horizontal (subs) scrollbar
 */

static void
horiz_jump (w, client_data, perc)
Widget w;
XtPointer client_data;
XtPointer perc;
{
    float percent = *((float *) perc);
    int max_offset;
    Dimension width;
    int colOffset;
    int colSpacing;
    int nCols;

    XtVaGetValues (costMatrix,
		   XtNwidth, &width,
		   HgwNcolSpacing, &colSpacing,
		   HgwNcols, &nCols,
		   NULL);

    max_offset = nCols - 2;
    colOffset = (int) (percent * max_offset + 0.5);
    XtVaSetValues (costMatrix,
		   HgwNcolOffset, colOffset,
		   NULL);
    XtVaSetValues (subMatrix,
		   HgwNcolOffset, colOffset,
		   NULL);
    fix_scrollbars ();
}


/*
 * scroll proc for vertical (hosts) scrollbar
 */

static void
vert_scroll (w, client_data, position)
Widget w;
XtPointer client_data;
XtPointer position;		/* int */
{
    int pos = (int) position;
    Dimension height;
    int rowOffset;
    int rowSpacing;
    int nRows;

    XtVaGetValues (costMatrix,
		   XtNheight, &height,
		   HgwNrowOffset, &rowOffset,
		   HgwNrowSpacing, &rowSpacing,
		   HgwNrows, &nRows,
		   NULL);

    rowOffset += (pos + rowSpacing / 2) / rowSpacing;
    if (rowOffset > nRows - 2)
	rowOffset = nRows - 2;

    XtVaSetValues (hostMatrix,
		   HgwNrowOffset, &rowOffset,
		   NULL);
    XtVaSetValues (costMatrix,
		   HgwNrowOffset, &rowOffset,
		   NULL);
    fix_scrollbars ();
}


/*
 * scroll proc for horiz (subs) scrollbar
 */

static void
horiz_scroll (w, client_data, position)
Widget w;
XtPointer client_data;
XtPointer position;		/* int */
{
    int pos = (int) position;
    Dimension width;
    int colOffset;
    int colSpacing;
    int nCols;

    XtVaGetValues (costMatrix,
		   XtNwidth, &width,
		   HgwNcolOffset, &colOffset,
		   HgwNcolSpacing, &colSpacing,
		   HgwNcols, &nCols,
		   NULL);

    colOffset += (pos + colSpacing / 2) / colSpacing;
    if (colOffset > nCols - 2)
	colOffset = nCols - 2;

    XtVaSetValues (subMatrix,
		   HgwNcolOffset, &colOffset,
		   NULL);
    XtVaSetValues (costMatrix,
		   HgwNcolOffset, &colOffset,
		   NULL);
    fix_scrollbars ();
}

/*
 * update matrix widgets whenever cost matrix changes shape.
 */

void
newmatrices (m)
struct cost_matrix *m;
{
    /* if there's no widget, don't bother */
    if (costMatrix == 0)
	return;

    if (m == NULL) {
	msg_Format ("newmatrices(): no cost matrix\n");
	XtVaSetValues (subMatrix, HgwNeditable, False, NULL);
	XtVaSetValues (hostMatrix, HgwNeditable, False, NULL);
	XtVaSetValues (costMatrix, HgwNeditable, False, NULL);
	return;
    }

    
    XtVaSetValues (subMatrix, 
		   HgwNeditable, True,
		   HgwNcols, m->nsub,
		   HgwNbase, m->subs,
		   HgwNcolors, pixels,
		   HgwNnumColors, XtNumber (pixels),
		   HgwNcolorBase, m->subColors,
		   NULL);

    XtVaSetValues (hostMatrix,
		   HgwNeditable, True,
		   HgwNrows, m->nhost,
		   HgwNbase, m->hosts,
		   HgwNcolors, pixels,
		   HgwNnumColors, XtNumber (pixels),
		   HgwNcolorBase, m->hostColors,
		   NULL);

    XtVaSetValues (costMatrix,
		   HgwNeditable, True,
		   HgwNrows, m->nhost,
		   HgwNcols, m->nsub,
		   HgwNbase, m->mat,
		   HgwNcolors, pixels,
		   HgwNnumColors, XtNumber (pixels),
		   HgwNcolorBase, m->colors,
		   NULL);

    fix_scrollbars ();
}


void
make_config_panel (parent, width, height)
Widget parent;
int width, height;
{
    Widget w;
    int borderWidth = 1;
    int nrows = 1;		/* matrix widget needs >= 1 col */
    int ncols = 1;
    int cost_height, cost_width;
    Dimension defaultDistance = 4;

    if (defaults.monochrome) {
	pixels[COLOR_NORMAL] = global.whitePixel;
	pixels[COLOR_IDLE] = global.whitePixel;
	pixels[COLOR_RUNNING] = global.whitePixel;
	pixels[COLOR_BROKEN] = global.whitePixel;
	pixels[COLOR_DISABLED] = global.whitePixel;
	pixels[COLOR_DONE] = global.whitePixel;
    }
    else {
	pixels[COLOR_NORMAL] = defaults.normalColor;
	pixels[COLOR_IDLE] = defaults.idleColor;
	pixels[COLOR_RUNNING] = defaults.runningColor;
	pixels[COLOR_BROKEN] = defaults.brokenColor;
	pixels[COLOR_DISABLED] = defaults.disabledColor;
	pixels[COLOR_DONE] = defaults.doneColor;
    }

    XtVaGetValues (parent,
		   XtNdefaultDistance, &defaultDistance,
		   NULL);

    w = XtGCFSW ("subs", matrixWidgetClass, parent, North,
		 HgwNrows, 1,
		 HgwNcols, ncols,
		 NULL);
    XtAddCallback (w, XtNcallback, cell_changed, (XtPointer) NULL);
    /*
     * only allow changes in compose mode and when pvm is not running
     */
    mode_mark_widget (w, "c");
    subMatrix = w;
    
    w = XtGCFSW ("vertScroll", scrollbarWidgetClass, parent, West,
		 XtNorientation, XtorientVertical,
		 XtNheight, height, /* for starters */
		 XtNwidth, 14,
		 XtNfromVert, subMatrix,
		 XtNvertDistance, 0,
		 NULL);
    XtAddCallback (w, XtNjumpProc, vert_jump, (XtPointer) NULL);
    XtAddCallback (w, XtNscrollProc, vert_scroll, (XtPointer) NULL);
    vertScroll = w;
    XawScrollbarSetThumb (w, 0.0, 0.25);

    w = XtGCFSW ("hosts", matrixWidgetClass, parent, West,
		 HgwNrows, nrows,
		 HgwNcols, 1,
		 XtNfromVert, subMatrix,
		 XtNvertDistance, 0,
		 XtNfromHoriz, vertScroll,
		 XtNhorizDistance, 0,
		 NULL);
    XtAddCallback (w, XtNcallback, cell_changed, (XtPointer) NULL);
    /*
     * only allow changes in compose mode and when pvm is not running
     */
    mode_mark_widget (w, "c");
    hostMatrix = w;
    
    w = XtGCFSW ("costs", matrixWidgetClass, parent, Center,
		 HgwNnumeric, True,
		 HgwNrows, nrows,
		 HgwNcols, ncols,
		 XtNfromVert, subMatrix,
		 XtNvertDistance, 0,
		 XtNfromHoriz, hostMatrix,
		 XtNhorizDistance, 0,
		 NULL);
    XtAddCallback (w, XtNcallback, cell_changed, (XtPointer) NULL);
    /*
     * only allow changes in compose mode and when pvm is not running
     */
    mode_mark_widget (w, "c");
    costMatrix = w;

    w = XtGCFSW ("horizScroll", scrollbarWidgetClass, parent, South,
		 XtNorientation, XtorientHorizontal,
		 XtNwidth, width, /* for starters */
		 XtNheight, 14,
		 XtNfromVert, costMatrix,
		 XtNvertDistance, 0,
		 XtNfromHoriz, hostMatrix,
		 XtNhorizDistance, 0,
		 NULL);
    XtAddCallback (w, XtNjumpProc, horiz_jump, (XtPointer) NULL);
    XtAddCallback (w, XtNscrollProc, horiz_scroll, (XtPointer) NULL);
    horizScroll = w;
    XawScrollbarSetThumb (w, 0.0, 0.25);

    cost_height = (height - height_of (subMatrix) -
		   height_of (horizScroll) - 2);
    cost_width = (width - width_of (hostMatrix) -
		  width_of (vertScroll) - 2);

    XtVaSetValues (costMatrix,
		   XtNheight, cost_height,
		   XtNwidth, cost_width,
		   NULL);

    XtVaSetValues (hostMatrix,
		   XtNheight, cost_height,
		   NULL);

    XtVaSetValues (vertScroll,
		   XtNheight, cost_height,
		   NULL);

    XtVaSetValues (subMatrix,
		   XtNwidth, cost_width,
		   XtNfromHoriz, NULL,
		   XtNhorizDistance, (width_of (hostMatrix) +
				      width_of (vertScroll) +
				      defaultDistance),
		   NULL);

    XtVaSetValues (horizScroll,
		   XtNwidth, cost_width,
		   NULL);

    newmatrices (global.costMatrix);
}


static void
load_cost_matrix (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    int cancel;
    char filename[1024];
    struct cost_matrix *newcm, *oldcm;

    strcpy (filename, global.costFile);
    cancel = fileVerify ("Load Cost Matrix from...",
			 filename, sizeof (filename),
			 "*.mat", FS_RegularFile|FS_MustBeReadable);
    if (cancel == 0) {
	if (*filename == '\0')
	    return;
	switch (cm_ReadFile (filename, &newcm)) {
	case 1:
	    msg_Format ("can't read \"%s\": %s\n", filename,
			strerror (errno));
	    break;

	case 2:
	    msg_Format ("bad cost matrix \"%s\"\n", filename);
	    break;

	default:
	    oldcm = global.costMatrix;
	    global.costMatrix = newcm;
	    newmatrices (newcm);
	    cm_Free (oldcm);
	    msg_Format ("\"%s\": new cost matrix\n", filename);
	    set_costfile_label (make_pretty (filename), 0);
	    strcpy (global.costFile, filename);
	    break;
	}
    }
}


/*
 * save cost matrix.  If (cd == 1) don't ask for a file name
 * if we have one already.
 */

static void
save_cost_matrix (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    int cancel;
    char *prompt;
    char filename[1024];

    if (cli && global.costFile != NULL && global.costFile[0] != '\0') {
	strcpy (filename, global.costFile);
	cancel = 0;
    }
    else {
	*filename = '\0';
	prompt = "Save Cost Matrix as...";
	cancel = fileVerify (prompt, filename, sizeof(filename),
			     "*.mat", FS_RegularFile|FS_MustBeWritable);
    }

    if (!cancel) {
	if (*filename == '\0')
	    return;

	switch (cm_WriteFile (filename, global.costMatrix)) {
	case 0:
	    msg_Format ("\"%s\": cost matrix saved.\n", filename);
	    global.costMatrix->modified = 0;
	    strcpy (global.costFile, filename);
	    set_costfile_label (filename, 0);
	    break;

	case 1:
	    msg_Format ("error writing \"%s\": %s\n",
			filename, strerror (errno));
	    break;

	case 2:
	    msg_Format ("no cost matrix.\n");
	    break;
	}
    }
}

static void
new_cost_matrix (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    struct cost_matrix *new, *old;

    /*
     * XXX if cost matrix is modified, should ask whether user
     * wants to trash it before doing so.
     */

    new = cm_New ();
    newmatrices (new);
    old = global.costMatrix;
    global.costMatrix = new;
    cm_Free (old);
}

struct menu_entry pvm_file_menu[] = {
    { "c", "New", new_cost_matrix },
    { "c", "Load", load_cost_matrix },
    { "c", "Save", save_cost_matrix, (void *) 1 },
    { "c", "Save as...", save_cost_matrix, (void *) 0 },
    { NULL, NULL },
};

static void
add_host (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    cm_AddEntry (global.costMatrix, NULL, global.costMatrix->subs[0], 0);
    newmatrices (global.costMatrix);
}

static void
add_subr (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    cm_AddEntry (global.costMatrix, global.costMatrix->hosts[0], NULL, 0);
    newmatrices (global.costMatrix);
}

static void
add_names_from_graph (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
    if (cm_AddNamesFromGraph (global.graph, global.costMatrix) != 0)
	newmatrices (global.costMatrix);
}

struct menu_entry pvm_edit_menu[] = {
    { "c", "Add from Graph", add_names_from_graph },
    { "c", "Add Host", add_host },
    { "c", "Add Subr", add_subr },
#if 0
    { "c", "Delete Host" },
    { "c", "Delete Subr" },
    { "c", "Check Subrs" },
#endif
    { NULL, NULL },
};

void
config_repaint_cells (hostnum, subrnum)
int hostnum;
int subrnum;
{
#if 0
    fprintf (stderr, "config_repaint_cells (%d %d)\n", hostnum, subrnum);
#endif
#if 1
    if (hostnum > 0) {
	if (subrnum > 0)
	    MatrixRepaintCell (costMatrix, hostnum, subrnum);
	else
	    MatrixRepaintCell (hostMatrix, hostnum, 0);
    }
    else {
	if (subrnum > 0)
	    MatrixRepaintCell (subMatrix, 0, subrnum);
	else {
	    XtUnmapWidget (hostMatrix);
	    XtUnmapWidget (subMatrix);
	    XtUnmapWidget (costMatrix);
	    XtMapWidget (hostMatrix);
	    XtMapWidget (subMatrix);
	    XtMapWidget (costMatrix);
	}
    }
#else
    if (hostnum >= 0 && hostnum < global.costMatrix->nhost)
	MatrixRepaintCell (hostMatrix, hostnum, 0);
    if (subrnum >= 0 && subrnum < global.costMatrix->nsub)
	MatrixRepaintCell (subMatrix, 0, subrnum);
    if (hostnum >= 0 && hostnum < global.costMatrix->nhost &&
	subrnum >= 0 && subrnum < global.costMatrix->nsub)
	MatrixRepaintCell (costMatrix, hostnum, subrnum);
    if (hostnum < 0 && subrnum < 0) {
	XtUnmapWidget (hostMatrix);
	XtUnmapWidget (subMatrix);
	XtUnmapWidget (costMatrix);
	XtMapWidget (hostMatrix);
	XtMapWidget (subMatrix);
	XtMapWidget (costMatrix);
    }
#endif
}
