/*
 * program to build compiled-in text
 *
 * $Id: build_help.c,v 1.1 1994/02/17 20:18:58 moore Exp $
 *
 * $Log: build_help.c,v $
 * Revision 1.1  1994/02/17  20:18:58  moore
 * Initial revision
 *
 */

#include <stdio.h>

main ()
{
    int c;
    int col = 0;
    int page = -1;
    int i;

    while (1) {
	/* skip spaces, tabs, and newlines */
	while ((c = getchar ()) == ' ' || c == '\t' || c == '\n');
	if (c == EOF)
	    break;
	++page;
	printf ("#ifndef __STDC__\n");
	printf ("#define const\n");
	printf ("#endif\n");
	printf ("static const char page%d[] = {\n", page);
	col = 0;
	do {
	    if (col == 0)
		printf ("    ");
	    printf ("'\\%03o', " , c);
	    if (++col == 8) {
		printf ("\n");
		col = 0;
	    }
	    c = getchar ();
	} while (c != EOF && c != '\f');
	/* add a NUL to the end of the string */
	if (col == 0)
	    printf ("    ");
	printf ("'\\000', ");
	if (++col == 8) {
	    printf ("\n");
	    col = 0;
	}
	if (col != 0)
	    printf ("\n");
	printf ("};\n");
	if (c == EOF)
	    break;
    }
    printf ("const char *pages[] = {\n");
    for (i = 0; i <= page; ++i)
	printf ("    page%d,\n", i);
    printf ("};\n");
    exit (0);
}
