/*
 *   Matrix.h - Public Include for Matrix Widget
 *
 *   Jul 1991 Robert Manchek  manchek@CS.UTK.EDU.
 *
 * $Id: Matrix.h,v 1.1 1994/02/17 20:17:25 moore Exp $
 *
 * $Log: Matrix.h,v $
 * Revision 1.1  1994/02/17  20:17:25  moore
 * Initial revision
 *
 */

#ifndef MATRIX_INCLUDED

#include <X11/Xaw/Simple.h>
#include <X11/Xmu/Converters.h>

#ifdef __
#undef __
#endif
#if defined(__STDC__) || defined(FUNCPROTO)
#define __(x) x
#else
#define __(x) ()
#endif

/* type declarations go here */


/**************
*  Resources  *
*	      *
**************/

/*
Name		   Class	      RepType	       Default Value
----		   -----	      -------	       -------------
background	   Background	      Pixel	       XtDefaultBackground
base		   Base		      Pointer	       NULL
callback	   Callback	      Pointer	       NULL
colorBase	   ColorBase	      Integer *	       NULL
colors		   Colors	      Pixel *	       { XtDefaultBackground }
columns		   Columns	      Integer	       0
columnSpacing	   ColumnSpacing      Integer	       100
columnOffset	   ColumnOffset	      Integer	       0
cursor		   Cursor	      Cursor	       None
destroyCallback	   Callback	      Pointer	       NULL
editable	   Editable	      Boolean	       True
font		   Font		      XFontStruct*     XtDefaultFont
foreground	   Foreground	      Pixel	       XtDefaultForeground
height		   Height	      Dimension	       rows * rowSpacing
insensitiveBorder  Insensitive	      Pixmap	       Gray
mappedWhenManaged  MappedWhenManaged  Boolean	       True
numeric		   Numeric	      Boolean	       False
numColors	   NumColors	      Integer	       1
resize		   Resize	      Boolean	       True
rows		   Rows		      Integer	       0
rowSpacing	   RowSpacing	      Integer	       text height + 4
rowOffset	   RowOffset	      Integer	       0
sensitive	   Sensitive	      Boolean	       True
translations	   Translations	      TranslationTable Default
width		   Width	      Dimension	       columns * columnSpacing
x		   Position	      Position	       0
y		   Position	      Position	       0
*/

#define HgwNrows	"rows"
#define HgwNcols	"columns"
#define HgwNrowSpacing	"rowSpacing"
#define HgwNcolSpacing	"columnSpacing"
#define HgwNrowOffset	"rowOffset"
#define HgwNcolOffset	"columnOffset"
#define HgwNbase	"base"
#define HgwNeditable	"editable"
#define HgwNnumeric	"numeric"
#define HgwNcolorBase	"colorBase"
#define HgwNcolors	"colors"
#define HgwNnumColors	"numColors"

#define HgwCrows	"Rows"
#define HgwCcols	"Columns"
#define HgwCrowSpacing	"RowSpacing"
#define HgwCcolSpacing	"ColumnSpacing"
#define HgwCrowOffset	"RowOffset"
#define HgwCcolOffset	"ColumnOffset"
#define HgwCbase	"Base"
#define HgwCeditable	"Editable"
#define HgwCnumeric	"Numeric"
#define HgwCcolorBase	"ColorBase"
#define HgwCcolors	"Colors"
#define HgwCnumColors	"NumColors"

extern WidgetClass matrixWidgetClass;

typedef struct _MatrixClassRec *MatrixWidgetClass;
typedef struct _MatrixRec *MatrixWidget;

/* function declarations go here */

void MatrixRepaintCell __((Widget w, int row, int col));

#undef __

#define MATRIX_INCLUDED
#endif /* MATRIX_INCLUDED */
