/*
 * Canvas.P.h - Private Canvas widget definitions.
 *
 * Based on the Window widget by Chris Peterson, which was
 * Based upon the label widget by Charles Haynes.
 */

#ifndef _XtCanvasPrivate_h
#define _XtCanvasPrivate_h

/***********************************************************************
 *
 * Canvas Widget Private Data
 *
 ***********************************************************************/

#include "Canvas.h"

/* New fields for the Canvas widget class record */

typedef struct {int foo;} CanvasClassPart;

/* Full class record declaration */
typedef struct _CanvasClassRec {
    CoreClassPart	core_class;
    CanvasClassPart	canvas_class;
} CanvasClassRec;

extern CanvasClassRec canvasClassRec;

/* New fields for the Canvas widget record */
typedef struct {
    Pixmap pixmap;		/* The pixmap for this canvas. */
    Pixel foreground;		/* The foreground color for graphics in this
				   canvas.*/
    XFontStruct *fontinfo;
} CanvasPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _CanvasRec {
    CorePart	core;
    CanvasPart	canvas;
} CanvasRec;

#endif /* _XtCanvasPrivate_h */
/* DON'T ADD STUFF AFTER THIS #endif */

